/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgReloadRedisVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.util.Result;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmOrgRedisController"})
@CrmGlobalLog
public class MdmOrgRedisController {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgRedisController.class);
    @Autowired
    private MdmOrgService mdmOrgService;

    @PostMapping(value={"/findRedisListByOrgCodeList"})
    public Result<List<MdmOrgRedisVo>> findRedisListByOrgCodeList(@RequestBody List<String> orgCodeList) {
        return Result.ok(this.mdmOrgService.findRedisListByOrgCodeList(orgCodeList));
    }

    @PostMapping(value={"/findRedisOrgParentListByCodeList"})
    public Result<List<MdmOrgParentChildrenRedisVo>> findRedisOrgParentListByCodeList(@RequestBody List<String> orgCodeList) {
        return Result.ok(this.mdmOrgService.findRedisOrgParentListByCodeList(orgCodeList));
    }

    @PostMapping(value={"/findRedisOrgChildrenListByCodeList"})
    public Result<List<MdmOrgParentChildrenRedisVo>> findRedisOrgChildrenListByCodeList(@RequestBody List<String> orgCodeList) {
        return Result.ok(this.mdmOrgService.findRedisOrgChildrenListByCodeList(orgCodeList));
    }

    @PostMapping(value={"/findRedisReloadList"})
    public Result<List<MdmOrgReloadRedisVo>> findRedisReloadList() {
        return Result.ok(this.mdmOrgService.findRedisReloadList());
    }
}

