/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pricesetting.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceSettingRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmPriceSettingController"})
@Api(tags={"\u4ef7\u683c\u7ef4\u62a4\u4e3b\u8868 "})
@CrmGlobalLog
public class MdmPriceSettingController {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceSettingController.class);
    @Autowired
    private IMdmPriceSettingService mdmPriceSettingService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmDictMethod
    public Result<PageResult<MdmPriceSettingRespVo>> list(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        PageResult<MdmPriceSettingRespVo> result = this.mdmPriceSettingService.findList(mdmPriceSettingReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6821\u9a8c\u5f53\u524d\u65f6\u95f4\u662f\u5426\u4f1a\u53d1\u751f\u622a\u65ad")
    @PostMapping(value={"/checkTruncationTime"})
    public Result<Boolean> checkTruncationTime(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        return Result.ok((Object)this.mdmPriceSettingService.checkTimeTruncation(mdmPriceSettingReqVo));
    }

    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6\u67e5\u8be2\u552f\u4e00\u4ef7\u683c,\u591a\u6761\u8fd4\u56de\u9519\u8bef\u4fe1\u606f")
    @PostMapping(value={"/queryUnique"})
    public Result<MdmPriceSettingRespVo> queryUnique(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        MdmPriceSettingRespVo respVo = this.mdmPriceSettingService.queryUnique(mdmPriceSettingReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, paramType="query")})
    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmDictMethod
    public Result<MdmPriceSettingRespVo> query(@RequestParam(value="id") String id) {
        MdmPriceSettingReqVo mdmPriceSettingReqVo = new MdmPriceSettingReqVo();
        mdmPriceSettingReqVo.setId(id);
        MdmPriceSettingRespVo respVo = this.mdmPriceSettingService.query(mdmPriceSettingReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        this.mdmPriceSettingService.save(mdmPriceSettingReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u65b0\u589e\u65f6\u95f4\u4ea4\u53c9\u6821\u9a8c")
    @PostMapping(value={"/checkDate"})
    public Result checkDate(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        Boolean result = this.mdmPriceSettingService.checkDate(mdmPriceSettingReqVo);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        this.mdmPriceSettingService.update(mdmPriceSettingReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        MdmPriceSettingReqVo mdmPriceSettingReqVo = new MdmPriceSettingReqVo();
        mdmPriceSettingReqVo.setIds(ids);
        this.mdmPriceSettingService.deleteBatch(mdmPriceSettingReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        MdmPriceSettingReqVo mdmPriceSettingReqVo = new MdmPriceSettingReqVo();
        mdmPriceSettingReqVo.setIds(ids);
        this.mdmPriceSettingService.enableBatch(mdmPriceSettingReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        MdmPriceSettingReqVo mdmPriceSettingReqVo = new MdmPriceSettingReqVo();
        mdmPriceSettingReqVo.setIds(ids);
        this.mdmPriceSettingService.disableBatch(mdmPriceSettingReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u5ba2\u6237\u4e0b\u62c9\u6846")
    @PostMapping(value={"/findCustomerSelectList"})
    public Result<List<MdmCustomerMsgSelectRespVo>> findCustomerSelectList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return Result.ok(this.mdmPriceSettingService.findCustomerSelectList(mdmCustomerMsgReqVo));
    }

    @ApiOperation(value="\u5546\u54c1\u4e0b\u62c9\u6846")
    @PostMapping(value={"/findProductSelectList"})
    @CrmDictMethod
    public Result<List<MdmProductRespVo>> findProductSelectList(@RequestBody MdmProductReqVo mdmProductReqVo) {
        return Result.ok(this.mdmPriceSettingService.findProductSelectList(mdmProductReqVo));
    }

    @ApiOperation(value="\u5ba2\u6237\u4ef7\u683c\u67e5\u8be2")
    @PostMapping(value={"/search"})
    public Result<Map<String, Map<String, MdmPriceResp>>> search(@RequestBody MdmPriceSearchReqVo mdmPriceSearchReqVo) {
        Map<String, Map<String, MdmPriceResp>> map = this.mdmPriceSettingService.search(mdmPriceSearchReqVo);
        return Result.ok(map);
    }

    @ApiOperation(value="\u8be2\u4ef7")
    @PostMapping(value={"/inquiry"})
    public Result<Map<String, Map<String, MdmPriceResp>>> inquiry(@RequestBody MdmPriceSearchReqVo mdmPriceSearchReqVo) {
        return Result.ok(this.mdmPriceSettingService.inquiry(mdmPriceSearchReqVo));
    }
}

