/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sync.service.impl;

import com.biz.crm.annotation.Klock;
import com.biz.crm.dict.model.MdmDictAttrConfEntity;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.model.MdmDictTypeEntity;
import com.biz.crm.dict.service.MdmDictAttrConfService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.dict.service.MdmDictTypeService;
import com.biz.crm.nebular.mdm.sync.MdmDictEngineSyncVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncBaseReqVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncDictReqVo;
import com.biz.crm.sync.config.MdmSyncParameterParser;
import com.biz.crm.sync.config.MdmSyncProperty;
import com.biz.crm.sync.service.MdmDictSyncService;
import com.biz.crm.util.CrmBeanUtil;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmDictSyncServiceExpandImpl"})
public class MdmDictSyncServiceImpl
implements MdmDictSyncService {
    private static final Logger log = LoggerFactory.getLogger(MdmDictSyncServiceImpl.class);
    @Autowired
    private MdmSyncProperty mdmSyncProperty;
    @Autowired
    private MdmDictTypeService mdmDictTypeService;
    @Autowired
    private MdmDictDataService mdmDictDataService;
    @Autowired
    private MdmDictAttrConfService mdmDictAttrConfService;

    @Override
    @Klock
    public void dictSync(MdmSyncDictReqVo mdmSyncDictReqVo) {
        MdmDictEngineSyncVo mdmDictEngineSyncVo = MdmSyncParameterParser.obtainOriginalData((MdmSyncBaseReqVo)mdmSyncDictReqVo, this.mdmSyncProperty, "/mdm/mdmdicttype/obtainSyncList", mdmSyncDictReqVo, MdmDictEngineSyncVo.class);
        this.saveType(mdmSyncDictReqVo, mdmDictEngineSyncVo);
        this.saveData(mdmSyncDictReqVo, mdmDictEngineSyncVo);
        this.saveConfig(mdmSyncDictReqVo, mdmDictEngineSyncVo);
        this.mdmDictTypeService.deleteAllCache();
    }

    protected void saveConfig(MdmSyncDictReqVo mdmSyncDictReqVo, MdmDictEngineSyncVo mdmDictEngineSyncVo) {
        List mdmDictAttrConfEntities;
        List mdmDictAttrConfRespVoList = mdmDictEngineSyncVo.getMdmDictAttrConfRespVoList();
        if (!CollectionUtils.isEmpty((Collection)mdmDictAttrConfRespVoList) && !CollectionUtils.isEmpty((Collection)(mdmDictAttrConfEntities = CrmBeanUtil.copyList((List)mdmDictAttrConfRespVoList, MdmDictAttrConfEntity.class)))) {
            this.mdmDictAttrConfService.saveOrUpdateBatch(mdmDictAttrConfEntities);
        }
    }

    protected void saveData(MdmSyncDictReqVo mdmSyncDictReqVo, MdmDictEngineSyncVo mdmDictEngineSyncVo) {
        List mdmDictDataEntities;
        List mdmDictDataRespVoList = mdmDictEngineSyncVo.getMdmDictDataRespVoList();
        if (!CollectionUtils.isEmpty((Collection)mdmDictDataRespVoList) && !CollectionUtils.isEmpty((Collection)(mdmDictDataEntities = CrmBeanUtil.copyList((List)mdmDictDataRespVoList, MdmDictDataEntity.class)))) {
            this.mdmDictDataService.saveOrUpdateBatch(mdmDictDataEntities);
        }
    }

    protected void saveType(MdmSyncDictReqVo mdmSyncDictReqVo, MdmDictEngineSyncVo mdmDictEngineSyncVo) {
        List mdmDictTypeRespVoList = mdmDictEngineSyncVo.getMdmDictTypeRespVoList();
        Assert.notEmpty((Collection)mdmDictTypeRespVoList, (String)"\u5b57\u5178\u7c7b\u578b\u67e5\u8be2\u4e3a\u7a7a");
        List mdmDictTypeEntities = CrmBeanUtil.copyList((List)mdmDictTypeRespVoList, MdmDictTypeEntity.class);
        if (!CollectionUtils.isEmpty((Collection)mdmDictTypeEntities)) {
            this.mdmDictTypeService.saveOrUpdateBatch(mdmDictTypeEntities);
        }
    }
}

