/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.notice.mapper.MdmNoticeCommentLikesMapper;
import com.biz.crm.notice.mapper.MdmNoticeCommentMapper;
import com.biz.crm.notice.model.MdmNoticeCommentEntity;
import com.biz.crm.notice.model.MdmNoticeCommentLikesEntity;
import com.biz.crm.notice.service.IMdmNoticeCommentLikesService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MdmNoticeCommentLikesServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmNoticeCommentLikesMapper, MdmNoticeCommentLikesEntity>
implements IMdmNoticeCommentLikesService {
    @Resource
    private MdmNoticeCommentLikesMapper mdmNoticeCommentLikesMapper;
    @Resource
    private MdmNoticeCommentMapper mdmNoticeCommentMapper;

    @Override
    public Integer getTotalCommentLikes(String commentId) {
        return this.mdmNoticeCommentLikesMapper.getTotalCommentLikes(commentId);
    }

    @Override
    public void like(String commentId) {
        if (this.doCheck(commentId)) {
            throw new BusinessException("\u60a8\u5df2\u7ecf\u70b9\u8fc7\u8d5e\u4e86\uff01");
        }
        MdmNoticeCommentLikesEntity mdmNoticeCommentLikesEntity = new MdmNoticeCommentLikesEntity();
        mdmNoticeCommentLikesEntity.setCommentId(commentId);
        this.mdmNoticeCommentLikesMapper.insert(mdmNoticeCommentLikesEntity);
    }

    @Override
    public void cancelLike(String commentId) {
        if (!this.doCheck(commentId)) {
            throw new BusinessException("\u60a8\u8fd8\u6ca1\u6709\u70b9\u8d5e\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"comment_id", (Object)commentId)).eq((Object)"create_code", (Object)UserUtils.getUser().getUsername());
        this.mdmNoticeCommentLikesMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    public boolean doCheck(String commentId) {
        AssertUtils.isNotEmpty((String)commentId, (String)"\u8bc4\u8bbaid\u4e0d\u80fd\u4e3a\u7a7a");
        MdmNoticeCommentEntity noticeCommentEntity = (MdmNoticeCommentEntity)this.mdmNoticeCommentMapper.selectById((Serializable)((Object)commentId));
        Assert.notNull((Object)noticeCommentEntity, (String)"\u8be5\u8bc4\u8bba\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u4e86");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"create_code", (Object)UserUtils.getUser().getUsername())).eq((Object)"comment_id", (Object)commentId);
        MdmNoticeCommentLikesEntity entity = (MdmNoticeCommentLikesEntity)this.mdmNoticeCommentLikesMapper.selectOne((Wrapper)queryWrapper);
        if (null == entity) {
            return false;
        }
        String id = entity.getId();
        return StringUtils.isNotEmpty((String)id);
    }
}

