/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationTerminalReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRelationTerminalPageRespVo;
import com.biz.crm.position.service.MdmPositionRelationTerminalService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmPositionRelationTerminalController"})
@Api(tags={"MDM-\u804c\u4f4d\u7ba1\u7406-\u5173\u8054\u7ec8\u7aef"})
@CrmGlobalLog
public class MdmPositionRelationTerminalController {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionRelationTerminalController.class);
    @Autowired
    private MdmPositionRelationTerminalService mdmPositionRelationTerminalService;

    @ApiOperation(value="\u67e5\u8be2\u672a\u5173\u8054\u4efb\u4f55\u804c\u4f4d\u7684\u7ec8\u7aef")
    @PostMapping(value={"/findTerminalNotRelateAnyPosition"})
    @CrmDictMethod
    public Result<PageResult<MdmPositionRelationTerminalPageRespVo>> findTerminalNotRelateAnyPosition(@RequestBody MdmPositionRelationTerminalPageReqVo reqVo) {
        return Result.ok(this.mdmPositionRelationTerminalService.findTerminalNotRelateAnyPosition(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u5173\u8054\u5f53\u524d\u804c\u4f4d\u7684\u7ec8\u7aef", notes="positionCode\u5fc5\u4f20")
    @PostMapping(value={"/findTerminalNotRelateCurPosition"})
    @CrmDictMethod
    public Result<PageResult<MdmPositionRelationTerminalPageRespVo>> findTerminalNotRelateCurPosition(@RequestBody MdmPositionRelationTerminalPageReqVo reqVo) {
        return Result.ok(this.mdmPositionRelationTerminalService.findTerminalNotRelateCurPosition(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u5df2\u5173\u8054\u5f53\u524d\u804c\u4f4d\u7684\u7ec8\u7aef", notes="positionCode\u5fc5\u4f20")
    @PostMapping(value={"/findTerminalHasRelateCurPosition"})
    @CrmDictMethod
    public Result<PageResult<MdmPositionRelationTerminalPageRespVo>> findTerminalHasRelateCurPosition(@RequestBody MdmPositionRelationTerminalPageReqVo reqVo) {
        return Result.ok(this.mdmPositionRelationTerminalService.findTerminalHasRelateCurPosition(reqVo));
    }

    @ApiOperation(value="\u6dfb\u52a0\u804c\u4f4d\u4e0e\u7ec8\u7aef\u7684\u5173\u8054", notes="\u4f20\uff08terminalCodeList\u3001positionCode\uff09")
    @PostMapping(value={"/bindRelation"})
    public Result bindRelation(@RequestBody MdmPositionRelationTerminalReqVo reqVo) {
        this.mdmPositionRelationTerminalService.bindRelation(reqVo.getTerminalCodeList(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value="\u66ff\u6362\u7ec8\u7aef\u4e0a\u5173\u8054\u804c\u4f4d", notes="\u4f20\uff08ids\u3001positionCode\uff09")
    @PostMapping(value={"/replaceTerminalPosition"})
    public Result replaceTerminalPosition(@RequestBody MdmPositionRelationTerminalReqVo reqVo) {
        this.mdmPositionRelationTerminalService.replaceTerminalPosition(reqVo.getIds(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value="\u89e3\u9664\u804c\u4f4d\u4e0e\u7ec8\u7aef\u7684\u5173\u8054", notes="\u4f20\u5173\u8054\u8868id\u96c6\u5408", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u5173\u8054\u5173\u7cfbid\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unbindRelation"})
    public Result unbindRelation(@RequestBody List<String> ids) {
        this.mdmPositionRelationTerminalService.unbindRelation(ids);
        return Result.ok();
    }
}

