/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.service.impl;

import com.biz.crm.eunm.FileTypeEnum;
import com.biz.crm.eunm.IsShelfEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.model.MdmProductIntroductionEntity;
import com.biz.crm.product.model.MdmProductMaterialEntity;
import com.biz.crm.product.model.MdmProductMediaEntity;
import com.biz.crm.product.service.impl.MdmProductServiceHelper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdmProductBuilder {
    private static final Logger log = LoggerFactory.getLogger(MdmProductBuilder.class);
    private MdmProductServiceHelper helper;
    private MdmProductReqVo reqVo;
    private MdmProductEntity productEntity;
    private MdmProductIntroductionEntity introductionEntity;
    private List<MdmProductMediaEntity> mediaEntities = Lists.newArrayList();
    private List<MdmProductMaterialEntity> materialEntities = Lists.newArrayList();

    public MdmProductBuilder(MdmProductServiceHelper helper, MdmProductReqVo reqVo) {
        this.helper = helper;
        this.reqVo = reqVo;
    }

    public static MdmProductBuilder builder(MdmProductServiceHelper helper, MdmProductReqVo reqVo) {
        return new MdmProductBuilder(helper, reqVo);
    }

    public MdmProductBuilder init() {
        return this;
    }

    public MdmProductBuilder check() {
        AssertUtils.isNotEmpty((String)this.reqVo.getProductCode(), (String)"\u8bf7\u8f93\u5165\u5546\u54c1\u7f16\u7801");
        AssertUtils.isNotEmpty((String)this.reqVo.getProductName(), (String)"\u8bf7\u8f93\u5165\u5546\u54c1\u540d\u79f0");
        return this;
    }

    public MdmProductBuilder convert() {
        MdmProductEntity mdmProductEntity = new MdmProductEntity();
        CrmBeanUtil.copyProperties((Object)this.reqVo, (Object)mdmProductEntity);
        if (StringUtils.isEmpty((CharSequence)mdmProductEntity.getIsShelf())) {
            mdmProductEntity.setIsShelf(IsShelfEnum.DOWN.getCode());
        }
        this.productEntity = mdmProductEntity;
        if (!CollectionUtils.isEmpty((Collection)this.reqVo.getMaterialList())) {
            this.materialEntities = this.reqVo.getMaterialList().stream().map(o -> {
                MdmProductMaterialEntity materialEntity = new MdmProductMaterialEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)materialEntity);
                materialEntity.setId(UUID.randomUUID().toString());
                materialEntity.setProductCode(mdmProductEntity.getProductCode());
                return materialEntity;
            }).collect(Collectors.toList());
        }
        List pictureList = null;
        if (!CollectionUtils.isEmpty((Collection)this.reqVo.getPictureList())) {
            pictureList = this.reqVo.getPictureList().stream().filter(Objects::nonNull).map(o -> {
                MdmProductMediaEntity mediaEntity = new MdmProductMediaEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)mediaEntity);
                mediaEntity.setType(FileTypeEnum.PICTURE.getCode());
                mediaEntity.setProductCode(mdmProductEntity.getProductCode());
                return mediaEntity;
            }).collect(Collectors.toList());
            this.productEntity.setPrimaryPictureUrl(((MdmProductMediaRespVo)this.reqVo.getPictureList().get(0)).getUrlAddress());
        }
        if (CollectionUtil.listNotEmpty(pictureList)) {
            this.mediaEntities.addAll(pictureList);
        }
        List videoList = null;
        if (!CollectionUtils.isEmpty((Collection)this.reqVo.getVideoList())) {
            videoList = this.reqVo.getVideoList().stream().filter(Objects::nonNull).map(o -> {
                MdmProductMediaEntity mediaEntity = new MdmProductMediaEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)mediaEntity);
                mediaEntity.setProductCode(mdmProductEntity.getProductCode());
                mediaEntity.setType(FileTypeEnum.VIDEO.getCode());
                return mediaEntity;
            }).collect(Collectors.toList());
        }
        if (CollectionUtil.listNotEmpty(videoList)) {
            this.mediaEntities.addAll(videoList);
        }
        if (Objects.nonNull(this.reqVo.getIntroductionVo())) {
            MdmProductIntroductionEntity introductionEntity = new MdmProductIntroductionEntity();
            CrmBeanUtil.copyProperties((Object)this.reqVo.getIntroductionVo(), (Object)introductionEntity);
            introductionEntity.setProductCode(mdmProductEntity.getProductCode());
            this.introductionEntity = introductionEntity;
        }
        return this;
    }

    public void save() {
        this.validDetails();
        this.helper.saveProductEntity(this.productEntity);
        this.helper.saveProductIntroduction(this.introductionEntity, Boolean.TRUE, this.productEntity.getProductCode());
        this.helper.saveProductMaterials(this.materialEntities, Boolean.TRUE, this.productEntity.getProductCode());
        this.helper.saveProductMedias(this.mediaEntities, Boolean.TRUE, this.productEntity.getProductCode());
    }

    protected void validDetails() {
        if (!CollectionUtils.isEmpty(this.mediaEntities)) {
            this.productEntity.setMaintenancePicture(YesNoEnum.yesNoEnum.ONE.getValue());
        } else {
            this.productEntity.setMaintenancePicture(YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        if (this.introductionEntity != null && !StringUtils.isEmpty((CharSequence)this.introductionEntity.getIntroductionText())) {
            this.productEntity.setMaintenanceIntroduction(YesNoEnum.yesNoEnum.ONE.getValue());
        } else {
            this.productEntity.setMaintenanceIntroduction(YesNoEnum.yesNoEnum.ZERO.getValue());
        }
    }

    public void update() {
        this.validDetails();
        this.helper.saveProductEntity(this.productEntity);
        this.helper.saveProductIntroduction(this.introductionEntity, Boolean.FALSE, this.productEntity.getProductCode());
        this.helper.saveProductMaterials(this.materialEntities, Boolean.FALSE, this.productEntity.getProductCode());
        this.helper.saveProductMedias(this.mediaEntities, Boolean.FALSE, this.productEntity.getProductCode());
    }
}

