/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.approval.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.approval.mapper.MdmApprovalConfigSubmitterMapper;
import com.biz.crm.approval.model.MdmApprovalConfigSubmitterEntity;
import com.biz.crm.approval.service.MdmApprovalConfigSubmitterService;
import com.biz.crm.nebular.mdm.approval.req.MdmApprovalConfigSubmitterReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigSubmitterRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmApprovalConfigSubmitterServiceExpandImpl"})
public class MdmApprovalConfigSubmitterServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmApprovalConfigSubmitterMapper, MdmApprovalConfigSubmitterEntity>
implements MdmApprovalConfigSubmitterService {
    private static final Logger log = LoggerFactory.getLogger(MdmApprovalConfigSubmitterServiceImpl.class);
    @Resource
    private MdmApprovalConfigSubmitterMapper mdmApprovalConfigSubmitterMapper;

    @Override
    public List<MdmApprovalConfigSubmitterRespVo> findSubmitterList(String businessCode) {
        Assert.hasText((String)businessCode, (String)"\u7f3a\u5931\u4e1a\u52a1\u7f16\u7801");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmApprovalConfigSubmitterEntity::getBusinessCode, (Object)businessCode)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return CrmBeanUtil.copyList((List)list, MdmApprovalConfigSubmitterRespVo.class);
        }
        return new ArrayList<MdmApprovalConfigSubmitterRespVo>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSubmitterList(String businessCode, List<MdmApprovalConfigSubmitterReqVo> conditionList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(conditionList)) {
            Assert.hasText((String)businessCode, (String)"\u7f3a\u5931\u4e1a\u52a1\u7f16\u7801");
            List collect = conditionList.stream().map(x -> {
                MdmApprovalConfigSubmitterEntity copy = (MdmApprovalConfigSubmitterEntity)CrmBeanUtil.copy((Object)x, MdmApprovalConfigSubmitterEntity.class);
                copy.setBusinessCode(businessCode);
                return copy;
            }).collect(Collectors.toList());
            this.saveBatch(collect);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSubmitterList(String businessCode) {
        Assert.hasText((String)businessCode, (String)"\u7f3a\u5931\u4e1a\u52a1\u7f16\u7801");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmApprovalConfigSubmitterEntity::getBusinessCode, (Object)businessCode)).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSubmitterList(List<String> businessCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(businessCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmApprovalConfigSubmitterEntity::getBusinessCode, businessCodeList)).remove();
        }
    }
}

