/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRegionReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRegionRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.org.mapper.MdmOrgRegionMapper;
import com.biz.crm.org.model.MdmOrgRegionEntity;
import com.biz.crm.org.service.MdmOrgRegionService;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.region.service.MdmRegionService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmOrgRegionServiceExpandImpl"})
public class MdmOrgRegionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmOrgRegionMapper, MdmOrgRegionEntity>
implements MdmOrgRegionService {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgRegionServiceImpl.class);
    @Resource
    private MdmOrgRegionMapper mdmOrgRegionMapper;
    @Resource
    private MdmRegionService mdmRegionService;
    @Resource
    private MdmOrgService mdmOrgService;

    @Override
    public List<MdmOrgRegionRespVo> findOrgRegionList(MdmOrgRegionReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.mdmOrgRegionMapper.findOrgRegionList(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrgRegion(MdmOrgRegionReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        MdmOrgRespVo org = this.mdmOrgService.detail(null, reqVo.getOrgCode());
        Assert.notNull((Object)org, (String)"\u7ec4\u7ec7\u7f16\u7801\u65e0\u6548");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmOrgRegionEntity::getOrgCode, (Object)reqVo.getOrgCode())).remove();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getRegionList())) {
            List<MdmOrgRegionReqVo> regionList = this.verify(reqVo);
            List list = CrmBeanUtil.copyList(regionList, MdmOrgRegionEntity.class);
            this.saveBatch(list);
        }
    }

    @Override
    public List<MdmOrgRegionRespVo> findOrgRegionByOrgCodeList(List<String> orgCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgRegionEntity::getOrgCode, orgCodeList)).list()))) {
            return CrmBeanUtil.copyList((List)list, MdmOrgRegionRespVo.class);
        }
        return new ArrayList<MdmOrgRegionRespVo>();
    }

    private List<MdmOrgRegionReqVo> verify(MdmOrgRegionReqVo reqVo) {
        List regionList = reqVo.getRegionList();
        ArrayList<MdmOrgRegionReqVo> resultList = new ArrayList<MdmOrgRegionReqVo>();
        HashSet regionCodeList = new HashSet(16);
        regionCodeList.addAll(regionList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getCountryCode())).map(MdmOrgRegionReqVo::getCountryCode).collect(Collectors.toSet()));
        regionCodeList.addAll(regionList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getProvinceCode())).map(MdmOrgRegionReqVo::getProvinceCode).collect(Collectors.toSet()));
        regionCodeList.addAll(regionList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getCityCode())).map(MdmOrgRegionReqVo::getCityCode).collect(Collectors.toSet()));
        regionCodeList.addAll(regionList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getDistrictCode())).map(MdmOrgRegionReqVo::getDistrictCode).collect(Collectors.toSet()));
        regionCodeList.addAll(regionList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getTownshipCode())).map(MdmOrgRegionReqVo::getTownshipCode).collect(Collectors.toSet()));
        Map<String, String> regionMap = this.mdmRegionService.getRegionCodeNameMap(new ArrayList<String>(regionCodeList));
        String countryShow = ParamUtil.getParameterValue((String)"mdm_region_show_control_country");
        Assert.hasText((String)countryShow, (String)"\u5168\u5c40\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        for (int i = 0; i < regionList.size(); ++i) {
            try {
                MdmOrgRegionReqVo item2 = (MdmOrgRegionReqVo)regionList.get(i);
                MdmOrgRegionReqVo newItem = new MdmOrgRegionReqVo();
                resultList.add(newItem);
                newItem.setOrgCode(reqVo.getOrgCode());
                if (YesNoEnum.yesNoEnum.Y.getValue().equals(countryShow)) {
                    Assert.hasText((String)item2.getCountryCode(), (String)"\u56fd\u5bb6\u5fc5\u586b");
                    Assert.isTrue((boolean)regionMap.containsKey(item2.getCountryCode()), (String)"\u56fd\u5bb6\u7f16\u7801\u6709\u8bef");
                    newItem.setCountryCode(item2.getCountryCode());
                } else {
                    Assert.hasText((String)item2.getProvinceCode(), (String)"\u7701\u4efd\u5fc5\u586b");
                }
                if (StringUtils.isEmpty((String)item2.getProvinceCode())) continue;
                Assert.isTrue((boolean)regionMap.containsKey(item2.getProvinceCode()), (String)"\u7701\u4efd\u7f16\u7801\u6709\u8bef");
                newItem.setProvinceCode(item2.getProvinceCode());
                if (StringUtils.isEmpty((String)item2.getCityCode())) continue;
                Assert.isTrue((boolean)regionMap.containsKey(item2.getCityCode()), (String)"\u5e02\u7f16\u7801\u6709\u8bef");
                newItem.setCityCode(item2.getCityCode());
                if (StringUtils.isEmpty((String)item2.getDistrictCode())) continue;
                Assert.isTrue((boolean)regionMap.containsKey(item2.getDistrictCode()), (String)"\u533a\u53bf\u7f16\u7801\u6709\u8bef");
                newItem.setDistrictCode(item2.getDistrictCode());
                if (StringUtils.isEmpty((String)item2.getTownshipCode())) continue;
                Assert.isTrue((boolean)regionMap.containsKey(item2.getTownshipCode()), (String)"\u4e61\u9547\u7f16\u7801\u6709\u8bef");
                newItem.setTownshipCode(item2.getTownshipCode());
                continue;
            }
            catch (BusinessException e) {
                throw new BusinessException("\u7b2c" + (i + 1) + "\u884c\uff1a" + e.getMsg());
            }
        }
        LinkedHashMap<String, Integer> uniqueKeyMap = new LinkedHashMap<String, Integer>(16);
        for (int i = 0; i < resultList.size(); ++i) {
            try {
                Map<String, MdmOrgRegionEntity> uniqueKeyList;
                MdmOrgRegionReqVo item3 = (MdmOrgRegionReqVo)resultList.get(i);
                String key = this.generateUniqueKey(item3.getCountryCode(), item3.getProvinceCode(), item3.getCityCode(), item3.getDistrictCode(), item3.getTownshipCode());
                for (Map.Entry entry : uniqueKeyMap.entrySet()) {
                    if (((String)entry.getKey()).equals(key)) {
                        throw new BusinessException("\u4e0e\u7b2c" + entry.getValue() + "\u884c\u91cd\u590d");
                    }
                    if (!((String)entry.getKey()).startsWith(key) && !key.startsWith((String)entry.getKey())) continue;
                    throw new BusinessException("\u4e0e\u7b2c" + entry.getValue() + "\u884c\u5b58\u5728\u5305\u542b\u5173\u7cfb");
                }
                uniqueKeyMap.put(key, i + 1);
                List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)item3.getCountryCode()), MdmOrgRegionEntity::getCountryCode, (Object)item3.getCountryCode())).eq(StringUtils.isNotEmpty((String)item3.getProvinceCode()), MdmOrgRegionEntity::getProvinceCode, (Object)item3.getProvinceCode())).eq(StringUtils.isNotEmpty((String)item3.getCityCode()), MdmOrgRegionEntity::getCityCode, (Object)item3.getCityCode())).eq(StringUtils.isNotEmpty((String)item3.getDistrictCode()), MdmOrgRegionEntity::getDistrictCode, (Object)item3.getDistrictCode())).eq(StringUtils.isNotEmpty((String)item3.getTownshipCode()), MdmOrgRegionEntity::getTownshipCode, (Object)item3.getTownshipCode())).list().stream().filter(x -> !reqVo.getOrgCode().equals(x.getOrgCode())).collect(Collectors.toList());
                if (!CollectionUtil.listNotEmptyNotSizeZero(list) || !(uniqueKeyList = list.stream().collect(Collectors.toMap(k -> this.generateUniqueKey(k.getCountryCode(), k.getProvinceCode(), k.getCityCode(), k.getDistrictCode(), k.getTownshipCode()), v -> v))).containsKey(key)) continue;
                MdmOrgRegionEntity orgRegion = uniqueKeyList.get(key);
                String useOrgName = ((MdmOrgRegionEntity)list.get(0)).getOrgCode();
                Map<String, String> orgCodeNameMap = this.mdmOrgService.getOrgCodeNameMap(list.stream().map(MdmOrgRegionEntity::getOrgCode).collect(Collectors.toList()));
                Iterator<Map.Entry<String, String>> iterator = orgCodeNameMap.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    useOrgName = entry.getValue();
                }
                String name = (StringUtils.isEmpty((String)orgRegion.getCountryCode()) ? "" : regionMap.get(orgRegion.getCountryCode())) + (StringUtils.isEmpty((String)orgRegion.getProvinceCode()) ? "" : regionMap.get(orgRegion.getProvinceCode())) + (StringUtils.isEmpty((String)orgRegion.getCityCode()) ? "" : regionMap.get(orgRegion.getCityCode())) + (StringUtils.isEmpty((String)orgRegion.getDistrictCode()) ? "" : regionMap.get(orgRegion.getDistrictCode())) + (StringUtils.isEmpty((String)orgRegion.getTownshipCode()) ? "" : regionMap.get(orgRegion.getTownshipCode()));
                throw new BusinessException(name + "\u5df2\u7ecf\u88ab[" + useOrgName + "]\u5173\u8054");
            }
            catch (BusinessException e) {
                throw new BusinessException("\u7b2c" + (i + 1) + "\u884c\uff1a" + e.getMsg());
            }
        }
        return resultList;
    }

    private String generateUniqueKey(String countryCode, String provinceCode, String cityCode, String districtCode, String townshipCode) {
        return "_" + (StringUtils.isEmpty((String)countryCode) ? "" : countryCode + "_") + (StringUtils.isEmpty((String)provinceCode) ? "" : provinceCode + "_") + (StringUtils.isEmpty((String)cityCode) ? "" : cityCode + "_") + (StringUtils.isEmpty((String)districtCode) ? "" : districtCode + "_") + (StringUtils.isEmpty((String)townshipCode) ? "" : townshipCode + "_");
    }
}

