/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.permission.manager;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.eunm.mdm.MdmPermissionObjEnum;
import com.biz.crm.eunm.mdm.PermissionResourceEnum;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionDetailVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.permission.manager.MdmDataPermissionProcessor;
import com.biz.crm.permission.model.MdmDataPermissionExtendDetailEntity;
import com.biz.crm.permission.model.MdmDataPermissionExtendEntity;
import com.biz.crm.permission.service.IMdmDataPermissionExtendDetailService;
import com.biz.crm.permission.service.IMdmDataPermissionExtendService;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PositionUtil;
import com.bizunited.platform.common.vo.UuidVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmDataPermissionPositionExpandProcessor"})
public class MdmDataPermissionPositionProcessor
implements MdmDataPermissionProcessor {
    private static final Logger log = LoggerFactory.getLogger(MdmDataPermissionPositionProcessor.class);
    @Autowired
    private IMdmDataPermissionExtendService mdmDataPermissionExtendService;
    @Autowired
    private IMdmDataPermissionExtendDetailService mdmDataPermissionExtendDetailService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmDataPermissionVo mdmDataPermissionVo) {
        log.info("\u6570\u636e\u6743\u9650:\u4fdd\u5b58\uff1a\u804c\u4f4d\uff1a\u5165\u53c2:{}", (Object)JsonPropertyUtil.toJsonString((Object)mdmDataPermissionVo));
        String functionCode = mdmDataPermissionVo.getFunctionCode();
        String listConfigCode = mdmDataPermissionVo.getListConfigCode();
        String roleCode = mdmDataPermissionVo.getRoleCode();
        List mdmDataPermissionDetailVos = mdmDataPermissionVo.getMdmDataPermissionDetailVos();
        if (CollectionUtils.isEmpty((Collection)mdmDataPermissionDetailVos)) {
            return;
        }
        ArrayList<MdmDataPermissionExtendDetailEntity> extendDetailEntities = new ArrayList<MdmDataPermissionExtendDetailEntity>();
        List<MdmDataPermissionExtendEntity> entityList = mdmDataPermissionDetailVos.stream().filter(x -> MdmPermissionObjEnum.POSITION.getCode().equals(x.getPermissionObjCode())).map(x -> {
            List codeList;
            MdmDataPermissionExtendEntity extendEntity = new MdmDataPermissionExtendEntity();
            String id = UUID.randomUUID().toString();
            extendEntity.setId(id);
            extendEntity.setFunctionCode(functionCode);
            extendEntity.setListConfigCode(listConfigCode);
            extendEntity.setRoleCode(roleCode);
            extendEntity.setPermissionObjCode(x.getPermissionObjCode());
            extendEntity.setPermissionResource(x.getPermissionResource());
            extendEntity.setPermissionSearchType(x.getPermissionSearchType());
            if (PermissionResourceEnum.FIXED.getCode().equals(x.getPermissionResource()) && !CollectionUtils.isEmpty((Collection)(codeList = x.getDetailCodeList()))) {
                List positionList = PositionUtil.getPositionByCodeList((List)codeList);
                if (!CollectionUtils.isEmpty((Collection)positionList)) {
                    String collect = positionList.stream().limit(3L).map(MdmPositionRespVo::getPositionName).collect(Collectors.joining(","));
                    extendEntity.setPermissionSearchType(collect);
                }
                for (String code : codeList) {
                    MdmDataPermissionExtendDetailEntity extendDetailEntity = new MdmDataPermissionExtendDetailEntity();
                    extendDetailEntity.setPermissionObjCode(MdmPermissionObjEnum.POSITION.getCode());
                    extendDetailEntity.setId(UUID.randomUUID().toString());
                    extendDetailEntity.setDetailCode(code);
                    extendDetailEntity.setPermissionExtendId(id);
                    extendDetailEntities.add(extendDetailEntity);
                }
            }
            return extendEntity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        this.mdmDataPermissionExtendService.add(entityList);
        this.mdmDataPermissionExtendDetailService.add(extendDetailEntities);
    }

    @Override
    public void populate(MdmDataPermissionVo mdmDataPermissionVo) {
        List idList;
        List mdmDataPermissionDetailVos = mdmDataPermissionVo.getMdmDataPermissionDetailVos();
        if (CollectionUtils.isEmpty((Collection)mdmDataPermissionDetailVos)) {
            return;
        }
        Map map = DictUtil.dictMap((String)"permission_obj_position");
        if (map != null && map.size() > 0) {
            for (MdmDataPermissionDetailVo mdmDataPermissionDetailVo : mdmDataPermissionDetailVos) {
                String permissionSearchType;
                if (!MdmPermissionObjEnum.POSITION.getCode().equals(mdmDataPermissionDetailVo.getPermissionObjCode()) || !PermissionResourceEnum.PRESUPPOSITION.getCode().equals(mdmDataPermissionDetailVo.getPermissionResource()) || StringUtils.isEmpty((Object)(permissionSearchType = mdmDataPermissionDetailVo.getPermissionSearchType()))) continue;
                mdmDataPermissionDetailVo.setPermissionSearchTypeName((String)map.get(permissionSearchType));
            }
        }
        if (CollectionUtils.isEmpty(idList = mdmDataPermissionDetailVos.stream().filter(x -> MdmPermissionObjEnum.POSITION.getCode().equals(x.getPermissionObjCode())).filter(x -> PermissionResourceEnum.FIXED.getCode().equals(x.getPermissionResource())).map(UuidVo::getId).collect(Collectors.toList()))) {
            return;
        }
        Map extendDetailMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmDataPermissionExtendDetailService.lambdaQuery().in(MdmDataPermissionExtendDetailEntity::getPermissionExtendId, idList)).eq(MdmDataPermissionExtendDetailEntity::getPermissionObjCode, (Object)MdmPermissionObjEnum.POSITION.getCode())).select(new SFunction[]{MdmDataPermissionExtendDetailEntity::getDetailCode, MdmDataPermissionExtendDetailEntity::getPermissionExtendId}).list().stream().collect(Collectors.groupingBy(MdmDataPermissionExtendDetailEntity::getPermissionExtendId, Collectors.mapping(MdmDataPermissionExtendDetailEntity::getDetailCode, Collectors.toList())));
        if (extendDetailMap == null || extendDetailMap.size() == 0) {
            return;
        }
        mdmDataPermissionDetailVos.forEach(x -> {
            List list = (List)extendDetailMap.get(x.getId());
            if (!CollectionUtils.isEmpty((Collection)list)) {
                x.setDetailCodeList(list);
                List positionList = PositionUtil.getPositionByCodeList((List)list);
                if (!CollectionUtils.isEmpty((Collection)positionList)) {
                    x.setDetailNameList(positionList.stream().map(MdmPositionRespVo::getPositionName).collect(Collectors.toList()));
                }
            }
        });
    }
}

