/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerRelCustomerUserReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserRelRolePageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserRelRoleReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserRelTerminalPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserRelTerminalReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangeCurrentCustomerReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserCustomerEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserSelectReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerUserPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerUserRelRolePageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerUserRelTerminalPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserSelectRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.user.mapper.MdmCustomerUserMapper;
import com.biz.crm.user.mapper.MdmUserMapper;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.service.MdmCustomerUserService;
import com.biz.crm.user.service.MdmUserRelCustomerService;
import com.biz.crm.user.service.MdmUserRelRoleService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.LoginHelpUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmUserCustomerServiceExpandImpl"})
public class MdmCustomerUserServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmUserMapper, MdmUserEntity>
implements MdmCustomerUserService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerUserServiceImpl.class);
    @Resource
    private MdmCustomerUserMapper mdmCustomerUserMapper;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmUserRelCustomerService mdmUserRelCustomerService;
    @Resource
    private MdmUserRelRoleService mdmUserRelRoleService;
    @Resource
    private MdmUserMapper mdmUserMapper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Resource
    private MdmTerminalSupplyService mdmTerminalSupplyService;

    @Override
    public PageResult<MdmCustomerUserPageRespVo> findList(MdmCustomerUserPageReqVo reqVo) {
        reqVo.setUserTypeList(Arrays.asList(UserTypeEnum.CUSTOMER.getCode(), UserTypeEnum.CUSTOMER_EMPLOYEE.getCode()));
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmCustomerUserPageRespVo> list = this.mdmCustomerUserMapper.findList((Page<MdmCustomerUserPageRespVo>)page, reqVo);
        this.setCustomerCodeName(list);
        this.setLockState(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmUserRespVo query(String id, String userName) {
        MdmUserEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)userName)) && (one = (MdmUserEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(!StringUtils.isEmpty((String)userName), MdmUserEntity::getUserName, (Object)userName)).one()) != null) {
            List<MdmCustomerMsgRespVo> customerListByUserName;
            MdmUserRespVo respVo = (MdmUserRespVo)CrmBeanUtil.copy((Object)one, MdmUserRespVo.class);
            respVo.setUserPassword("");
            if (UserTypeEnum.CUSTOMER.getCode().equals(respVo.getUserType())) {
                respVo.setCustomerList(this.mdmCustomerMsgService.getCustomerListByUserName(one.getUserName()));
                if (YesNoEnum.yesNoEnum.N.getValue().equals(ParamUtil.getParameterValue((String)"user_can_relation_many_customer")) && CollectionUtil.listNotEmptyNotSizeZero((List)respVo.getCustomerList())) {
                    respVo.setCustomerCode(((MdmCustomerMsgRespVo)respVo.getCustomerList().get(0)).getCustomerCode());
                    respVo.setCustomerName(((MdmCustomerMsgRespVo)respVo.getCustomerList().get(0)).getCustomerName());
                }
            }
            if (UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(respVo.getUserType()) && CollectionUtil.listNotEmptyNotSizeZero(customerListByUserName = this.mdmCustomerMsgService.getCustomerListByUserName(one.getUserName()))) {
                respVo.setCustomerCode(customerListByUserName.get(0).getCustomerCode());
                respVo.setCustomerName(customerListByUserName.get(0).getCustomerName());
            }
            respVo.setRoleCodeList(this.mdmUserRelRoleService.findRoleCodeListByUserName(one.getUserName()));
            return respVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmUserEditReqVo reqVo) {
        reqVo.setId(null);
        this.verifyData(reqVo);
        MdmUserEntity entity = (MdmUserEntity)CrmBeanUtil.copy((Object)reqVo, MdmUserEntity.class);
        if (StringUtils.isEmpty((String)entity.getUserCode())) {
            entity.setUserCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_USER_CODE.getCode()));
        }
        entity.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setForceChangePassword(YesNoEnum.yesNoEnum.ONE.getValue());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save(entity);
        this.saveOrUpdateUserRelation(reqVo, entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            MdmUserRespVo newObject = this.query(entity.getId(), null);
            this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), entity.getId(), entity.getUserName(), (Object)newObject);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmUserEditReqVo reqVo) {
        this.verifyData(reqVo);
        MdmUserEntity entity = (MdmUserEntity)this.getById((Serializable)((Object)reqVo.getId()));
        MdmUserRespVo oldObject = this.query(reqVo.getId(), null);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)entity);
        this.updateById(entity);
        this.saveOrUpdateUserRelation(reqVo, entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            MdmUserRespVo newObject = this.query(reqVo.getId(), null);
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), entity.getId(), entity.getUserName(), (Object)oldObject, (Object)newObject);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List collect;
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(BaseIdEntity::getId, ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684id\u96c6\u5408");
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            list.forEach(item -> this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), item.getId(), item.getUserName(), item));
        }
        Assert.isTrue(((collect = list.stream().filter(x -> !UserTypeEnum.CUSTOMER.getCode().equals(x.getUserType()) && !UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(x.getUserType())).collect(Collectors.toList())).size() == 0 ? 1 : 0) != 0, (String)"\u5b58\u5728\u5176\u5b83\u4e0d\u652f\u6301\u7684\u7528\u6237\u7c7b\u578b");
        List<String> userNameList = list.stream().map(MdmUserEntity::getUserName).collect(Collectors.toList());
        this.mdmUserRelCustomerService.delByUserName(userNameList);
        this.mdmUserRelRoleService.delByUserName(userNameList);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)list.stream().map(BaseIdEntity::getId).collect(Collectors.toSet()))).set(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.DELETE.getCode())).update();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyData(MdmUserEditReqVo reqVo) {
        List list;
        String userName = reqVo.getUserName();
        Assert.hasText((String)userName, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getUserType(), (String)"\u7f3a\u5931\u7528\u6237\u7c7b\u578b");
        MdmUserEntity one = (MdmUserEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)userName)).one();
        if (StringUtils.isNotEmpty((String)reqVo.getUserPhone())) {
            list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserPhone, (Object)reqVo.getUserPhone())).list().stream().filter(x -> StringUtils.isEmpty((String)reqVo.getId()) || !reqVo.getId().equals(x.getId())).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtil.listEmpty(list), (String)"\u624b\u673a\u53f7\u7801\u5df2\u7ecf\u88ab\u5360\u7528");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getEmail())) {
            list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getEmail, (Object)reqVo.getEmail())).list().stream().filter(x -> StringUtils.isEmpty((String)reqVo.getId()) || !reqVo.getId().equals(x.getId())).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtil.listEmpty(list), (String)"\u90ae\u7bb1\u5df2\u7ecf\u88ab\u5360\u7528");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getIdentityCardNumber())) {
            list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getIdentityCardNumber, (Object)reqVo.getIdentityCardNumber())).list().stream().filter(x -> StringUtils.isEmpty((String)reqVo.getId()) || !reqVo.getId().equals(x.getId())).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtil.listEmpty(list), (String)"\u8eab\u4efd\u8bc1\u53f7\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            if (one != null) {
                String delMark = "";
                if (!CrmDelFlagEnum.DELETE.getCode().equals(one.getDelFlag())) throw new BusinessException("\u5e10\u53f7[" + userName + "]\u5df2\u5b58\u5728" + delMark);
                delMark = "\uff08\u5df2\u903b\u8f91\u5220\u9664\uff09";
                throw new BusinessException("\u5e10\u53f7[" + userName + "]\u5df2\u5b58\u5728" + delMark);
            }
            Assert.hasText((String)reqVo.getUserPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqVo.getUserPassword())) {
            reqVo.setUserPassword(one.getUserPassword());
        } else {
            reqVo.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)reqVo.getUserPassword()));
        }
        if (UserTypeEnum.CUSTOMER.getCode().equals(reqVo.getUserType())) {
            String parameterValue = ParamUtil.getParameterValue((String)"user_can_relation_many_customer");
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(parameterValue)) {
                List customerList = reqVo.getCustomerList();
                Assert.notEmpty((Collection)customerList, (String)"\u5ba2\u6237\u7528\u6237\u5fc5\u987b\u5173\u8054\u5ba2\u6237");
                HashMap<String, MdmUserCustomerEditReqVo> customerUniqueMap = new HashMap<String, MdmUserCustomerEditReqVo>(16);
                for (MdmUserCustomerEditReqVo item : customerList) {
                    Assert.hasText((String)item.getCustomerCode(), (String)"\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                    if (customerUniqueMap.containsKey(item.getCustomerCode())) {
                        throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u5173\u8054\u5ba2\u6237\u76f8\u540c\u5ba2\u6237");
                    }
                    customerUniqueMap.put(item.getCustomerCode(), item);
                }
                return;
            } else {
                if (!YesNoEnum.yesNoEnum.N.getValue().equals(parameterValue)) throw new BusinessException("\u5168\u5c40\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
                Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return;
        } else {
            if (!UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(reqVo.getUserType())) throw new BusinessException("\u9519\u8bef\u7684\u7c7b\u578b");
            Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void saveOrUpdateUserRelation(MdmUserEditReqVo reqVo, MdmUserEntity userEntity) {
        this.mdmUserRelCustomerService.delByUserName(userEntity.getUserName());
        this.mdmUserRelRoleService.delByUserName(userEntity.getUserName());
        List roleCodeList = reqVo.getRoleCodeList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)roleCodeList)) {
            this.mdmUserRelRoleService.add(userEntity.getUserName(), roleCodeList);
        }
        if (UserTypeEnum.CUSTOMER.getCode().equals(userEntity.getUserType())) {
            if (YesNoEnum.yesNoEnum.N.getValue().equals(ParamUtil.getParameterValue((String)"user_can_relation_many_customer"))) {
                reqVo.setCustomerList(Collections.singletonList(new MdmUserCustomerEditReqVo().setCustomerCode(reqVo.getCustomerCode()).setRoleCode(reqVo.getRoleCode())));
            }
            Set customerCodeSet = reqVo.getCustomerList().stream().map(MdmUserCustomerEditReqVo::getCustomerCode).collect(Collectors.toSet());
            this.mdmUserRelCustomerService.add(userEntity.getUserName(), new ArrayList<String>(customerCodeSet));
        } else if (UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(userEntity.getUserType())) {
            this.mdmUserRelCustomerService.add(userEntity.getUserName(), reqVo.getCustomerCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeUserCurrentCustomer(MdmUserChangeCurrentCustomerReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u767b\u5f55\u540d");
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        MdmUserEntity one = (MdmUserEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)reqVo.getUserName())).select(new SFunction[]{BaseIdEntity::getId, MdmUserEntity::getUserName, MdmUserEntity::getFullName, MdmUserEntity::getUserType}).one();
        Assert.notNull((Object)one, (String)"\u672a\u627e\u5230\u7528\u6237");
        Assert.isTrue((boolean)UserTypeEnum.CUSTOMER.getCode().equals(one.getUserType()), (String)"\u8be5\u7528\u6237\u4e0d\u662f\u5ba2\u6237\u7528\u6237");
        MdmCustomerMsgRespVo customer = this.mdmCustomerMsgService.queryByCustomerCode(reqVo.getCustomerCode());
        Assert.notNull((Object)customer, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(customer.getEnableStatus()), (String)"\u5ba2\u6237\u672a\u542f\u7528");
        List<String> customerCodeList = this.mdmUserRelCustomerService.findCustomerCodeListByUserName(reqVo.getUserName());
        Assert.isTrue((customerCodeList.size() > 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u672a\u5173\u8054\u4efb\u4f55\u53ef\u7528\u5ba2\u6237");
        Assert.isTrue((boolean)customerCodeList.contains(reqVo.getCustomerCode()), (String)"\u7528\u6237\u672a\u5173\u8054\u8be5\u5ba2\u6237");
        this.mdmUserRelCustomerService.setUniqueCurrentCustomerIfExist(reqVo.getUserName(), reqVo.getCustomerCode());
        UserRedis user = UserUtils.getUser();
        String token = UserUtils.getToken();
        if (user != null && StringUtils.isNotEmpty((String)user.getUsername()) && one.getUserName().equals(user.getUsername()) && StringUtils.isNotEmpty((String)token)) {
            user.setCustcode(customer.getCustomerCode());
            user.setCustname(customer.getCustomerName());
            List<String> customerRelOrgList = this.mdmCustomerROrgService.findOrgCodeByCustomerCode(customer.getCustomerCode());
            if (CollectionUtil.listNotEmptyNotSizeZero(customerRelOrgList)) {
                Map<String, String> orgNameMap = this.mdmOrgService.findOrgNameMap(customerRelOrgList);
                List orgCodeList = customerRelOrgList.stream().filter(orgNameMap::containsKey).collect(Collectors.toList());
                if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList)) {
                    List orgNameList = orgCodeList.stream().map(orgNameMap::get).collect(Collectors.toList());
                    user.setOrgcode(String.join((CharSequence)",", orgCodeList));
                    user.setOrgname(String.join((CharSequence)",", orgNameList));
                }
            }
            UserUtils.setUser((String)token, (UserRedis)user);
        }
    }

    @Override
    public PageResult<MdmUserSelectRespVo> findCustomerUserSelectPageList(MdmUserSelectReqVo reqVo) {
        reqVo.setUserTypeList(Arrays.asList(UserTypeEnum.CUSTOMER.getCode(), UserTypeEnum.CUSTOMER_EMPLOYEE.getCode()));
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserSelectRespVo> list = this.mdmUserMapper.findUserSelectList((Page<MdmUserSelectRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmUserRespVo> findCustomerRelCustomerUserList(MdmCustomerRelCustomerUserReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getCustomerCodeList(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        List<String> userNameList = this.mdmUserRelCustomerService.findUserNameListByCustomerCodeList(reqVo.getCustomerCodeList());
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList)) {
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getRoleCodeList())) {
                List<String> roleRelUserNameList = this.mdmUserRelRoleService.findUserNameListByRoleCodeList(reqVo.getRoleCodeList());
                userNameList.retainAll(roleRelUserNameList);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(userNameList)) {
                return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).in(MdmUserEntity::getUserName, userNameList)).list().stream().map(x -> (MdmUserRespVo)CrmBeanUtil.copy((Object)x, MdmUserRespVo.class)).collect(Collectors.toList());
            }
        }
        return new ArrayList<MdmUserRespVo>();
    }

    @Override
    public List<MdmUserSelectRespVo> findCustomerUserSelectList(MdmUserSelectReqVo reqVo) {
        reqVo.setUserTypeList(Arrays.asList(UserTypeEnum.CUSTOMER.getCode(), UserTypeEnum.CUSTOMER_EMPLOYEE.getCode()));
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        ArrayList<MdmUserSelectRespVo> list = new ArrayList<MdmUserSelectRespVo>();
        HashSet<String> codeList = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        if (pageSize > 0) {
            list.addAll(this.mdmUserMapper.findUserSelectList((Page<MdmUserSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo));
        }
        return list;
    }

    @Override
    public PageResult<MdmCustomerUserRelRolePageRespVo> findCustomerUserNotRelAnyRole(MdmCustomerUserRelRolePageReqVo reqVo) {
        reqVo.setUserTypeList(Arrays.asList(UserTypeEnum.CUSTOMER.getCode(), UserTypeEnum.CUSTOMER_EMPLOYEE.getCode()));
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmCustomerUserRelRolePageRespVo> list = this.mdmCustomerUserMapper.findCustomerUserNotRelAnyRole((Page<MdmCustomerUserRelRolePageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmCustomerUserRelRolePageRespVo> findCustomerUserNotRelCurRole(MdmCustomerUserRelRolePageReqVo reqVo) {
        reqVo.setUserTypeList(Arrays.asList(UserTypeEnum.CUSTOMER.getCode(), UserTypeEnum.CUSTOMER_EMPLOYEE.getCode()));
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u6743\u9650\u89d2\u8272\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmCustomerUserRelRolePageRespVo> list = this.mdmCustomerUserMapper.findCustomerUserNotRelCurRole((Page<MdmCustomerUserRelRolePageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmCustomerUserRelRolePageRespVo> findCustomerUserHasRelCurRole(MdmCustomerUserRelRolePageReqVo reqVo) {
        reqVo.setUserTypeList(Arrays.asList(UserTypeEnum.CUSTOMER.getCode(), UserTypeEnum.CUSTOMER_EMPLOYEE.getCode()));
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u6743\u9650\u89d2\u8272\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmCustomerUserRelRolePageRespVo> list = this.mdmCustomerUserMapper.findCustomerUserHasRelCurRole((Page<MdmCustomerUserRelRolePageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindUserRelRole(MdmCustomerUserRelRoleReqVo reqVo) {
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u6743\u9650\u89d2\u8272\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getUserNameList(), (String)"\u7f3a\u5931\u7528\u6237\u7f16\u7801\u96c6\u5408");
        this.mdmUserRelRoleService.add(reqVo.getUserNameList(), reqVo.getRoleCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceUserRelRole(MdmCustomerUserRelRoleReqVo reqVo) {
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u6743\u9650\u89d2\u8272\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931\u5173\u8054id\u96c6\u5408");
        this.mdmUserRelRoleService.replaceUserRelRole(reqVo.getIds(), reqVo.getRoleCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindUserRelRole(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        this.mdmUserRelRoleService.removeByIds(ids);
    }

    @Override
    public PageResult<MdmCustomerUserRelTerminalPageRespVo> findTerminalNotRelAnyCustomerUser(MdmCustomerUserRelTerminalPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u8d26\u53f7");
        reqVo.setUserTypeList(Arrays.asList(UserTypeEnum.CUSTOMER.getCode(), UserTypeEnum.CUSTOMER_EMPLOYEE.getCode()));
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmCustomerUserRelTerminalPageRespVo> list = this.mdmCustomerUserMapper.findTerminalNotRelAnyCustomerUser((Page<MdmCustomerUserRelTerminalPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmCustomerUserRelTerminalPageRespVo> findTerminalNotRelCurCustomerUser(MdmCustomerUserRelTerminalPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u8d26\u53f7");
        reqVo.setUserTypeList(Arrays.asList(UserTypeEnum.CUSTOMER.getCode(), UserTypeEnum.CUSTOMER_EMPLOYEE.getCode()));
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmCustomerUserRelTerminalPageRespVo> list = this.mdmCustomerUserMapper.findTerminalNotRelCurCustomerUser((Page<MdmCustomerUserRelTerminalPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmCustomerUserRelTerminalPageRespVo> findTerminalHasRelCurCustomerUser(MdmCustomerUserRelTerminalPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u8d26\u53f7");
        reqVo.setUserTypeList(Arrays.asList(UserTypeEnum.CUSTOMER.getCode(), UserTypeEnum.CUSTOMER_EMPLOYEE.getCode()));
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmCustomerUserRelTerminalPageRespVo> list = this.mdmCustomerUserMapper.findTerminalHasRelCurCustomerUser((Page<MdmCustomerUserRelTerminalPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindCustomerUserRelTerminal(MdmCustomerUserRelTerminalReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237");
        Assert.notEmpty((Collection)reqVo.getTerminalCodeList(), (String)"\u7f3a\u5931\u7ec8\u7aef\u7f16\u7801\u96c6\u5408");
        this.mdmTerminalSupplyService.addCustomerUserTerminalSupply(reqVo.getTerminalCodeList(), reqVo.getUserName());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceCustomerUserRelTerminal(MdmCustomerUserRelTerminalReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237");
        Assert.hasText((String)reqVo.getTargetUserName(), (String)"\u7f3a\u5931\u76ee\u6807\u7528\u6237");
        Assert.notEmpty((Collection)reqVo.getTerminalCodeList(), (String)"\u7f3a\u5931\u7ec8\u7aef\u7f16\u7801\u96c6\u5408");
        this.mdmTerminalSupplyService.replaceCustomerUserTerminalSupply(reqVo.getTerminalCodeList(), reqVo.getUserName(), reqVo.getTargetUserName());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindCustomerUserRelTerminal(MdmCustomerUserRelTerminalReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237");
        Assert.notEmpty((Collection)reqVo.getTerminalCodeList(), (String)"\u7f3a\u5931\u7ec8\u7aef\u7f16\u7801\u96c6\u5408");
        this.mdmTerminalSupplyService.delCustomerUserTerminalSupply(reqVo.getTerminalCodeList(), reqVo.getUserName());
    }

    protected void setCustomerCodeName(List<MdmCustomerUserPageRespVo> allList) {
        if (CollectionUtil.listEmpty(allList)) {
            return;
        }
        List partition = Lists.partition(allList, (int)500);
        for (List list : partition) {
            Map<String, List<String>> map = this.mdmUserRelCustomerService.getCustomerCodeListGroupByUserNameList(list.stream().map(MdmCustomerUserPageRespVo::getUserName).collect(Collectors.toList()));
            if (map.isEmpty()) continue;
            Set collect = map.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            Map<String, String> customerCodeNameMap = this.mdmCustomerMsgService.findCustomerCodeNameMapByCustomerCodeList(new ArrayList<String>(collect));
            list.forEach(item -> {
                if (map.containsKey(item.getUserName())) {
                    List customerCodeList = ((List)map.get(item.getUserName())).stream().filter(customerCodeNameMap::containsKey).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(customerCodeList)) {
                        String names = customerCodeList.stream().map(customerCodeNameMap::get).collect(Collectors.joining(","));
                        item.setCustomerCode(String.join((CharSequence)",", customerCodeList));
                        item.setCustomerName(names);
                    }
                }
            });
        }
    }

    protected void setLockState(List<MdmCustomerUserPageRespVo> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        Set<String> lockUserNameSet = LoginHelpUtil.checkAndGetLockUserName(list.stream().map(MdmCustomerUserPageRespVo::getUserName).collect(Collectors.toSet()));
        list.forEach(item -> item.setLockState(!lockUserNameSet.contains(item.getUserName()) ? CrmEnableStatusEnum.ENABLE.getCode() : CrmEnableStatusEnum.DISABLE.getCode()));
    }
}

