/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablelistrule.handler;

import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.CustomerOrgChangeAdviseTargetStrategy;
import com.biz.crm.customer.handler.CustomerChangeHandler;
import com.biz.crm.nebular.mdm.customer.CustomerChangeHandlerReqVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CustomerChangeAvailableListRuleHandler
implements CustomerChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomerChangeAvailableListRuleHandler.class);
    @Resource
    private Advise advise;
    @Resource
    private CustomerOrgChangeAdviseTargetStrategy customerOrgChangeAdviseTargetStrategy;

    @Override
    public void handler(CustomerChangeHandlerReqVo vo) {
        log.info("CustomerChangeAvailableListRuleHandler->handler[{}]", (Object)vo);
        HashSet codes = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)vo.getOldOrgCode())) {
            codes.add(vo.getOldOrgCode());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getCurrentOrgCode())) {
            codes.add(vo.getCurrentOrgCode());
        }
        if (CollectionUtils.isEmpty((Collection)codes)) {
            log.error("CustomerChangeAvailableListRuleHandler->handler\u65e0\u7ec4\u7ec7\u4fe1\u606f[{}]", (Object)vo);
            return;
        }
        this.advise.adviseTarget(this.customerOrgChangeAdviseTargetStrategy, Lists.newArrayList((Iterable)codes));
    }
}

