/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.utils;

import com.biz.crm.common.PageResult;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;

public class EsBuilder {
    private final NativeSearchQueryBuilder builder = new NativeSearchQueryBuilder();

    private EsBuilder() {
    }

    public static EsBuilder lambdaQuery() {
        return new EsBuilder();
    }

    public EsBuilder withQuery(boolean flag, QueryBuilder queryBuilder) {
        return this.predicate(flag, x -> x.withQuery(queryBuilder));
    }

    public EsBuilder withQuery(QueryBuilder queryBuilder) {
        return this.predicate(true, x -> x.withQuery(queryBuilder));
    }

    public EsBuilder withFilter(QueryBuilder queryBuilder) {
        return this.predicate(true, x -> x.withFilter(queryBuilder));
    }

    public EsBuilder withFilter(boolean flag, QueryBuilder queryBuilder) {
        return this.predicate(flag, x -> x.withFilter(queryBuilder));
    }

    public EsBuilder withSort(boolean flag, Supplier<SortBuilder> supplier) {
        this.builder.withSort(supplier.get());
        return this;
    }

    public EsBuilder withSort(String field) {
        this.builder.withSort(SortBuilders.fieldSort((String)field).order(SortOrder.ASC));
        return this;
    }

    public EsBuilder withSort(String field, SortOrder sortOrder) {
        this.builder.withSort(SortBuilders.fieldSort((String)field).order(sortOrder));
        return this;
    }

    public EsBuilder withSort(List<String> fieldList) {
        for (String field : fieldList) {
            this.builder.withSort(SortBuilders.fieldSort((String)field).order(SortOrder.ASC));
        }
        return this;
    }

    public EsBuilder withSort(List<String> fieldList, SortOrder sortOrder) {
        for (String field : fieldList) {
            this.builder.withSort(SortBuilders.fieldSort((String)field).order(sortOrder));
        }
        return this;
    }

    public EsBuilder withPageable(Integer page, Integer size) {
        int realPage = page == null ? 0 : (page > 1 ? page - 1 : page);
        int realSize = size == null ? 25 : size;
        this.predicate(true, x -> x.withPageable((Pageable)PageRequest.of((int)realPage, (int)realSize)));
        return this;
    }

    public NativeSearchQuery build() {
        return this.builder.build();
    }

    public <T> PageResult<T> queryForPage(ElasticsearchTemplate elasticsearchRestTemplate, Class<T> cls) {
        return this.page(() -> elasticsearchRestTemplate.queryForPage((SearchQuery)this.builder.build(), cls));
    }

    public <T> PageResult<T> page(Supplier<Page<T>> supplier) {
        return Optional.ofNullable(supplier.get()).map(x -> PageResult.builder().count(Long.valueOf(x.getTotalElements())).data(x.getContent()).build()).orElse(PageResult.empty());
    }

    private EsBuilder predicate(boolean flag, Consumer<NativeSearchQueryBuilder> consumer) {
        if (flag) {
            consumer.accept(this.builder);
        }
        return this;
    }
}

