/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.biz.crm.config.DataSourceType;
import com.biz.crm.config.DynamicDataSource;
import java.util.HashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(prefix="dynamic", name={"enabled"}, havingValue="true")
public class DynamicDataSourceConfig {
    public static final Logger log = LoggerFactory.getLogger(DynamicDataSourceConfig.class);
    @Value(value="${spring.datasource.driverClassName:null}")
    private String driverClassName;

    @Bean
    @ConfigurationProperties(prefix="spring.datasource.druid")
    public DataSource masterDataSource() {
        return new DruidDataSource();
    }

    @Bean
    @ConfigurationProperties(prefix="dynamic.slave")
    public DataSource slaveDataSource() {
        return new DruidDataSource();
    }

    @Bean(name={"dynamicDataSource"})
    @Primary
    public DynamicDataSource dataSource(DataSource masterDataSource, DataSource slaveDataSource) {
        log.info("\u52a8\u6001\u6570\u636e\u6e90\u6ce8\u5165-------------------");
        log.info("master:{}", (Object)masterDataSource);
        log.info("slave:{}", (Object)slaveDataSource);
        HashMap<Object, Object> targetDataSources = new HashMap<Object, Object>(2);
        targetDataSources.put(DataSourceType.MASTER.name(), masterDataSource);
        targetDataSources.put(DataSourceType.SLAVE.name(), slaveDataSource);
        return new DynamicDataSource(masterDataSource, targetDataSources);
    }
}

