/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sync.service.impl;

import com.biz.crm.crmlog.template.entity.LogTemplateEntity;
import com.biz.crm.crmlog.template.service.LogTemplateService;
import com.biz.crm.nebular.log.template.LogTemplateVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncBaseReqVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncLogConfigReqVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncLogRespVo;
import com.biz.crm.sync.config.MdmSyncParameterParser;
import com.biz.crm.sync.config.MdmSyncProperty;
import com.biz.crm.sync.service.MdmSyncLogConfigService;
import com.biz.crm.utils.EsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmSyncLogConfigServiceExpandImpl"})
public class MdmSyncLogConfigServiceImpl
implements MdmSyncLogConfigService {
    private static final Logger log = LoggerFactory.getLogger(MdmSyncLogConfigServiceImpl.class);
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private MdmSyncProperty mdmSyncProperty;
    @Autowired
    private LogTemplateService logTemplateService;

    @Override
    public MdmSyncLogRespVo logSync(MdmSyncLogConfigReqVo mdmSyncLogConfigReqVo) {
        NativeSearchQuery build = EsBuilder.lambdaQuery().withPageable(mdmSyncLogConfigReqVo.getPageNum(), mdmSyncLogConfigReqVo.getPageSize()).build();
        List entities = this.elasticsearchTemplate.queryForList((SearchQuery)build, LogTemplateEntity.class);
        MdmSyncLogRespVo mdmSyncLogRespVo = new MdmSyncLogRespVo();
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return mdmSyncLogRespVo;
        }
        ArrayList<LogTemplateVo> listVo = new ArrayList<LogTemplateVo>(entities.size());
        for (LogTemplateEntity entity : entities) {
            LogTemplateVo logTemplateVo = new LogTemplateVo();
            BeanUtils.copyProperties((Object)entity, (Object)logTemplateVo);
            listVo.add(logTemplateVo);
        }
        mdmSyncLogRespVo.setLogTemplateVos(listVo);
        return mdmSyncLogRespVo;
    }

    @Override
    public void logTemplateSync(MdmSyncBaseReqVo mdmSyncBaseReqVo) {
        MdmSyncLogRespVo mdmSyncLogRespVo = MdmSyncParameterParser.obtainOriginalData(mdmSyncBaseReqVo, this.mdmSyncProperty, "/mdm/mdmLogConfigSyncController/logTemplateList", mdmSyncBaseReqVo, MdmSyncLogRespVo.class);
        Optional.ofNullable(mdmSyncLogRespVo).map(MdmSyncLogRespVo::getLogTemplateVos).filter(x -> !CollectionUtils.isEmpty((Collection)x)).ifPresent(list -> {
            for (LogTemplateVo logTemplateVo : list) {
                this.logTemplateService.add(logTemplateVo);
            }
        });
    }
}

