/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.system;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
public class CacheConfig {
    @Value(value="${cache.default.expire-time}")
    private int defaultExpireTime;
    @Value(value="${cache.user.expire-time}")
    private int userCacheExpireTime;
    @Value(value="${cache.user.name}")
    private String userCacheName;

    @Bean
    public CacheManager cacheManager(RedisConnectionFactory lettuceConnectionFactory) {
        RedisCacheConfiguration defaultCacheConfig = RedisCacheConfiguration.defaultCacheConfig();
        defaultCacheConfig = defaultCacheConfig.entryTtl(Duration.ofSeconds(this.defaultExpireTime)).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer())).disableCachingNullValues();
        HashSet<String> cacheNames = new HashSet<String>();
        cacheNames.add(this.userCacheName);
        HashMap<String, RedisCacheConfiguration> configMap = new HashMap<String, RedisCacheConfiguration>();
        configMap.put(this.userCacheName, defaultCacheConfig.entryTtl(Duration.ofSeconds(this.userCacheExpireTime)));
        RedisCacheManager cacheManager = RedisCacheManager.builder((RedisConnectionFactory)lettuceConnectionFactory).cacheDefaults(defaultCacheConfig).initialCacheNames(cacheNames).withInitialCacheConfigurations(configMap).build();
        return cacheManager;
    }
}

