/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRelationTerminalPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.position.mapper.MdmPositionRelationTerminalMapper;
import com.biz.crm.position.service.MdmPositionRelationTerminalService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.terminal.service.MdmTerminalROrgService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MdmPositionRelationTerminalServiceImpl
implements MdmPositionRelationTerminalService {
    @Resource
    private MdmPositionRelationTerminalMapper mdmPositionRelationTerminalMapper;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Resource
    private MdmTerminalROrgService mdmTerminalROrgService;

    @Override
    public PageResult<MdmPositionRelationTerminalPageRespVo> findTerminalNotRelateAnyPosition(MdmPositionRelationTerminalPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmPositionRelationTerminalPageRespVo> list = this.mdmPositionRelationTerminalMapper.findTerminalNotRelateAnyPosition((Page<MdmPositionRelationTerminalPageRespVo>)page, reqVo);
        this.setOrgName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmPositionRelationTerminalPageRespVo> findTerminalNotRelateCurPosition(MdmPositionRelationTerminalPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmPositionRelationTerminalPageRespVo> list = this.mdmPositionRelationTerminalMapper.findTerminalNotRelateCurPosition((Page<MdmPositionRelationTerminalPageRespVo>)page, reqVo);
        this.setOrgName(list);
        this.setPositionCodeName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmPositionRelationTerminalPageRespVo> findTerminalHasRelateCurPosition(MdmPositionRelationTerminalPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmPositionRelationTerminalPageRespVo> list = this.mdmPositionRelationTerminalMapper.findTerminalHasRelateCurPosition((Page<MdmPositionRelationTerminalPageRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setId(item.getSupplyId()));
        }
        this.setOrgName(list);
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindRelation(List<String> terminalCodeList, String positionCode) {
        Assert.notEmpty(terminalCodeList, (String)"\u7f3a\u5931\u7ec8\u7aef\u7f16\u7801");
        Assert.hasText((String)positionCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        MdmPositionRespVo position = this.mdmPositionService.queryByPositionCode(positionCode);
        Assert.notNull((Object)position, (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7f16\u7801");
        this.mdmTerminalSupplyService.addTerminalPosition(terminalCodeList, positionCode, position.getOrgCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceTerminalPosition(List<String> ids, String positionCode) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931id");
        Assert.hasText((String)positionCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        MdmPositionRespVo position = this.mdmPositionService.queryByPositionCode(positionCode);
        Assert.notNull((Object)position, (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7f16\u7801");
        this.mdmTerminalSupplyService.replaceRelationPosition(ids, positionCode, position.getOrgCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindRelation(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931id");
        this.mdmTerminalSupplyService.unbindByIds(ids);
    }

    private void setOrgName(List<MdmPositionRelationTerminalPageRespVo> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        Map<String, List<MdmOrgRespVo>> map = this.mdmTerminalROrgService.findOrgGroupByTerminalCodeList(list.stream().map(MdmPositionRelationTerminalPageRespVo::getTerminalCode).collect(Collectors.toList()));
        list.forEach(item -> {
            if (map.containsKey(item.getTerminalCode())) {
                List orgList = (List)map.get(item.getTerminalCode());
                item.setOrgName(orgList.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.joining(",")));
            }
        });
    }

    private void setPositionCodeName(List<MdmPositionRelationTerminalPageRespVo> list) {
        Map<String, MdmPositionRespVo> positionMap;
        List terminalCodeList;
        List<MdmTerminalSupplyVo> terminalSupplyList;
        List<String> positionCodeList;
        if (CollectionUtil.listNotEmptyNotSizeZero(list) && CollectionUtil.listNotEmptyNotSizeZero(positionCodeList = (terminalSupplyList = this.mdmTerminalSupplyService.findTerminalSupply(new MdmTerminalVo().setTerminalCodeList(terminalCodeList = list.stream().map(MdmPositionRelationTerminalPageRespVo::getTerminalCode).collect(Collectors.toList())))).stream().map(MdmTerminalSupplyVo::getPositionCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList())) && !(positionMap = this.mdmPositionService.queryBatchByPositionCodeList(positionCodeList).stream().collect(Collectors.toMap(MdmPositionRespVo::getPositionCode, v -> v))).isEmpty()) {
            Map collect = terminalSupplyList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPositionCode())).collect(Collectors.groupingBy(MdmTerminalSupplyVo::getTerminalCode, Collectors.mapping(MdmTerminalSupplyVo::getPositionCode, Collectors.toList())));
            list.forEach(item -> {
                if (collect.containsKey(item.getTerminalCode())) {
                    List positionCodeListInThisTerminal = (List)collect.get(item.getTerminalCode());
                    ArrayList positionListInThisTerminal = new ArrayList();
                    for (String positionCode : positionCodeListInThisTerminal) {
                        if (!positionMap.containsKey(positionCode)) continue;
                        positionListInThisTerminal.add(positionMap.get(positionCode));
                    }
                    item.setPositionCode(positionListInThisTerminal.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.joining(",")));
                    item.setPositionName(positionListInThisTerminal.stream().map(MdmPositionRespVo::getPositionName).collect(Collectors.joining(",")));
                }
            });
        }
    }
}

