/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.button.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.button.service.MdmButtonService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.button.MdmButtonReqVo;
import com.biz.crm.nebular.mdm.button.MdmButtonRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmbutton"})
@Api(tags={"\u6309\u94ae"})
@CrmGlobalLog
public class MdmButtonController {
    private static final Logger log = LoggerFactory.getLogger(MdmButtonController.class);
    @Autowired
    private MdmButtonService mdmButtonService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmDictMethod
    public Result<PageResult<MdmButtonRespVo>> list(@RequestBody MdmButtonReqVo mdmButtonReqVo) {
        PageResult<MdmButtonRespVo> result = this.mdmButtonService.findList(mdmButtonReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6761\u4ef6\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/listCondition"})
    @CrmDictMethod
    public Result<List<MdmButtonRespVo>> listCondition(@RequestBody MdmButtonReqVo mdmButtonReqVo) {
        List<MdmButtonRespVo> result = this.mdmButtonService.listCondition(mdmButtonReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="buttonCode", value="\u533a\u57df\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @CrmDictMethod
    public Result<MdmButtonRespVo> query(@RequestParam(value="id", required=false) String id, @RequestParam(value="buttonCode", required=false) String buttonCode) {
        MdmButtonRespVo respVo = this.mdmButtonService.query(id, buttonCode);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result<Object> save(@RequestBody MdmButtonReqVo mdmButtonReqVo) {
        this.mdmButtonService.save(mdmButtonReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result<Object> update(@RequestBody MdmButtonReqVo mdmButtonReqVo) {
        this.mdmButtonService.update(mdmButtonReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    public Result<Object> delete(@RequestBody List<String> ids) {
        this.mdmButtonService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    public Result<Object> enable(@RequestBody List<String> ids) {
        this.mdmButtonService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    public Result<Object> disable(@RequestBody List<String> ids) {
        this.mdmButtonService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

