/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.utils;

public class PinYinUtil {
    private char[] chartable = new char[]{'\u554a', '\u82ad', '\u64e6', '\u642d', '\u86fe', '\u53d1', '\u5676', '\u54c8', '\u54c8', '\u51fb', '\u5580', '\u5783', '\u5988', '\u62ff', '\u54e6', '\u556a', '\u671f', '\u7136', '\u6492', '\u584c', '\u584c', '\u584c', '\u6316', '\u6614', '\u538b', '\u531d', '\u5ea7'};
    private char[] alphatable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private int[] table = new int[27];

    public PinYinUtil() {
        for (int i = 0; i < 27; ++i) {
            this.table[i] = this.gbValue(this.chartable[i]);
        }
    }

    public char Char2Alpha(char ch) {
        int i;
        if (ch >= 'a' && ch <= 'z') {
            return (char)(ch - 97 + 65);
        }
        if (ch >= 'A' && ch <= 'Z') {
            return ch;
        }
        int gb = this.gbValue(ch);
        if (gb < this.table[0]) {
            return '0';
        }
        for (i = 0; i < 26 && !this.match(i, gb); ++i) {
        }
        if (i >= 26) {
            return '0';
        }
        return this.alphatable[i];
    }

    public String String2Alpha(String SourceStr) {
        String Result2 = "";
        int StrLength = SourceStr.length();
        try {
            for (int i = 0; i < StrLength; ++i) {
                Result2 = Result2 + this.Char2Alpha(SourceStr.charAt(i));
            }
        }
        catch (Exception e) {
            Result2 = "";
        }
        return Result2;
    }

    private boolean match(int i, int gb) {
        int j;
        if (gb < this.table[i]) {
            return false;
        }
        for (j = i + 1; j < 26 && this.table[j] == this.table[i]; ++j) {
        }
        if (j == 26) {
            return gb <= this.table[j];
        }
        return gb < this.table[j];
    }

    private int gbValue(char ch) {
        String str = new String();
        str = str + ch;
        try {
            byte[] bytes = str.getBytes("GB2312");
            if (bytes.length < 2) {
                return 0;
            }
            return (bytes[0] << 8 & 0xFF00) + (bytes[1] & 0xFF);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String getPinYin(String str) {
        PinYinUtil obj1 = new PinYinUtil();
        return obj1.String2Alpha(str);
    }
}

