/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.controller;

import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.customer.service.MdmCustomerTagService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTagReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTagRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmCustomerTagController"})
@Api(tags={"\u5ba2\u6237\u753b\u50cf"})
public class MdmCustomerTagController {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerTagController.class);
    @Autowired
    private MdmCustomerTagService mdmCustomerTagService;

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u67e5\u8be2\u5bf9\u5e94\u6807\u7b7e")
    @PostMapping(value={"/findList"})
    @CrmDictMethod
    public Result<List<MdmCustomerTagRespVo>> findList(@RequestBody MdmCustomerTagReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<MdmCustomerTagRespVo> list = this.mdmCustomerTagService.findList(reqVo);
        return Result.ok(list);
    }

    @ApiOperation(value="\u65b0\u589e\u6807\u7b7e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmCustomerTagReqVo reqVo) {
        this.mdmCustomerTagService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664\u6807\u7b7e", httpMethod="GET")
    @GetMapping(value={"/delete"})
    public Result delete(@RequestParam String id) {
        this.mdmCustomerTagService.delete(id);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u6807\u7b7e\u63cf\u8ff0\u67e5\u8be2\u5ba2\u6237")
    @PostMapping(value={"/findListByTag"})
    @CrmDictMethod
    public Result<List<MdmCustomerTagRespVo>> findListByTag(@RequestBody MdmCustomerTagReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getTagDescription(), (String)"\u6807\u7b7e\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        List<MdmCustomerTagRespVo> list = this.mdmCustomerTagService.findList(reqVo);
        return Result.ok(list);
    }

    @ApiOperation(value="\u6839\u636e\u7ec8\u7aef\u7f16/\u5ba2\u6237\u7f16\u7801list\u67e5\u8be2\u6807\u7b7e")
    @PostMapping(value={"/queryTagByCodeList"})
    @CrmDictMethod
    public Result<List<MdmCustomerTagRespVo>> queryTagByCodeList(@RequestBody List<String> customerCodeList) {
        List<MdmCustomerTagRespVo> mdmCustomerTagRespVos = this.mdmCustomerTagService.queryTagByCodeList(customerCodeList);
        return Result.ok(mdmCustomerTagRespVos);
    }
}

