/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.manager;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.BaseBuilder;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.region.model.MdmRegionEntity;
import com.biz.crm.region.service.MdmRegionService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import io.jsonwebtoken.lang.Assert;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class MdmCustomerMsgBuilder
extends BaseBuilder<MdmCustomerMsgReqVo> {
    private MdmCustomerEntity mdmCustomerMsgEntity;
    private boolean isSave;
    private MdmCustomerMsgService mdmCustomerMsgService;
    private MdmUserService mdmUserService;

    public static MdmCustomerMsgBuilder builder(boolean isSave, MdmCustomerMsgService mdmCustomerMsgService, MdmUserService mdmUserService) {
        MdmCustomerMsgBuilder builder = new MdmCustomerMsgBuilder();
        builder.isSave = isSave;
        builder.mdmCustomerMsgService = mdmCustomerMsgService;
        builder.mdmUserService = mdmUserService;
        return builder;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> valid() {
        Assert.hasText((String)((MdmCustomerMsgReqVo)this.t).getCustomerName(), (String)"\u5ba2\u6237\u4fe1\u606f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((this.isSave || !StringUtils.isEmpty((String)((MdmCustomerMsgReqVo)this.t).getId()) ? 1 : 0) != 0, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        return this;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> convert() {
        MdmCustomerEntity one;
        if (this.isSave) {
            if (StringUtils.isEmpty((String)((MdmCustomerMsgReqVo)this.t).getCustomerCode())) {
                ((MdmCustomerMsgReqVo)this.t).setCustomerCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_CUSTOMER.getCode()));
            } else {
                Integer count = ((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerEntity::getCustomerCode, (Object)((MdmCustomerMsgReqVo)this.t).getCustomerCode())).select(new SFunction[]{BaseIdEntity::getId}).count();
                Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u7801\u5df2\u5b58\u5728");
            }
            ((MdmCustomerMsgReqVo)this.t).setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        } else {
            long count = ((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerEntity::getCustomerCode, (Object)((MdmCustomerMsgReqVo)this.t).getCustomerCode())).select(new SFunction[]{BaseIdEntity::getId}).list().stream().filter(x -> !((MdmCustomerMsgReqVo)this.t).getId().equals(x.getId())).count();
            Assert.isTrue((count < 1L ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u7801\u5df2\u5b58\u5728");
        }
        this.mdmCustomerMsgEntity = (MdmCustomerEntity)CrmBeanUtil.copy((Object)this.t, MdmCustomerEntity.class);
        if (StringUtils.isNotEmpty((String)((MdmCustomerMsgReqVo)this.t).getProvinceCode()) || StringUtils.isNotEmpty((String)((MdmCustomerMsgReqVo)this.t).getCityCode()) || StringUtils.isNotEmpty((String)((MdmCustomerMsgReqVo)this.t).getDistrictCode())) {
            HashSet<String> regionCodeSet = new HashSet<String>(16);
            if (StringUtils.isNotEmpty((String)((MdmCustomerMsgReqVo)this.t).getProvinceCode())) {
                regionCodeSet.add(((MdmCustomerMsgReqVo)this.t).getProvinceCode());
            }
            if (StringUtils.isNotEmpty((String)((MdmCustomerMsgReqVo)this.t).getCityCode())) {
                regionCodeSet.add(((MdmCustomerMsgReqVo)this.t).getCityCode());
            }
            if (StringUtils.isNotEmpty((String)((MdmCustomerMsgReqVo)this.t).getDistrictCode())) {
                regionCodeSet.add(((MdmCustomerMsgReqVo)this.t).getDistrictCode());
            }
            MdmRegionService mdmRegionService = (MdmRegionService)SpringApplicationContextUtil.getApplicationContext().getBean(MdmRegionService.class);
            Map<String, String> regionCodeNameMap = ((LambdaQueryChainWrapper)mdmRegionService.lambdaQuery().in(MdmRegionEntity::getRegionCode, regionCodeSet)).select(new SFunction[]{MdmRegionEntity::getRegionCode, MdmRegionEntity::getRegionName}).list().stream().collect(Collectors.toMap(MdmRegionEntity::getRegionCode, MdmRegionEntity::getRegionName));
            this.mdmCustomerMsgEntity.setProvinceName(regionCodeNameMap.get(this.mdmCustomerMsgEntity.getProvinceCode()));
            this.mdmCustomerMsgEntity.setCityName(regionCodeNameMap.get(this.mdmCustomerMsgEntity.getCityCode()));
            this.mdmCustomerMsgEntity.setDistrictName(regionCodeNameMap.get(this.mdmCustomerMsgEntity.getDistrictCode()));
        }
        if (StringUtils.isEmpty((String)this.mdmCustomerMsgEntity.getActApproveStatus()) && (one = (MdmCustomerEntity)((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerEntity::getCustomerCode, (Object)((MdmCustomerMsgReqVo)this.t).getCustomerCode())).select(new SFunction[]{MdmCustomerEntity::getActApproveStatus, MdmCustomerEntity::getApprovalType}).one()) != null) {
            this.mdmCustomerMsgEntity.setActApproveStatus(one.getActApproveStatus());
            this.mdmCustomerMsgEntity.setApprovalType(one.getApprovalType());
        }
        return this;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> after() {
        this.mdmCustomerMsgService.setUpCollateral((MdmCustomerMsgReqVo)this.t);
        if (MdmBpmStatusEnum.PASS.getValue().equals(this.mdmCustomerMsgEntity.getActApproveStatus())) {
            this.mdmCustomerMsgService.sendCustomerInsertMsg((MdmCustomerMsgReqVo)this.t);
            this.mdmCustomerMsgService.sendCustomerChangeMsg(Collections.singletonList(((MdmCustomerMsgReqVo)this.t).getCustomerCode()));
            this.mdmCustomerMsgService.sendAchievementMsg(((MdmCustomerMsgReqVo)this.t).getCustomerCode(), ((MdmCustomerMsgReqVo)this.t).getFromType());
        }
        return this;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> persistence() {
        if (this.isSave) {
            String id = UUID.randomUUID().toString();
            this.mdmCustomerMsgEntity.setId(id);
            ((MdmCustomerMsgReqVo)this.t).setId(id);
            this.mdmCustomerMsgService.save(this.mdmCustomerMsgEntity);
        } else {
            this.mdmCustomerMsgService.updateById(this.mdmCustomerMsgEntity);
        }
        return this;
    }
}

