/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.material.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.material.service.MdmMaterialGroupService;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupReqVo;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmMaterialGroupController"})
@Api(tags={"MDM-\u7269\u6599\u7ec4\u7ba1\u7406"})
@CrmGlobalLog
public class MdmMaterialGroupController {
    private static final Logger log = LoggerFactory.getLogger(MdmMaterialGroupController.class);
    @Autowired
    private MdmMaterialGroupService mdmMaterialGroupService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmMaterialGroupRespVo>> pageList(@RequestBody MdmMaterialGroupReqVo groupReqVo) {
        PageResult<MdmMaterialGroupRespVo> result = this.mdmMaterialGroupService.findList(groupReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="materialGroupCode", value="\u7269\u6599\u7ec4\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmDictMethod
    public Result<MdmMaterialGroupRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="materialGroupCode", required=false) String materialGroupCode) {
        MdmMaterialGroupRespVo respVo = this.mdmMaterialGroupService.detail(id, materialGroupCode);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmMaterialGroupReqVo mdmMaterialGroupReqVo) {
        this.mdmMaterialGroupService.save(mdmMaterialGroupReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmMaterialGroupReqVo mdmMaterialGroupReqVo) {
        this.mdmMaterialGroupService.update(mdmMaterialGroupReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.mdmMaterialGroupService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        this.mdmMaterialGroupService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        this.mdmMaterialGroupService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u63d0\u4f9b\u7ed9cps\u7684\u7269\u6599\u7ec4\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageGroupCpsList"})
    @CrmDictMethod
    public Result<PageResult<MdmMaterialGroupRespVo>> pageGroupCpsList(@RequestBody MdmMaterialGroupReqVo groupReqVo) {
        PageResult<MdmMaterialGroupRespVo> result = this.mdmMaterialGroupService.pageGroupCpsList(groupReqVo);
        return Result.ok(result);
    }
}

