/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.poi.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.nebular.mdm.constant.RegionLevelEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapDistrictRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapDistrictStatisticianRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeTotalVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmAmapDistrictStatisticianReqVo;
import com.biz.crm.poi.model.MdmAmapPoiCityEntity;
import com.biz.crm.poi.model.MdmAmapPoiEntity;
import com.biz.crm.poi.model.MdmAmapPoiTypeEntity;
import com.biz.crm.poi.service.MdmAmapPoiCityService;
import com.biz.crm.poi.service.MdmAmapPoiService;
import com.biz.crm.poi.service.MdmAmapPoiTypeService;
import com.biz.crm.poi.service.MdmAmapStatisticianService;
import com.biz.crm.terminal.model.MdmTerminalCustomerElasticsearchEntity;
import com.biz.crm.terminal.service.MdmTerminalElasticsearchService;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PinyinUtils;
import com.biz.crm.utils.EsBoolQueryBuilder;
import com.biz.crm.utils.EsEmptyAggregationPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmAmapStatisticianServiceExpandImpl"})
public class MdmAmapStatisticianServiceImpl
implements MdmAmapStatisticianService {
    private static final Logger log = LoggerFactory.getLogger(MdmAmapStatisticianServiceImpl.class);
    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Autowired
    private MdmTerminalService mdmTerminalService;
    @Autowired
    private MdmAmapPoiCityService mdmAmapPoiCityService;
    @Autowired
    private MdmAmapPoiTypeService mdmAmapPoiTypeService;
    @Autowired
    private MdmAmapPoiService mdmAmapPoiService;
    @Autowired
    private MdmTerminalElasticsearchService mdmTerminalElasticsearchService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    @Override
    public void statisticalType(MdmTerminalStatisticianTypeTotalVo result) {
        List<MdmTerminalStatisticianTypeVo> mdmTerminalStatisticianTypeVos = this.mdmTerminalService.statisticalType(new MdmTerminalVo());
        List<MdmTerminalStatisticianTypeVo> mdmCustomerStatisticianTypeVos = this.mdmCustomerMsgService.statisticalType(new MdmCustomerMsgReqVo());
        MdmTerminalStatisticianTypeVo terminal = new MdmTerminalStatisticianTypeVo();
        terminal.setStatisticianType("terminal");
        terminal.setStatisticianName("\u7ec8\u7aef");
        Integer terminalCount = mdmTerminalStatisticianTypeVos.stream().map(x -> Optional.ofNullable(x.getStatisticianCount()).orElse(0)).mapToInt(x -> x).sum();
        terminal.setStatisticianCount(terminalCount);
        terminal.setChildren(mdmTerminalStatisticianTypeVos);
        MdmTerminalStatisticianTypeVo customer = new MdmTerminalStatisticianTypeVo();
        customer.setStatisticianType("customer");
        customer.setStatisticianName("\u5ba2\u6237");
        Integer customerCount = mdmCustomerStatisticianTypeVos.stream().map(x -> Optional.ofNullable(x.getStatisticianCount()).orElse(0)).mapToInt(x -> x).sum();
        customer.setStatisticianCount(customerCount);
        customer.setChildren(mdmCustomerStatisticianTypeVos);
        result.setCooperationTypeCount(Integer.valueOf(customerCount + terminalCount));
        result.setCooperationTypeList(Arrays.asList(customer, terminal));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<MdmAmapDistrictStatisticianRespVo> statisticalDistrict(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        List statisticianTypeList = mdmAmapDistrictStatisticianReqVo.getStatisticianTypeList();
        if (CollectionUtils.isEmpty((Collection)statisticianTypeList)) {
            return Collections.emptyList();
        }
        ArrayList typeList = new ArrayList();
        Map customerTypeMap = DictUtil.dictMap((String)"customer_type");
        Map terminalTypeMap = DictUtil.dictMap((String)"terminal_type");
        typeList.addAll(customerTypeMap.keySet());
        typeList.addAll(terminalTypeMap.keySet());
        if (CollectionUtils.isEmpty(typeList)) {
            return Collections.emptyList();
        }
        List<Object> districtStatistician = new ArrayList();
        String regionLevel = null;
        String amapDistrictCode = mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode();
        if (!StringUtils.isEmpty((Object)amapDistrictCode)) {
            MdmAmapPoiCityEntity amapPoiCityEntity = (MdmAmapPoiCityEntity)((LambdaQueryChainWrapper)this.mdmAmapPoiCityService.lambdaQuery().eq(MdmAmapPoiCityEntity::getAmapCode, (Object)mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode())).select(new SFunction[]{MdmAmapPoiCityEntity::getRegionCode, MdmAmapPoiCityEntity::getRegionLevel}).one();
            log.info("\u9ad8\u5fb7\u57ce\u5e02:{}", (Object)amapPoiCityEntity);
            if (amapPoiCityEntity == null) {
                return Collections.emptyList();
            }
            regionLevel = amapPoiCityEntity.getRegionLevel();
            String regionCode = amapPoiCityEntity.getRegionCode();
            if (regionCode == null || regionLevel == null) {
                return Collections.emptyList();
            }
            mdmAmapDistrictStatisticianReqVo.setAmapDistrictCode(regionCode);
            amapDistrictCode = regionCode;
        }
        String name = mdmAmapDistrictStatisticianReqVo.getCustomerOrTerminalName();
        String supplyFullName = mdmAmapDistrictStatisticianReqVo.getSupplyFullName();
        String finalAmapDistrictCode = amapDistrictCode;
        BoolQueryBuilder boolQueryBuilder = EsBoolQueryBuilder.lambdaQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"clientSubclass.keyword", typeList)).filter(!StringUtils.isEmpty((Object)name), () -> QueryBuilders.matchPhraseQuery((String)"name", (Object)name)).filter(!StringUtils.isEmpty((Object)amapDistrictCode), () -> QueryBuilders.multiMatchQuery((Object)finalAmapDistrictCode, (String[])new String[]{"amapProvinceCode", "amapCityCode", "amapDistrictCode"})).filter(!StringUtils.isEmpty((Object)supplyFullName), () -> QueryBuilders.matchPhraseQuery((String)"supplyNameList", (Object)supplyFullName)).build();
        TermsAggregationBuilder termsAggregationBuilder = null;
        if (!StringUtils.isEmpty((Object)amapDistrictCode) && regionLevel != null) {
            if (RegionLevelEnum.PROVINCE.getCode().equals(regionLevel)) {
                termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"groupArea").field("cityCode.keyword")).size(35);
            } else {
                if (!RegionLevelEnum.CITY.getCode().equals(regionLevel)) return Collections.emptyList();
                termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"groupArea").field("districtCode.keyword")).size(100);
            }
        } else {
            termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"groupArea").field("provinceCode.keyword")).size(100);
        }
        NativeSearchQuery build = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).addAggregation((AbstractAggregationBuilder)termsAggregationBuilder).withPageable((Pageable)EsEmptyAggregationPage.getInstance()).build();
        AggregatedPage entities = this.elasticsearchTemplate.queryForPage((SearchQuery)build, MdmTerminalCustomerElasticsearchEntity.class);
        Terms terms = (Terms)entities.getAggregations().get("groupArea");
        districtStatistician = terms.getBuckets().stream().map(x -> {
            MdmAmapDistrictStatisticianRespVo respVo = new MdmAmapDistrictStatisticianRespVo();
            respVo.setAmapCode(x.getKeyAsString());
            respVo.setAmapStatistician(Integer.valueOf((int)x.getDocCount()));
            return respVo;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(districtStatistician)) {
            return Collections.emptyList();
        }
        List amapCodeList = districtStatistician.stream().map(MdmAmapDistrictStatisticianRespVo::getAmapCode).filter(amapCode -> !StringUtils.isEmpty((Object)amapCode)).collect(Collectors.toList());
        Map collect = ((LambdaQueryChainWrapper)this.mdmAmapPoiCityService.lambdaQuery().in(MdmAmapPoiCityEntity::getRegionCode, amapCodeList)).select(new SFunction[]{MdmAmapPoiCityEntity::getAmapCode, MdmAmapPoiCityEntity::getAmapName, MdmAmapPoiCityEntity::getRegionCode}).list().stream().filter(x -> !StringUtils.isEmpty((Object)x.getRegionCode())).collect(Collectors.toMap(MdmAmapPoiCityEntity::getRegionCode, Function.identity()));
        Map map = districtStatistician.stream().filter(x -> collect.containsKey(x.getAmapCode())).peek(x -> {
            MdmAmapPoiCityEntity mdmAmapPoiCityEntity = (MdmAmapPoiCityEntity)collect.get(x.getAmapCode());
            x.setAmapCode(mdmAmapPoiCityEntity.getAmapCode());
            String amapName = mdmAmapPoiCityEntity.getAmapName();
            x.setAmapName(amapName);
            if (!StringUtils.isEmpty((Object)amapName)) {
                if (amapName.endsWith("\u7701")) {
                    amapName = amapName.substring(0, amapName.length() - 1);
                }
                x.setAmapPinyin(PinyinUtils.toPinLower((String)amapName, (String)""));
            }
        }).collect(Collectors.toMap(MdmAmapDistrictStatisticianRespVo::getAmapCode, Function.identity(), (x1, x2) -> {
            Integer i1 = Optional.ofNullable(x1.getAmapStatistician()).orElse(0);
            Integer i2 = Optional.ofNullable(x2.getAmapStatistician()).orElse(0);
            x1.setAmapStatistician(Integer.valueOf(i1 + i2));
            return x1;
        }));
        return new ArrayList<MdmAmapDistrictStatisticianRespVo>(map.values());
    }

    @Override
    public void unCooperationStatisticalType(MdmTerminalStatisticianTypeTotalVo vo) {
        List list = this.mdmAmapPoiTypeService.lambdaQuery().select(new SFunction[]{MdmAmapPoiTypeEntity::getTypeCode, MdmAmapPoiTypeEntity::getParentCode, MdmAmapPoiTypeEntity::getTypeName}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"groupType").field("typeCode")).size(5000);
        NativeSearchQuery build = new NativeSearchQueryBuilder().withPageable((Pageable)EsEmptyAggregationPage.getInstance()).addAggregation((AbstractAggregationBuilder)termsAggregationBuilder).build();
        AggregatedPage mdmAmapPoiEntities = this.elasticsearchTemplate.queryForPage((SearchQuery)build, MdmAmapPoiEntity.class);
        Terms terms = (Terms)mdmAmapPoiEntities.getAggregations().get("groupType");
        List buckets = terms.getBuckets();
        HashMap<String, Integer> poiMap = new HashMap<String, Integer>(buckets.size());
        for (Object bucket : buckets) {
            poiMap.put(bucket.getKeyAsString(), (int)bucket.getDocCount());
        }
        ArrayList<MdmTerminalStatisticianTypeVo> result = new ArrayList<MdmTerminalStatisticianTypeVo>();
        for (MdmAmapPoiTypeEntity mdmAmapPoiTypeEntity : list) {
            MdmTerminalStatisticianTypeVo mdmTerminalStatisticianTypeVo = new MdmTerminalStatisticianTypeVo();
            mdmTerminalStatisticianTypeVo.setStatisticianType(mdmAmapPoiTypeEntity.getTypeCode());
            mdmTerminalStatisticianTypeVo.setStatisticianName(mdmAmapPoiTypeEntity.getTypeName());
            mdmTerminalStatisticianTypeVo.setStatisticianCount(Optional.ofNullable(poiMap.get(mdmAmapPoiTypeEntity.getTypeCode())).orElse(0));
            ArrayList<MdmTerminalStatisticianTypeVo> children = new ArrayList<MdmTerminalStatisticianTypeVo>();
            String parentCode = mdmAmapPoiTypeEntity.getParentCode();
            if (StringUtils.isEmpty((Object)parentCode)) {
                result.add(mdmTerminalStatisticianTypeVo);
            }
            for (MdmAmapPoiTypeEntity amapPoiTypeEntity : list) {
                if (!mdmAmapPoiTypeEntity.getTypeCode().equals(amapPoiTypeEntity.getParentCode())) continue;
                MdmTerminalStatisticianTypeVo statisticianTypeVo = new MdmTerminalStatisticianTypeVo();
                statisticianTypeVo.setStatisticianType(amapPoiTypeEntity.getTypeCode());
                statisticianTypeVo.setStatisticianName(amapPoiTypeEntity.getTypeName());
                statisticianTypeVo.setStatisticianCount(Optional.ofNullable(poiMap.get(mdmAmapPoiTypeEntity.getTypeCode())).orElse(0));
                children.add(statisticianTypeVo);
            }
            mdmTerminalStatisticianTypeVo.setChildren(children);
        }
        int sum = 0;
        for (MdmTerminalStatisticianTypeVo typeVo : result) {
            typeVo.setStatisticianCount(this.postCardinality(typeVo));
            sum += typeVo.getStatisticianCount().intValue();
        }
        vo.setUnCooperationTypeCount(Integer.valueOf(sum));
        vo.setUnUooperationTypeList(result);
    }

    protected Integer postCardinality(MdmTerminalStatisticianTypeVo typeVo) {
        if (typeVo != null) {
            List children = typeVo.getChildren();
            if (!CollectionUtils.isEmpty((Collection)children)) {
                for (MdmTerminalStatisticianTypeVo child : children) {
                    child.setStatisticianCount(this.postCardinality(child));
                }
                return children.stream().mapToInt(MdmTerminalStatisticianTypeVo::getStatisticianCount).sum() + typeVo.getStatisticianCount();
            }
            return typeVo.getStatisticianCount();
        }
        return 0;
    }

    @Override
    public List<MdmAmapDistrictStatisticianRespVo> unCooperationStatisticalDistrict(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        String amapDistrictCode = mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode();
        ArrayList<MdmAmapDistrictStatisticianRespVo> result = new ArrayList<MdmAmapDistrictStatisticianRespVo>();
        List statisticianTypeList = mdmAmapDistrictStatisticianReqVo.getStatisticianTypeList();
        if (CollectionUtils.isEmpty((Collection)statisticianTypeList)) {
            return result;
        }
        String area = null;
        String areaName = null;
        if (StringUtils.isEmpty((Object)amapDistrictCode)) {
            area = "amapProvinceCode.keyword";
            areaName = "amapProvinceName";
        } else {
            String regionLevel = this.obtainRegionLevel(amapDistrictCode);
            if (RegionLevelEnum.PROVINCE.getCode().equals(regionLevel)) {
                area = "amapCityCode.keyword";
                areaName = "amapCityName";
            } else if (RegionLevelEnum.CITY.getCode().equals(regionLevel)) {
                area = "amapDistrictCode.keyword";
                areaName = "amapDistrictName";
            } else {
                return Collections.emptyList();
            }
        }
        String name = mdmAmapDistrictStatisticianReqVo.getCustomerOrTerminalName();
        BoolQueryBuilder boolQueryBuilder = EsBoolQueryBuilder.lambdaQuery().filter(!StringUtils.isEmpty((Object)amapDistrictCode), () -> QueryBuilders.multiMatchQuery((Object)amapDistrictCode, (String[])new String[]{"amapProvinceCode", "amapCityCode", "amapDistrictCode"})).filter(!StringUtils.isEmpty((Object)name), () -> QueryBuilders.matchPhraseQuery((String)"name", (Object)name)).build();
        if (!CollectionUtils.isEmpty((Collection)statisticianTypeList)) {
            for (String type : statisticianTypeList) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"typeCode", (Object)type));
            }
            boolQueryBuilder.minimumShouldMatch(1);
        }
        TermsAggregationBuilder groupArea = (TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"groupArea").field(area)).size(100).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"top").size(1).fetchSource(areaName, null));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withPageable((Pageable)EsEmptyAggregationPage.getInstance()).withQuery((QueryBuilder)boolQueryBuilder).addAggregation((AbstractAggregationBuilder)groupArea).build();
        AggregatedPage mdmAmapPoiEntities = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, MdmAmapPoiEntity.class);
        Terms terms = (Terms)mdmAmapPoiEntities.getAggregations().get("groupArea");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            SearchHit[] hits;
            MdmAmapDistrictStatisticianRespVo respVo = new MdmAmapDistrictStatisticianRespVo();
            respVo.setAmapCode(bucket.getKeyAsString());
            respVo.setAmapStatistician(Integer.valueOf((int)bucket.getDocCount()));
            TopHits topHits = (TopHits)bucket.getAggregations().get("top");
            for (SearchHit hit : hits = topHits.getHits().getHits()) {
                Map sourceAsMap = hit.getSourceAsMap();
                Object o = sourceAsMap.get(areaName);
                if (o == null) continue;
                String amapName = (String)o;
                if (amapName.endsWith("\u7701")) {
                    amapName = amapName.substring(0, amapName.length() - 1);
                }
                respVo.setAmapName(amapName);
                respVo.setAmapPinyin(PinyinUtils.toPinLower((String)amapName, (String)""));
            }
            result.add(respVo);
        }
        return result;
    }

    protected String obtainRegionLevel(String amapDistrictCode) {
        return Optional.ofNullable(((LambdaQueryChainWrapper)this.mdmAmapPoiCityService.lambdaQuery().eq(MdmAmapPoiCityEntity::getAmapCode, (Object)amapDistrictCode)).select(new SFunction[]{MdmAmapPoiCityEntity::getRegionLevel}).one()).filter(x -> !StringUtils.isEmpty((Object)x.getRegionLevel())).map(MdmAmapPoiCityEntity::getRegionLevel).orElseThrow(() -> new BusinessException("\u533a\u57df\u7f16\u7801\u4e0d\u5b58\u5728:" + amapDistrictCode));
    }

    @Override
    public List<MdmAmapDistrictRespVo> district(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        List statisticianTypeList = mdmAmapDistrictStatisticianReqVo.getStatisticianTypeList();
        if (CollectionUtils.isEmpty((Collection)statisticianTypeList)) {
            return Collections.emptyList();
        }
        String amapDistrictCode = mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)amapDistrictCode)) {
            return Collections.emptyList();
        }
        MdmAmapPoiCityEntity amapPoiCityEntity = (MdmAmapPoiCityEntity)((LambdaQueryChainWrapper)this.mdmAmapPoiCityService.lambdaQuery().eq(MdmAmapPoiCityEntity::getAmapCode, (Object)mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode())).select(new SFunction[]{MdmAmapPoiCityEntity::getRegionCode, MdmAmapPoiCityEntity::getAmapCode, MdmAmapPoiCityEntity::getAmapCode}).one();
        log.info("\u9ad8\u5fb7\u5730\u56fe\u533a\u57df\u67e5\u8be2:{}", (Object)amapDistrictCode);
        String regionCode = Optional.ofNullable(amapPoiCityEntity).map(MdmAmapPoiCityEntity::getRegionCode).filter(x -> !StringUtils.isEmpty((Object)x)).orElseThrow(() -> new BusinessException("\u533a\u57df\u4e0d\u5b58\u5728:" + amapDistrictCode));
        mdmAmapDistrictStatisticianReqVo.setAmapDistrictCode(regionCode);
        return this.mdmTerminalElasticsearchService.listCondition(mdmAmapDistrictStatisticianReqVo);
    }

    @Override
    public List<MdmAmapDistrictRespVo> unCooperationDistrict(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        String amapDistrictCode = mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode();
        if (StringUtils.isEmpty((Object)amapDistrictCode)) {
            return Collections.emptyList();
        }
        List statisticianTypeList = mdmAmapDistrictStatisticianReqVo.getStatisticianTypeList();
        if (CollectionUtils.isEmpty((Collection)statisticianTypeList)) {
            return Collections.emptyList();
        }
        String customerOrTerminalName = mdmAmapDistrictStatisticianReqVo.getCustomerOrTerminalName();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmAmapPoiService.lambdaQuery().eq(MdmAmapPoiEntity::getAmapDistrictCode, (Object)amapDistrictCode)).in(MdmAmapPoiEntity::getTypeCode, (Collection)statisticianTypeList)).like(!StringUtils.isEmpty((Object)customerOrTerminalName), MdmAmapPoiEntity::getPoiName, (Object)customerOrTerminalName)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return list.stream().map(x -> {
            MdmAmapDistrictRespVo respVo = new MdmAmapDistrictRespVo();
            respVo.setAmapCode(x.getAmapDistrictCode());
            respVo.setAmapName(x.getAmapDistrictName());
            respVo.setStatisticianCode(x.getId());
            respVo.setStatisticianName(x.getPoiName());
            respVo.setStatisticianName(x.getTypeCode());
            respVo.setStatisticianName(x.getAddress());
            respVo.setStatisticianContactPhone(x.getTel());
            respVo.setStatisticianContactName(x.getPoiName());
            respVo.setStatisticianFullName(x.getPoiName());
            respVo.setLongitude(x.getLongitude());
            respVo.setLatitude(x.getLatitude());
            return respVo;
        }).collect(Collectors.toList());
    }

    @Override
    public MdmTerminalStatisticianTypeTotalVo statisticalTotal() {
        MdmTerminalStatisticianTypeTotalVo result = new MdmTerminalStatisticianTypeTotalVo();
        this.statisticalType(result);
        this.unCooperationStatisticalType(result);
        return result;
    }
}

