/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.FileTypeEnum;
import com.biz.crm.eunm.IsShelfEnum;
import com.biz.crm.kms.service.MdmProService;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.availablelist.AvalibleListProductLevelChangeDto;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceProductUnitRespVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.product.req.MdmProductAndProductLevelReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductBySfaReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductMediaReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductQueryReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductSelectReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductShelfPriceReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseAndPriceReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseAndPriceRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAndProductLevelRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductBaseDataRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductBySfaRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductIntroductionRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMaterialRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductQueryRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductSaleCompanyRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductSelectRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.product.mapper.MdmProductMapper;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.model.MdmProductIntroductionEntity;
import com.biz.crm.product.model.MdmProductMaterialEntity;
import com.biz.crm.product.model.MdmProductMediaEntity;
import com.biz.crm.product.service.IMdmProductIntroductionService;
import com.biz.crm.product.service.MdmProductMaterialService;
import com.biz.crm.product.service.MdmProductMediaService;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.product.service.impl.MdmProductBuilder;
import com.biz.crm.product.service.impl.MdmProductServiceHelper;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.shoppingcart.service.ShoppingCartService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.ProductLevelUtil;
import com.bizunited.platform.common.util.JsonUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmProductServiceExpandImpl"})
public class MdmProductServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmProductMapper, MdmProductEntity>
implements MdmProductService {
    private static final Logger log = LoggerFactory.getLogger(MdmProductServiceImpl.class);
    @Resource
    private MdmProductMapper mdmProductMapper;
    @Autowired
    private MdmProductServiceHelper productServiceHelper;
    @Autowired
    private MdmProductMediaService mdmProductMediaService;
    @Autowired
    private MdmProductMaterialService mdmProductMaterialService;
    @Resource
    private IMdmProductIntroductionService mdmProductIntroductionService;
    @Resource
    private CusAvailablelistService cusAvailablelistService;
    @Resource
    private TerminalAvailablelistService terminalAvailablelistService;
    @Resource
    private MdmProductLevelService mdmProductLevelService;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Autowired
    private IMdmPriceSettingService mdmPriceSettingService;
    @Autowired
    private MdmProService mdmProService;
    @Autowired
    private ShoppingCartService shoppingCartService;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;

    @Override
    public PageResult<MdmProductRespVo> findList(MdmProductReqVo mdmProductReqVo) {
        MdmProductLevelRespVo productLevel;
        Page page = PageUtil.buildPage((Integer)mdmProductReqVo.getPageNum(), (Integer)mdmProductReqVo.getPageSize());
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)mdmProductReqVo.getCode()) && (productLevel = this.mdmProductLevelService.detail(null, mdmProductReqVo.getCode())) != null) {
            mdmProductReqVo.setRuleCode(productLevel.getRuleCode());
        }
        List<MdmProductRespVo> list = this.mdmProductMapper.findList((Page<MdmProductRespVo>)page, mdmProductReqVo);
        this.productServiceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmProductRespVo detail(String id, String productCode) {
        MdmProductEntity one;
        if ((com.biz.crm.util.StringUtils.isNotEmpty((String)id) || com.biz.crm.util.StringUtils.isNotEmpty((String)productCode)) && (one = (MdmProductEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(com.biz.crm.util.StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(com.biz.crm.util.StringUtils.isNotEmpty((String)productCode), MdmProductEntity::getProductCode, (Object)productCode)).one()) != null) {
            MdmProductLevelEntity productLevel;
            MdmProductRespVo respVo = (MdmProductRespVo)CrmBeanUtil.copy((Object)one, MdmProductRespVo.class);
            String productLevelCode = one.getProductLevelCode();
            if (!com.biz.crm.util.StringUtils.isEmpty((String)productLevelCode) && (productLevel = (MdmProductLevelEntity)((LambdaQueryChainWrapper)this.mdmProductLevelService.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)one.getProductLevelCode())).one()) != null) {
                respVo.setProductLevelName(productLevel.getProductLevelName());
            }
            List<MdmProductMaterialRespVo> materialRespVos = this.productServiceHelper.findMaterialByProductCode(one.getProductCode());
            respVo.setMaterialList(materialRespVos);
            List<MdmProductMediaRespVo> medias = this.mdmProductMediaService.list(new MdmProductMediaReqVo().setProductCode(one.getProductCode()));
            if (CollectionUtils.isNotEmpty(medias)) {
                Map<String, List<MdmProductMediaRespVo>> mediaMap = medias.stream().collect(Collectors.groupingBy(MdmProductMediaRespVo::getType));
                List<MdmProductMediaRespVo> pictureList = mediaMap.get(FileTypeEnum.PICTURE.getCode());
                respVo.setPictureList(pictureList);
                respVo.setVideoList(mediaMap.get(FileTypeEnum.VIDEO.getCode()));
            }
            MdmProductIntroductionRespVo introduction = this.productServiceHelper.findIntroductionByProductCode(one.getProductCode());
            respVo.setIntroductionVo(introduction);
            return respVo;
        }
        return null;
    }

    @Override
    public List<MdmProductRespVo> queryBatch(List<String> ids, List<String> productCodeList) {
        List list;
        if ((CollectionUtil.listNotEmptyNotSizeZero(ids) || CollectionUtil.listNotEmptyNotSizeZero(productCodeList)) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtil.listNotEmptyNotSizeZero(ids), BaseIdEntity::getId, ids)).or()).in(CollectionUtil.listNotEmptyNotSizeZero(productCodeList), MdmProductEntity::getProductCode, productCodeList)).list()))) {
            return CrmBeanUtil.copyList((List)list, MdmProductRespVo.class);
        }
        return new ArrayList<MdmProductRespVo>();
    }

    @Override
    public List<MdmProductRespVo> queryBatchByProductLevelCodeList(List<String> productLevelCodeList) {
        List list;
        List childrenProductLevelCodeListIncludeSelf;
        if (CollectionUtil.listNotEmptyNotSizeZero(productLevelCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(childrenProductLevelCodeListIncludeSelf = ProductLevelUtil.getChildrenProductLevelCodeListIncludeSelf(productLevelCodeList))) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmProductEntity::getProductLevelCode, (Collection)childrenProductLevelCodeListIncludeSelf)).list()))) {
            return CrmBeanUtil.copyList((List)list, MdmProductRespVo.class);
        }
        return new ArrayList<MdmProductRespVo>();
    }

    @Override
    public List<MdmProductQueryRespVo> queryProductList(MdmProductQueryReqVo reqVo) {
        List list;
        List childrenProductLevelCodeListIncludeSelfEnable;
        ArrayList allUnderProductLevelCodeList = new ArrayList();
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getUnderProductLevelCode())) {
            childrenProductLevelCodeListIncludeSelfEnable = ProductLevelUtil.getChildrenProductLevelCodeListIncludeSelfEnable((String)reqVo.getUnderProductLevelCode());
            if (CollectionUtil.listEmpty((List)childrenProductLevelCodeListIncludeSelfEnable)) {
                return new ArrayList<MdmProductQueryRespVo>();
            }
            allUnderProductLevelCodeList.addAll(childrenProductLevelCodeListIncludeSelfEnable);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getUnderProductLevelCodeList())) {
            childrenProductLevelCodeListIncludeSelfEnable = ProductLevelUtil.getChildrenProductLevelCodeListIncludeSelfEnable((List)reqVo.getUnderProductLevelCodeList());
            if (CollectionUtil.listEmpty((List)childrenProductLevelCodeListIncludeSelfEnable)) {
                return new ArrayList<MdmProductQueryRespVo>();
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(allUnderProductLevelCodeList)) {
                allUnderProductLevelCodeList.retainAll(childrenProductLevelCodeListIncludeSelfEnable);
                if (CollectionUtil.listEmpty(allUnderProductLevelCodeList)) {
                    return new ArrayList<MdmProductQueryRespVo>();
                }
            } else {
                allUnderProductLevelCodeList.addAll(childrenProductLevelCodeListIncludeSelfEnable);
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getProductLevelCode()), MdmProductEntity::getProductLevelCode, (Object)reqVo.getProductLevelCode())).eq(com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getProductType()), MdmProductEntity::getProductType, (Object)reqVo.getProductType())).eq(com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getSaleUnit()), MdmProductEntity::getSaleUnit, (Object)reqVo.getSaleUnit())).eq(com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getBaseUnit()), MdmProductEntity::getBaseUnit, (Object)reqVo.getBaseUnit())).eq(com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getIsShelf()), MdmProductEntity::getIsShelf, (Object)reqVo.getIsShelf())).eq(com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getBarCode()), MdmProductEntity::getBarCode, (Object)reqVo.getBarCode())).eq(com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getSaleCompany()), MdmProductEntity::getSaleCompany, (Object)reqVo.getSaleCompany())).eq(com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getMaintenancePicture()), MdmProductEntity::getMaintenancePicture, (Object)reqVo.getMaintenancePicture())).eq(com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getMaintenanceIntroduction()), MdmProductEntity::getMaintenanceIntroduction, (Object)reqVo.getMaintenanceIntroduction())).eq(com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus())).in(CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getProductCodeList()), MdmProductEntity::getProductCode, (Collection)reqVo.getProductCodeList())).in(CollectionUtil.listNotEmptyNotSizeZero(allUnderProductLevelCodeList), MdmProductEntity::getProductLevelCode, allUnderProductLevelCodeList)).in(CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getProductLevelCodeList()), MdmProductEntity::getProductLevelCode, (Collection)reqVo.getProductLevelCodeList())).like(com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getProductCode()), MdmProductEntity::getProductCode, (Object)reqVo.getProductCode())).like(com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getProductName()), MdmProductEntity::getProductName, (Object)reqVo.getProductName())).list()))) {
            return CrmBeanUtil.copyList((List)list, MdmProductQueryRespVo.class);
        }
        return new ArrayList<MdmProductQueryRespVo>();
    }

    @Override
    public List<MdmProductAdviseRespVo> adviseQuery(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return new ArrayList<MdmProductAdviseRespVo>();
        }
        ArrayList<MdmProductAdviseRespVo> list = new ArrayList<MdmProductAdviseRespVo>(productCodeList.size());
        for (String productCode : productCodeList) {
            MdmProductRespVo mdmProductRespVo = this.detail(null, productCode);
            if (mdmProductRespVo == null) continue;
            MdmProductAdviseRespVo mdmProductAdviseRespVo = (MdmProductAdviseRespVo)CrmBeanUtil.copy((Object)mdmProductRespVo, MdmProductAdviseRespVo.class);
            mdmProductAdviseRespVo.setMaterialList(JsonUtils.obj2JsonString((Object)mdmProductRespVo.getMaterialList()));
            mdmProductAdviseRespVo.setPictureList(JsonUtils.obj2JsonString((Object)mdmProductRespVo.getPictureList()));
            mdmProductAdviseRespVo.setVideoList(JsonUtils.obj2JsonString((Object)mdmProductRespVo.getVideoList()));
            mdmProductAdviseRespVo.setIntroductionVo(JsonUtils.obj2JsonString((Object)mdmProductRespVo.getIntroductionVo()));
            mdmProductAdviseRespVo.setImgUrl(mdmProductRespVo.getPrimaryPictureUrl());
            list.add(mdmProductAdviseRespVo);
        }
        return list;
    }

    @Override
    public Map<String, MdmProductAdviseAndPriceRespVo> queryByProductCodeAndCus(MdmProductAdviseAndPriceReqVo mdmProductAdviseAndPriceReqVo) {
        MdmPriceSearchReqVo mdmPriceSearchReqVo = (MdmPriceSearchReqVo)CrmBeanUtil.copy((Object)mdmProductAdviseAndPriceReqVo, MdmPriceSearchReqVo.class);
        List productCodes = mdmProductAdviseAndPriceReqVo.getProductCodes();
        if (CollectionUtils.isEmpty((Collection)productCodes)) {
            return Collections.emptyMap();
        }
        mdmPriceSearchReqVo.setProductCodeList(productCodes);
        Map<String, MdmProductAdviseAndPriceRespVo> collect = this.mdmPriceSettingService.search(mdmPriceSearchReqVo).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> {
            MdmProductRespVo detail = this.detail(null, (String)x.getKey());
            return Optional.ofNullable(CrmBeanUtil.copy((Object)detail, MdmProductAdviseAndPriceRespVo.class)).map(k -> {
                MdmPriceResp price;
                k.setImgUrl(detail.getPrimaryPictureUrl());
                Map value = (Map)x.getValue();
                if (value != null && (price = (MdmPriceResp)value.get("sale_price")) != null) {
                    k.setSalePrice(price.getPrice());
                }
                return k;
            }).orElse(new MdmProductAdviseAndPriceRespVo());
        }));
        for (String productCode : productCodes) {
            collect.putIfAbsent(productCode, null);
        }
        return collect;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmProductReqVo mdmProductReqVo) {
        AssertUtils.isNotEmpty((String)mdmProductReqVo.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        mdmProductReqVo.setId(null);
        if (com.biz.crm.util.StringUtils.isEmpty((String)mdmProductReqVo.getProductCode())) {
            mdmProductReqVo.setProductCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_PRODUCT_CODE.getCode()));
        } else {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductEntity::getProductCode, (Object)mdmProductReqVo.getProductCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u5546\u54c1\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        MdmProductBuilder.builder(this.productServiceHelper, mdmProductReqVo).init().check().convert().save();
        this.sendChangeMsg(Collections.singletonList(mdmProductReqVo.getProductCode()));
        this.sendProductLevelChangeMsg(null, mdmProductReqVo);
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            MdmProductEntity one = (MdmProductEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductEntity::getProductCode, (Object)mdmProductReqVo.getProductCode())).one();
            this.crmLogSendUtil.sendForAdd((String)menuObject, one.getId(), one.getProductCode(), CrmBeanUtil.copy((Object)one, MdmProductReqVo.class));
        }
        this.mdmProService.add(mdmProductReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmProductReqVo mdmProductReqVo) {
        Assert.hasText((String)mdmProductReqVo.getId(), (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmProductEntity one = (MdmProductEntity)this.getById((Serializable)((Object)mdmProductReqVo.getId()));
        Assert.notNull((Object)one, (String)"\u672a\u627e\u5230\u5546\u54c1");
        MdmProductReqVo oldObject = (MdmProductReqVo)CrmBeanUtil.copy((Object)one, MdmProductReqVo.class);
        Assert.isTrue((boolean)IsShelfEnum.DOWN.getCode().equals(one.getIsShelf()), (String)"\u53ea\u80fd\u7f16\u8f91\u72b6\u6001\u4e3a\u201c\u4e0b\u67b6\u201d\u7684\u5546\u54c1");
        Assert.isTrue((boolean)one.getProductCode().equals(mdmProductReqVo.getProductCode()), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        MdmProductBuilder.builder(this.productServiceHelper, mdmProductReqVo).init().check().convert().update();
        this.sendChangeMsg(Collections.singletonList(mdmProductReqVo.getProductCode()));
        this.sendProductLevelChangeMsg((MdmProductReqVo)CrmBeanUtil.copy((Object)one, MdmProductReqVo.class), mdmProductReqVo);
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            MdmProductEntity newEntity = (MdmProductEntity)this.getById((Serializable)((Object)mdmProductReqVo.getId()));
            MdmProductReqVo newObject = (MdmProductReqVo)CrmBeanUtil.copy((Object)newEntity, MdmProductReqVo.class);
            this.crmLogSendUtil.sendForUpdate((String)menuObject, one.getId(), one.getProductCode(), (Object)oldObject, (Object)newObject);
        }
        this.mdmProService.update(mdmProductReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u4f20\u5165\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
            list.forEach(item -> Assert.isTrue((!IsShelfEnum.UP.getCode().equals(item.getIsShelf()) ? 1 : 0) != 0, (String)"\u4e0a\u67b6\u7684\u5546\u54c1\u4e0d\u80fd\u5220\u9664"));
            list.forEach(item -> {
                ((LambdaUpdateChainWrapper)this.mdmProductMediaService.lambdaUpdate().eq(MdmProductMediaEntity::getProductCode, (Object)item.getProductCode())).remove();
                ((LambdaUpdateChainWrapper)this.mdmProductMaterialService.lambdaUpdate().eq(MdmProductMaterialEntity::getProductCode, (Object)item.getProductCode())).remove();
                ((LambdaUpdateChainWrapper)this.mdmProductIntroductionService.lambdaUpdate().eq(MdmProductIntroductionEntity::getProductCode, (Object)item.getProductCode())).remove();
                if (menuObject != null) {
                    this.crmLogSendUtil.sendForDel((String)menuObject, item.getId(), item.getProductCode(), CrmBeanUtil.copy((Object)item, MdmProductReqVo.class));
                }
            });
            this.mdmProService.remove(list.stream().map(MdmProductEntity::getProductCode).collect(Collectors.toList()));
            this.removeByIds(list.stream().map(BaseIdEntity::getId).collect(Collectors.toList()));
            this.sendDelMsg(list.stream().map(MdmProductEntity::getProductCode).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> productCodeList = new ArrayList<String>();
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductEntity one = (MdmProductEntity)this.getById((Serializable)((Object)id));
            Assert.notNull((Object)one, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
            if (!CrmEnableStatusEnum.ENABLE.getCode().equals(one.getEnableStatus())) {
                one.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                this.updateById(one);
                productCodeList.add(one.getProductCode());
            }
        });
        this.sendChangeMsg(productCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> productCodeList = new ArrayList<String>();
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductEntity one = (MdmProductEntity)this.getById((Serializable)((Object)id));
            Assert.notNull((Object)one, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
            if (!CrmEnableStatusEnum.DISABLE.getCode().equals(one.getEnableStatus())) {
                one.setIsShelf(IsShelfEnum.DOWN.getCode());
                one.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                this.updateById(one);
                productCodeList.add(one.getProductCode());
            }
        });
        this.sendChangeMsg(productCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void upShelf(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> productCodeList = new ArrayList<String>();
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductEntity one = (MdmProductEntity)this.getById((Serializable)((Object)id));
            Assert.notNull((Object)one, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)com.biz.crm.util.StringUtils.isNotEmpty((String)one.getProductLevelCode()), (String)"\u4ea7\u54c1\u7cfb\u5217\u4e3a\u7a7a\u7684\u7aef\u53e3\u4e0d\u5141\u8bb8\u4e0a\u67b6");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(one.getEnableStatus()), (String)"\u53ea\u80fd\u4e0a\u67b6\u72b6\u6001\u4e3a\u201c\u542f\u7528\u201d\u7684\u5546\u54c1");
            if (!IsShelfEnum.UP.getCode().equals(one.getIsShelf())) {
                one.setIsShelf(IsShelfEnum.UP.getCode());
                this.updateById(one);
                productCodeList.add(one.getProductCode());
            }
        });
        this.sendChangeMsg(productCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void downShelf(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> productCodeList = new ArrayList<String>();
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductEntity one = (MdmProductEntity)this.getById((Serializable)((Object)id));
            Assert.notNull((Object)one, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
            if (!IsShelfEnum.DOWN.getCode().equals(one.getIsShelf())) {
                one.setIsShelf(IsShelfEnum.DOWN.getCode());
                this.updateById(one);
                productCodeList.add(one.getProductCode());
            }
        });
        log.info("\u6e05\u7a7a\u8d2d\u7269\u8f66={}", productCodeList);
        this.shoppingCartService.clearShoppingCar(null, productCodeList);
        this.sendChangeMsg(productCodeList);
    }

    public void sendProductLevelChangeMsg(MdmProductReqVo original, MdmProductReqVo current) {
        if (current == null && original == null) {
            return;
        }
        try {
            String productCode = current != null ? current.getProductCode() : original.getProductCode();
            AvalibleListProductLevelChangeDto productLevelChangeDTO = new AvalibleListProductLevelChangeDto();
            productLevelChangeDTO.setGoodsCode(productCode);
            productLevelChangeDTO.setNewLevelCode(current != null ? current.getProductLevelCode() : null);
            productLevelChangeDTO.setOldLevelCode(current != null ? original.getProductLevelCode() : null);
            log.info("\u5546\u54c1\u4ea7\u54c1\u5c42\u7ea7\u4fee\u6539\u901a\u77e5:{}", (Object)productLevelChangeDTO);
            RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
            rocketMQMessageBody.setTopic(this.topic);
            rocketMQMessageBody.setTag("AVAILBLELIST_REFRSH_UPDATE_PRODUCT_LEVEL");
            rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)rocketMQMessageBody));
            this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
        catch (Exception e) {
            log.error("\u4ea7\u54c1\u5c42\u7ea7\u901a\u77e5\u5931\u8d25:{}", (Throwable)e);
        }
    }

    @Override
    public void sendChangeMsg(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return;
        }
        log.info("\u5546\u54c1\u4fee\u6539\u901a\u77e5:{}", productCodeList);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(this.topic);
        rocketMQMessageBody.setTag("AVAILBLELIST_UPDATEPRODUCT");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(this.adviseQuery(productCodeList)));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    public void sendDelMsg(List<String> productCodeList) {
        log.info("\u5546\u54c1\u5220\u9664\u901a\u77e5:{}", productCodeList);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(this.topic);
        rocketMQMessageBody.setTag("AVAILBLELIST_DELPRODUCT");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(productCodeList));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    public Map<String, List<MdmProductSaleCompanyRespVo>> findSaleCompanyByProductCodeList(List<String> productCodeList) {
        log.info("\u5546\u54c1\u7ba1\u7406\uff1a\u6839\u636e\u5546\u54c1\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7269\u6599\u9500\u552e\u516c\u53f8,\u5165\u53c2:{}", productCodeList);
        if (CollectionUtils.isEmpty(productCodeList)) {
            return Collections.emptyMap();
        }
        List<MdmProductSaleCompanyRespVo> companyList = this.mdmProductMapper.findSaleCompanyByProductCodeList(productCodeList);
        log.info("\u5546\u54c1\u7ba1\u7406\uff1a\u6839\u636e\u5546\u54c1\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7269\u6599\u9500\u552e\u516c\u53f8,\u7ed3\u679c:{}", companyList);
        if (CollectionUtils.isEmpty(companyList)) {
            return productCodeList.stream().distinct().collect(Collectors.toMap(Function.identity(), x -> new ArrayList()));
        }
        Map map = DictUtil.getDictValueMapsByCodes((String)"sale_company");
        log.info("\u5546\u54c1\u7ba1\u7406\uff1a\u6839\u636e\u5546\u54c1\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7269\u6599\u9500\u552e\u516c\u53f8,\u5b57\u5178:{}", (Object)map);
        return companyList.stream().peek(x -> {
            String saleCompanyCode = x.getSaleCompanyCode();
            if (!com.biz.crm.util.StringUtils.isEmpty((String)saleCompanyCode) && map != null) {
                x.setSaleCompanyName((String)map.get(saleCompanyCode));
            }
        }).collect(Collectors.groupingBy(MdmProductSaleCompanyRespVo::getProductCode));
    }

    @Override
    public List<MdmProductAndProductLevelRespVo> findProductAndProductLevelByCodeOrName(MdmProductAndProductLevelReqVo reqVo) {
        if (reqVo.getPageSize() == null || reqVo.getPageSize() == 0) {
            reqVo.setPageSize(Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size")));
        }
        return this.mdmProductMapper.findProductAndProductLevelByCodeOrName((Page<MdmProductAndProductLevelRespVo>)new Page(1L, (long)reqVo.getPageSize().intValue(), false), reqVo);
    }

    @Override
    public List<MdmProductSelectRespVo> productSelectList(MdmProductSelectReqVo reqVo) {
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        ArrayList<MdmProductSelectRespVo> list = new ArrayList<MdmProductSelectRespVo>();
        HashSet<String> codeList = new HashSet<String>(16);
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        if (pageSize > 0) {
            list.addAll(this.mdmProductMapper.productSelectList((Page<MdmProductSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo, null, null));
        }
        HashSet productLevelCodes = Sets.newHashSet();
        list.forEach(o -> {
            o.setProductCodeName(o.getProductCode() + "-" + o.getProductName());
            if (StringUtils.isNotEmpty((CharSequence)o.getProductLevelCode())) {
                productLevelCodes.add(o.getProductLevelCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)productLevelCodes)) {
            Map<String, String> map = ProductLevelUtil.getProductLevelByCodeList((List)Lists.newArrayList((Iterable)productLevelCodes)).stream().collect(Collectors.toMap(MdmProductLevelRespVo::getProductLevelCode, MdmProductLevelRespVo::getProductLevelName));
            list.forEach(o -> {
                if (com.biz.crm.util.StringUtils.isNotEmpty((String)o.getProductLevelCode())) {
                    o.setProductLevelName((String)map.get(o.getProductLevelCode()));
                }
            });
        }
        return list;
    }

    @Override
    public List<MdmPriceProductUnitRespVo> findProductUnit(String productCode) {
        MdmProductEntity one;
        ArrayList<MdmPriceProductUnitRespVo> list = new ArrayList<MdmPriceProductUnitRespVo>();
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)productCode) && (one = (MdmProductEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductEntity::getProductCode, (Object)productCode)).select(new SFunction[]{MdmProductEntity::getProductCode, MdmProductEntity::getBaseUnit, MdmProductEntity::getSaleUnit}).one()) != null) {
            if (com.biz.crm.util.StringUtils.isNotEmpty((String)one.getBaseUnit())) {
                String baseUnit = one.getBaseUnit();
                MdmPriceProductUnitRespVo baseUnitVo = new MdmPriceProductUnitRespVo();
                baseUnitVo.setUnitType("baseUnit");
                baseUnitVo.setUnitTypeName("\u57fa\u672c\u5355\u4f4d");
                baseUnitVo.setPriceUnit(baseUnit);
                baseUnitVo.setPriceName(DictUtil.dictValue((String)"product_base_unit", (String)baseUnit));
                list.add(baseUnitVo);
            }
            if (com.biz.crm.util.StringUtils.isNotEmpty((String)one.getSaleUnit())) {
                String saleUnit = one.getSaleUnit();
                MdmPriceProductUnitRespVo saleUnitVo = new MdmPriceProductUnitRespVo();
                saleUnitVo.setUnitType("saleUnit");
                saleUnitVo.setUnitTypeName("\u9500\u552e\u5355\u4f4d");
                saleUnitVo.setPriceUnit(saleUnit);
                saleUnitVo.setPriceName(DictUtil.dictValue((String)"product_sale_unit", (String)saleUnit));
                list.add(saleUnitVo);
            }
        }
        return list;
    }

    @Override
    public List<MdmProductRespVo> listCondition(MdmProductReqVo mdmProductReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!com.biz.crm.util.StringUtils.isEmpty((String)mdmProductReqVo.getProductCode()), MdmProductEntity::getProductCode, (Object)mdmProductReqVo.getProductCode())).like(!com.biz.crm.util.StringUtils.isEmpty((String)mdmProductReqVo.getProductName()), MdmProductEntity::getProductName, (Object)mdmProductReqVo.getProductName())).eq(!com.biz.crm.util.StringUtils.isEmpty((String)mdmProductReqVo.getProductLevelCode()), MdmProductEntity::getProductLevelCode, (Object)mdmProductReqVo.getProductLevelCode())).gt(!com.biz.crm.util.StringUtils.isEmpty((String)mdmProductReqVo.getBeginDate()), MdmProductEntity::getBeginDate, (Object)mdmProductReqVo.getBeginDate())).lt(!com.biz.crm.util.StringUtils.isEmpty((String)mdmProductReqVo.getEndDate()), MdmProductEntity::getEndDate, (Object)mdmProductReqVo.getEndDate())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).list();
        return CrmBeanUtil.copyList((List)list, MdmProductRespVo.class);
    }

    @Override
    public List<CusAvailablelistVo> queryShelfProductList(MdmProductShelfPriceReqVo mdmProductShelfPriceReqVo) {
        String conditionTypeCode = mdmProductShelfPriceReqVo.getConditionTypeCode();
        Assert.hasText((String)conditionTypeCode, (String)"\u6761\u4ef6\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String customerCode = mdmProductShelfPriceReqVo.getCustomerCode();
        Assert.hasText((String)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> upProductCodeList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductEntity::getIsShelf, (Object)IsShelfEnum.UP.getCode())).select(new SFunction[]{MdmProductEntity::getProductCode}).list().stream().filter(x -> x != null && !com.biz.crm.util.StringUtils.isEmpty((String)x.getProductCode())).map(MdmProductEntity::getProductCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(upProductCodeList)) {
            return new ArrayList<CusAvailablelistVo>();
        }
        List<MdmProductAdviseRespVo> mdmProductAdviseRespVos = this.adviseQuery(upProductCodeList);
        if (CollectionUtils.isEmpty(mdmProductAdviseRespVos)) {
            return new ArrayList<CusAvailablelistVo>();
        }
        List<CusAvailablelistVo> cusAvailablelistVos = CrmBeanUtil.copyList(mdmProductAdviseRespVos, CusAvailablelistVo.class);
        MdmPriceSearchReqVo mdmPriceSearchReqVo = new MdmPriceSearchReqVo();
        mdmPriceSearchReqVo.setProductCodeList(upProductCodeList);
        mdmPriceSearchReqVo.setConditionTypeCodeList(Collections.singletonList(conditionTypeCode));
        mdmPriceSearchReqVo.setCustomerCode(customerCode);
        Map<String, Map<String, MdmPriceResp>> priceResult = this.mdmPriceSettingService.search(mdmPriceSearchReqVo);
        if (priceResult == null) {
            return cusAvailablelistVos;
        }
        Map<String, MdmPriceResp> mdmPriceRespMap = priceResult.get(conditionTypeCode);
        if (mdmPriceRespMap == null) {
            return cusAvailablelistVos;
        }
        cusAvailablelistVos = cusAvailablelistVos.stream().peek(x -> {
            String productCode = x.getProductCode();
            BigDecimal price = Optional.ofNullable(mdmPriceRespMap.get(productCode)).map(MdmPriceResp::getPrice).orElse(null);
            x.setPrice(price);
        }).collect(Collectors.toList());
        return cusAvailablelistVos;
    }

    @Override
    @CrmDictMethod
    public PageResult<MdmProductBySfaRespVo> findProductListSourceSfa(MdmProductBySfaReqVo reqVo) {
        MdmProductLevelRespVo productLevel;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getCode()) && (productLevel = this.mdmProductLevelService.detail(null, reqVo.getCode())) != null) {
            reqVo.setRuleCode(productLevel.getRuleCode());
        }
        List<MdmProductBySfaRespVo> list = this.mdmProductMapper.findProductListSourceSfa((Page<MdmProductBySfaRespVo>)page, reqVo);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(list).build();
    }

    @Override
    @CrmDictMethod
    public List<MdmProductBaseDataRespVo> findProductBaseSourceSfaTpmAct(List<String> productCodeList) {
        Assert.notNull(productCodeList, (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String now = LocalDateTime.now().format(CrmDateUtils.yyyyMMdd);
        List<MdmProductBaseDataRespVo> list = this.mdmProductMapper.findProductBaseSourceSfaTpmAct(productCodeList, now);
        return list;
    }

    @Override
    public PageResult<MdmProductRespVo> pageListWithCondition(MdmProductReqVo mdmProductReqVo) {
        List<MdmProductRespVo> list;
        MdmProductLevelRespVo productLevel;
        Page page = PageUtil.buildPage((Integer)mdmProductReqVo.getPageNum(), (Integer)mdmProductReqVo.getPageSize());
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)mdmProductReqVo.getCode()) && (productLevel = this.mdmProductLevelService.detail(null, mdmProductReqVo.getCode())) != null) {
            mdmProductReqVo.setRuleCode(productLevel.getRuleCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list = this.mdmProductMapper.pageListWithCondition((Page<MdmProductRespVo>)page, mdmProductReqVo))) {
            for (MdmProductRespVo mdmProductRespVo : list) {
                List materialList = ((LambdaQueryChainWrapper)this.mdmProductMaterialService.lambdaQuery().eq(!com.biz.crm.util.StringUtils.isEmpty((String)mdmProductRespVo.getProductCode()), MdmProductMaterialEntity::getProductCode, (Object)mdmProductRespVo.getProductCode())).list();
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)materialList)) continue;
                mdmProductRespVo.setMaterialList(CrmBeanUtil.copyList((List)materialList, MdmProductMaterialRespVo.class));
            }
        }
        this.productServiceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

