/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.role.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.button.service.MdmButtonRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.function.service.MdmFunctionRoleService;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionButtonStoreVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionRespVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionTreeVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSelectReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonVo;
import com.biz.crm.nebular.mdm.role.req.MdmSwitchFunctionButtonReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmUserRoleReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleSelectRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.permission.model.MdmDataPermissionEntity;
import com.biz.crm.permission.service.IMdmDataPermissionService;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.position.service.MdmPositionUserService;
import com.biz.crm.positionlevel.service.MdmPositionLevelRoleService;
import com.biz.crm.role.mapper.MdmRoleMapper;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubButtonService;
import com.biz.crm.user.service.MdmUserRelRoleService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DatabaseTypeUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.cache.TableConfigUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmRoleServiceExpandImpl"})
public class MdmRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmRoleMapper, MdmRoleEntity>
implements MdmRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmRoleServiceImpl.class);
    @Resource
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private MdmPositionRoleService mdmPositionRoleService;
    @Resource
    private MdmPositionLevelRoleService mdmPositionLevelRoleService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmFunctionService mdmFunctionService;
    @Resource
    private IMdmFunctionSubButtonService mdmFunctionSubButtonService;
    @Resource
    private MdmFunctionRoleService mdmFunctionRoleService;
    @Resource
    private MdmButtonRoleService mdmButtonRoleService;
    @Resource
    private IMdmDataPermissionService mdmDataPermissionService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Resource
    private MdmUserService mdmUserService;
    @Resource
    private MdmUserRelRoleService mdmUserRelRoleService;
    @Resource
    private MdmPositionUserService mdmPositionUserService;

    @Override
    public PageResult<MdmRoleRespVo> findList(MdmRoleReqVo mdmRoleReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmRoleReqVo.getPageNum(), (Integer)mdmRoleReqVo.getPageSize());
        List<MdmRoleRespVo> list = this.mdmRoleMapper.findList((Page<MdmRoleReqVo>)page, mdmRoleReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmRoleRespVo detail(String id, String roleCode) {
        if (StringUtils.isNotEmpty((CharSequence)id) || StringUtils.isNotEmpty((CharSequence)roleCode)) {
            MdmRoleEntity one = (MdmRoleEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((CharSequence)id), BaseIdEntity::getId, (Object)id)).eq(!StringUtils.isEmpty((CharSequence)roleCode), MdmRoleEntity::getRoleCode, (Object)roleCode)).one();
            return (MdmRoleRespVo)CrmBeanUtil.copy((Object)one, MdmRoleRespVo.class);
        }
        return null;
    }

    @Override
    public List<MdmRoleRespVo> queryBatchByRoleCodeList(List<String> roleCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(roleCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmRoleEntity::getRoleCode, roleCodeList)).list()))) {
            return CrmBeanUtil.copyList((List)list, MdmRoleRespVo.class);
        }
        return new ArrayList<MdmRoleRespVo>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmRoleReqVo mdmRoleReqVo) {
        mdmRoleReqVo.setId(null);
        if (StringUtils.isBlank((CharSequence)mdmRoleReqVo.getRoleName())) {
            throw new BusinessException("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleEntity::getRoleName, (Object)mdmRoleReqVo.getRoleName())).count();
        Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        if (StringUtils.isBlank((CharSequence)mdmRoleReqVo.getRoleCode())) {
            mdmRoleReqVo.setRoleCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_ROLE_CODE.getCode()));
        } else {
            MdmRoleEntity roleCodeEntity = (MdmRoleEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleEntity::getRoleCode, (Object)mdmRoleReqVo.getRoleCode())).select(new SFunction[]{BaseIdEntity::getId}).last(DatabaseTypeUtil.SEGMENT)).one();
            Assert.isNull((Object)roleCodeEntity, (String)"\u5f53\u524d\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        this.save(CrmBeanUtil.copy((Object)mdmRoleReqVo, MdmRoleEntity.class));
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            this.crmLogSendUtil.sendForAdd(menuObject.toString(), mdmRoleReqVo.getId(), null, (Object)mdmRoleReqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmRoleReqVo mdmRoleReqVo) {
        String id = mdmRoleReqVo.getId();
        Assert.hasText((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        String roleCode = mdmRoleReqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String roleName = mdmRoleReqVo.getRoleName();
        Assert.hasText((String)roleName, (String)"\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmRoleEntity oldEntity = (MdmRoleEntity)this.getById((Serializable)((Object)id));
        Assert.notNull((Object)oldEntity, (String)"\u672a\u627e\u5230\u89d2\u8272");
        List collect = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleEntity::getRoleCode, (Object)roleCode)).select(new SFunction[]{BaseIdEntity::getId}).list().stream().filter(x -> !id.equals(x.getId())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtil.listEmpty(collect), (String)"\u89d2\u8272\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        List collect2 = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleEntity::getRoleName, (Object)roleName)).select(new SFunction[]{BaseIdEntity::getId}).list().stream().filter(x -> !id.equals(x.getId())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtil.listEmpty(collect2), (String)"\u89d2\u8272\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        MdmRoleEntity mdmRoleEntity = (MdmRoleEntity)this.getById((Serializable)((Object)mdmRoleReqVo.getId()));
        MdmRoleReqVo oldObject = (MdmRoleReqVo)CrmBeanUtil.copy((Object)mdmRoleEntity, MdmRoleReqVo.class);
        this.updateById(CrmBeanUtil.copy((Object)mdmRoleReqVo, MdmRoleEntity.class));
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            MdmRoleEntity mdmRoleEntityNew = (MdmRoleEntity)this.getById((Serializable)((Object)mdmRoleReqVo.getId()));
            MdmRoleReqVo newObject = (MdmRoleReqVo)CrmBeanUtil.copy((Object)mdmRoleEntityNew, MdmRoleReqVo.class);
            this.crmLogSendUtil.sendForUpdate(menuObject.toString(), mdmRoleReqVo.getId(), newObject.getRoleName(), (Object)oldObject, (Object)newObject);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmRoleReqVo mdmRoleReqVo) {
        List ids = mdmRoleReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u5fc5\u586b");
        StringBuilder errorMsg = new StringBuilder();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u672a\u627e\u5230\u89d2\u8272");
        for (MdmRoleEntity role : list) {
            List<String> functionCodeList;
            List<String> positionCodeList = this.mdmPositionRoleService.findPositionCodeCodeByRole(Collections.singletonList(role.getRoleCode()));
            if (!CollectionUtils.isEmpty(positionCodeList)) {
                errorMsg.append("\u89d2\u8272:[").append(role.getRoleName()).append("]").append("\u5173\u8054\u804c\u4f4d,\u65e0\u6cd5\u5220\u9664").append(System.lineSeparator());
            }
            if (CollectionUtils.isEmpty(functionCodeList = this.mdmFunctionRoleService.findFunctionCodeByRole(role.getRoleCode()))) continue;
            errorMsg.append("\u89d2\u8272:[").append(role.getRoleName()).append("]").append("\u5173\u8054\u83dc\u5355,\u65e0\u6cd5\u5220\u9664").append(System.lineSeparator());
        }
        String msg = String.valueOf(errorMsg);
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            throw new BusinessException(msg);
        }
        List<String> roleCodeList = list.stream().map(MdmRoleEntity::getRoleCode).collect(Collectors.toList());
        this.mdmPositionLevelRoleService.removeRoleCodes(roleCodeList);
        this.mdmButtonRoleService.deleteByRoleCodeList(roleCodeList);
        ((LambdaUpdateChainWrapper)this.mdmDataPermissionService.lambdaUpdate().in(MdmDataPermissionEntity::getRoleCode, roleCodeList)).remove();
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            for (MdmRoleEntity role : list) {
                this.crmLogSendUtil.sendForDel(menuObject.toString(), role.getId(), role.getRoleCode(), CrmBeanUtil.copy((Object)role, MdmRoleReqVo.class));
            }
        }
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmRoleReqVo mdmRoleReqVo) {
        List ids = mdmRoleReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmRoleReqVo mdmRoleReqVo) {
        List ids = mdmRoleReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmRoleRespVo> roleList(MdmRoleReqVo reqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus())).like(StringUtils.isNotEmpty((CharSequence)reqVo.getRoleCode()), MdmRoleEntity::getRoleCode, (Object)reqVo.getRoleCode())).in(!CollectionUtils.isEmpty((Collection)reqVo.getRoleCodeList()), MdmRoleEntity::getRoleCode, (Collection)reqVo.getRoleCodeList())).like(StringUtils.isNotEmpty((CharSequence)reqVo.getRoleName()), MdmRoleEntity::getRoleName, (Object)reqVo.getRoleName())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).list();
        return CrmBeanUtil.copyList((List)list, MdmRoleRespVo.class);
    }

    @Override
    public List<MdmRoleSelectRespVo> roleSelectList(MdmRoleSelectReqVo reqVo) {
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        ArrayList<MdmRoleSelectRespVo> list = new ArrayList<MdmRoleSelectRespVo>();
        HashSet<String> codeList = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        if (pageSize > 0) {
            list.addAll(this.mdmRoleMapper.roleSelectList((Page<MdmRoleSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo));
        }
        return list;
    }

    @Override
    public MdmRoleFunctionRespVo roleFunctionTree(MdmRoleFunctionReqVo mdmRoleFunctionReqVo) {
        String roleCode = mdmRoleFunctionReqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmRoleEntity mdmRoleEntity = (MdmRoleEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleEntity::getRoleCode, (Object)roleCode)).select(new SFunction[]{MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName, CrmBaseEntity::getRemarks}).one();
        Assert.notNull((Object)mdmRoleEntity, (String)"\u89d2\u8272\u4e0d\u5b58\u5728");
        List<MdmRoleFunctionTreeVo> mdmRoleFunctionTreeVos = this.mdmFunctionService.roleFunctionTree(mdmRoleFunctionReqVo);
        MdmRoleFunctionRespVo mdmRoleFunctionRespVo = new MdmRoleFunctionRespVo();
        mdmRoleFunctionRespVo.setRoleCode(mdmRoleEntity.getRoleCode());
        mdmRoleFunctionRespVo.setRoleName(mdmRoleEntity.getRoleName());
        mdmRoleFunctionRespVo.setRemarks(mdmRoleEntity.getRemarks());
        mdmRoleFunctionRespVo.setMdmRoleFunctionTreeVos(mdmRoleFunctionTreeVos);
        return mdmRoleFunctionRespVo;
    }

    @Override
    public List<MdmRoleSubButtonVo> roleButtonList(MdmRoleSubButtonReqVo mdmRoleSubButtonReqVo) {
        return this.mdmFunctionSubButtonService.buttonList(mdmRoleSubButtonReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveFunctionButton(MdmRoleFunctionButtonStoreVo mdmRoleFunctionButtonStoreVo) {
        String roleCode = mdmRoleFunctionButtonStoreVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String roleName = mdmRoleFunctionButtonStoreVo.getRoleName();
        Assert.hasText((String)roleName, (String)"\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleEntity::getRoleCode, (Object)roleCode)).count();
        Assert.isTrue((count != null && count > 0 ? 1 : 0) != 0, (String)"\u89d2\u8272\u4e0d\u5b58\u5728");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmRoleEntity::getRoleCode, (Object)roleCode)).set(MdmRoleEntity::getRoleName, (Object)roleName)).set(!StringUtils.isEmpty((CharSequence)mdmRoleFunctionButtonStoreVo.getRemarks()), CrmBaseEntity::getRemarks, (Object)mdmRoleFunctionButtonStoreVo.getRemarks()).update();
        List mdmRoleFunctionTreeVos = mdmRoleFunctionButtonStoreVo.getMdmRoleFunctionTreeVos();
        ArrayList<String> functionCodeList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)mdmRoleFunctionTreeVos)) {
            this.setUpFunction(functionCodeList, mdmRoleFunctionTreeVos);
        }
        this.mdmFunctionRoleService.update(roleCode, functionCodeList);
        List mdmRoleSubButtonVos = mdmRoleFunctionButtonStoreVo.getMdmRoleSubButtonVos();
        if (!CollectionUtils.isEmpty((Collection)mdmRoleSubButtonVos)) {
            this.mdmButtonRoleService.setUp(roleCode, mdmRoleSubButtonVos);
        }
        TableConfigUtil.removeAll();
    }

    @Override
    public void switchFunctionButton(MdmSwitchFunctionButtonReqVo mdmSwitchFunctionButtonReqVo) {
        this.mdmFunctionSubButtonService.switchFunctionButton(mdmSwitchFunctionButtonReqVo);
    }

    @Override
    public List<String> getRoleByUserName(String userName, String positionCode) {
        Assert.hasText((String)userName, (String)"\u7f3a\u5931\u8d26\u53f7");
        MdmUserRespVo user = this.mdmUserService.queryByUserName(userName);
        if (user != null) {
            if ((UserTypeEnum.USER.getCode().equals(user.getUserType()) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(user.getUserType())) && !StringUtils.isEmpty((CharSequence)positionCode)) {
                return this.mdmPositionRoleService.findRoleCodeByPosition(Collections.singletonList(positionCode));
            }
            return this.mdmUserRelRoleService.findRoleCodeListByUserName(userName);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getRoleByUserName(String userName) {
        Assert.hasText((String)userName, (String)"\u7f3a\u5931\u8d26\u53f7");
        MdmUserRespVo user = this.mdmUserService.queryByUserName(userName);
        if (user != null) {
            if (UserTypeEnum.USER.getCode().equals(user.getUserType())) {
                List<String> positionCodeList = this.mdmPositionUserService.getPositionCodeListByUserName(userName);
                if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
                    return this.mdmPositionRoleService.findRoleCodeByPosition(positionCodeList);
                }
            } else {
                return this.mdmUserRelRoleService.findRoleCodeListByUserName(userName);
            }
        }
        return new ArrayList<String>();
    }

    @Override
    public List<MdmRoleRespVo> obtainUserRoleList(MdmUserRoleReqVo mdmUserRoleReqVo) {
        String userName = mdmUserRoleReqVo.getUserName();
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return Collections.emptyList();
        }
        MdmUserRespVo user = this.mdmUserService.queryByUserName(userName);
        if (user == null) {
            return Collections.emptyList();
        }
        String userType = user.getUserType();
        if (StringUtils.isEmpty((CharSequence)userType)) {
            return Collections.emptyList();
        }
        mdmUserRoleReqVo.setUserType(userType);
        return this.mdmRoleMapper.obtainUserRoleList(mdmUserRoleReqVo);
    }

    public void setUpFunction(List<String> functionCodeList, List<MdmRoleFunctionTreeVo> mdmRoleFunctionTreeVos) {
        if (!CollectionUtils.isEmpty(mdmRoleFunctionTreeVos)) {
            List currentFunctionCodeList = mdmRoleFunctionTreeVos.stream().filter(x -> !StringUtils.isEmpty((CharSequence)x.getFunctionCode())).filter(x -> !StringUtils.isEmpty((CharSequence)x.getFunctionSelect()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getFunctionSelect())).map(MdmRoleFunctionTreeVo::getFunctionCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(currentFunctionCodeList)) {
                functionCodeList.addAll(currentFunctionCodeList);
            }
            List<MdmRoleFunctionTreeVo> collect = mdmRoleFunctionTreeVos.stream().flatMap(x -> {
                ArrayList children = x.getChildren();
                if (children == null) {
                    children = new ArrayList();
                }
                return children.stream();
            }).collect(Collectors.toList());
            this.setUpFunction(functionCodeList, collect);
        }
    }
}

