/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tableconfig.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalBatchReqVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRedisVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalReqVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRespVo;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.tableconfig.mapper.MdmColumnConfigPersonalMapper;
import com.biz.crm.tableconfig.model.MdmColumnConfigEntity;
import com.biz.crm.tableconfig.model.MdmColumnConfigPersonalEntity;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.tableconfig.service.MdmColumnConfigPersonalService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ColumnConfigPersonalUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmColumnConfigPersonalServiceExpandImpl"})
public class MdmColumnConfigPersonalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmColumnConfigPersonalMapper, MdmColumnConfigPersonalEntity>
implements MdmColumnConfigPersonalService {
    private static final Logger log = LoggerFactory.getLogger(MdmColumnConfigPersonalServiceImpl.class);
    @Resource
    private MdmColumnConfigPersonalMapper mdmColumnConfigPersonalMapper;
    @Resource
    private IMdmColumnConfigService mdmColumnConfigService;
    @Resource
    private MdmPositionRoleService mdmPositionRoleService;

    @Override
    public List<MdmColumnConfigPersonalRespVo> findColumnConfigPersonalList(MdmColumnConfigPersonalBatchReqVo reqVo) {
        String positionCode = this.getCurPositionCode();
        Assert.hasText((String)reqVo.getParentCode(), (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801");
        Assert.hasText((String)reqVo.getFunctionCode(), (String)"\u7f3a\u5931\u529f\u80fd\u7f16\u7801");
        List columnList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmColumnConfigService.lambdaQuery().eq(MdmColumnConfigEntity::getParentCode, (Object)reqVo.getParentCode())).eq(MdmColumnConfigEntity::getFunctionCode, (Object)reqVo.getFunctionCode())).select(new SFunction[]{MdmColumnConfigEntity::getField, MdmColumnConfigEntity::getVisible, MdmColumnConfigEntity::getTitle, MdmColumnConfigEntity::getFormorder}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)columnList)) {
            List<MdmColumnConfigPersonalRespVo> collect = columnList.stream().map(x -> {
                MdmColumnConfigPersonalRespVo personalRespVo = new MdmColumnConfigPersonalRespVo();
                personalRespVo.setTitle(x.getTitle());
                personalRespVo.setField(x.getField());
                personalRespVo.setVisible(x.getVisible());
                personalRespVo.setFormOrder(StringUtils.isNotEmpty((String)x.getFormorder()) ? x.getFormorder() : "100");
                return personalRespVo;
            }).collect(Collectors.toList());
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmColumnConfigPersonalEntity::getPositionCode, (Object)positionCode)).eq(MdmColumnConfigPersonalEntity::getParentCode, (Object)reqVo.getParentCode())).eq(MdmColumnConfigPersonalEntity::getFunctionCode, (Object)reqVo.getFunctionCode())).orderByAsc(MdmColumnConfigPersonalEntity::getFormOrder)).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                Map<String, MdmColumnConfigPersonalEntity> filedMap = list.stream().collect(Collectors.toMap(MdmColumnConfigPersonalEntity::getField, v -> v));
                for (MdmColumnConfigPersonalRespVo item : collect) {
                    if (!filedMap.containsKey(item.getField())) {
                        item.setFormOrder("100");
                        continue;
                    }
                    MdmColumnConfigPersonalEntity mdmColumnConfigPersonalEntity = filedMap.get(item.getField());
                    item.setVisible(mdmColumnConfigPersonalEntity.getVisible());
                    item.setFormOrder(mdmColumnConfigPersonalEntity.getFormOrder());
                }
            }
            collect.sort(Comparator.comparing(x -> Optional.ofNullable(x.getFormOrder()).map(Integer::valueOf).orElse(100)));
            return collect;
        }
        return new ArrayList<MdmColumnConfigPersonalRespVo>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveColumnConfigPersonal(MdmColumnConfigPersonalBatchReqVo reqVo) {
        String positionCode = this.getCurPositionCode();
        Assert.hasText((String)reqVo.getParentCode(), (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801");
        Assert.hasText((String)reqVo.getFunctionCode(), (String)"\u7f3a\u5931\u529f\u80fd\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getColumnList(), (String)"\u7f3a\u5931\u5b57\u6bb5\u914d\u7f6e");
        for (MdmColumnConfigPersonalReqVo item : reqVo.getColumnList()) {
            Assert.hasText((String)item.getField(), (String)"\u7f3a\u5931\u5c5e\u6027");
            Assert.hasText((String)item.getVisible(), (String)"\u7f3a\u5931\u663e\u793a\u6a21\u5f0f");
            Assert.hasText((String)item.getFormOrder(), (String)"\u7f3a\u5931\u663e\u793a\u987a\u5e8f");
            Assert.isTrue((YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getVisible()) || YesNoEnum.yesNoEnum.ZERO.getValue().equals(item.getVisible()) ? 1 : 0) != 0, (String)"\u663e\u793a\u6a21\u5f0f\u53c2\u6570\u4e0d\u5408\u6cd5");
            item.setFunctionCode(reqVo.getFunctionCode());
            item.setParentCode(reqVo.getParentCode());
            item.setPositionCode(positionCode);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmColumnConfigPersonalEntity::getPositionCode, (Object)positionCode)).eq(MdmColumnConfigPersonalEntity::getParentCode, (Object)reqVo.getParentCode())).eq(MdmColumnConfigPersonalEntity::getFunctionCode, (Object)reqVo.getFunctionCode())).remove();
        this.saveBatch(CrmBeanUtil.copyList((List)reqVo.getColumnList(), MdmColumnConfigPersonalEntity.class));
        ColumnConfigPersonalUtil.deleteColumnConfigPersonal((String)reqVo.getParentCode(), (String)reqVo.getFunctionCode(), (String)positionCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteColumnConfigPersonal(MdmColumnConfigPersonalBatchReqVo reqVo) {
        String positionCode = this.getCurPositionCode();
        Assert.hasText((String)reqVo.getParentCode(), (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801");
        Assert.hasText((String)reqVo.getFunctionCode(), (String)"\u7f3a\u5931\u529f\u80fd\u7f16\u7801");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmColumnConfigPersonalEntity::getPositionCode, (Object)positionCode)).eq(MdmColumnConfigPersonalEntity::getParentCode, (Object)reqVo.getParentCode())).eq(MdmColumnConfigPersonalEntity::getFunctionCode, (Object)reqVo.getFunctionCode())).remove();
        ColumnConfigPersonalUtil.deleteColumnConfigPersonal((String)reqVo.getParentCode(), (String)reqVo.getFunctionCode(), (String)positionCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteColumnConfig(String parentCode, String functionCode) {
        Assert.hasText((String)parentCode, (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801");
        Assert.hasText((String)functionCode, (String)"\u7f3a\u5931\u529f\u80fd\u7f16\u7801");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmColumnConfigPersonalEntity::getParentCode, (Object)parentCode)).eq(MdmColumnConfigPersonalEntity::getFunctionCode, (Object)functionCode)).remove();
        ColumnConfigPersonalUtil.deleteColumnConfig((String)parentCode, (String)functionCode);
    }

    @Override
    public List<MdmColumnConfigPersonalRedisVo> findColumnConfigPersonalRedisList(String parentCode, String functionCode, String positionCode) {
        Assert.hasText((String)positionCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        Assert.hasText((String)parentCode, (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801");
        Assert.hasText((String)functionCode, (String)"\u7f3a\u5931\u529f\u80fd\u7f16\u7801");
        ArrayList<MdmColumnConfigPersonalRedisVo> collect = new ArrayList<MdmColumnConfigPersonalRedisVo>();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmColumnConfigPersonalEntity::getPositionCode, (Object)positionCode)).eq(MdmColumnConfigPersonalEntity::getParentCode, (Object)parentCode)).eq(MdmColumnConfigPersonalEntity::getFunctionCode, (Object)functionCode)).orderByAsc(MdmColumnConfigPersonalEntity::getFormOrder)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            collect.addAll(list.stream().map(x -> {
                MdmColumnConfigPersonalRedisVo personalRespVo = new MdmColumnConfigPersonalRedisVo();
                personalRespVo.setField(x.getField());
                personalRespVo.setVisible(x.getVisible());
                personalRespVo.setFormOrder(x.getFormOrder());
                return personalRespVo;
            }).collect(Collectors.toList()));
        }
        collect.sort(Comparator.comparing(x -> Optional.ofNullable(x.getFormOrder()).map(Integer::valueOf).orElse(100)));
        return collect;
    }

    @Override
    public void deleteColumnConfig(String parentCode, String functionCode, String roleCode) {
        Assert.hasText((String)parentCode, (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801");
        Assert.hasText((String)functionCode, (String)"\u7f3a\u5931\u529f\u80fd\u7f16\u7801");
        Assert.hasText((String)roleCode, (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        List<String> positionCodes = this.mdmPositionRoleService.findPositionCodeCodeByRole(Lists.list((Object[])new String[]{roleCode}));
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodes)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmColumnConfigPersonalEntity::getParentCode, (Object)parentCode)).eq(MdmColumnConfigPersonalEntity::getFunctionCode, (Object)functionCode)).in(MdmColumnConfigPersonalEntity::getPositionCode, positionCodes)).remove();
            for (String positionCode : positionCodes) {
                ColumnConfigPersonalUtil.deleteColumnConfigPersonal((String)parentCode, (String)functionCode, (String)positionCode);
            }
        }
    }

    private String getCurPositionCode() {
        UserRedis user = UserUtils.getUser();
        Assert.notNull((Object)user, (String)"\u8bf7\u5148\u767b\u5f55");
        Assert.hasText((String)user.getPoscode(), (String)"\u8bf7\u5148\u767b\u5f55");
        return user.getPoscode();
    }
}

