/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.user.req.MdmConsumerEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserForceChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmConsumerRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerUserPageRespVo;
import com.biz.crm.user.service.MdmConsumerUserService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmConsumerUserController"})
@CrmGlobalLog
@Api(tags={"MDM-\u7528\u6237\u7ba1\u7406\uff08\u6d88\u8d39\u8005\u7528\u6237\uff09"})
public class MdmConsumerUserController {
    private static final Logger log = LoggerFactory.getLogger(MdmConsumerUserController.class);
    @Autowired
    private MdmConsumerUserService mdmConsumerUserService;
    @Autowired
    private MdmUserService mdmUserService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerUserPageRespVo>> pageList(@RequestBody MdmCustomerUserPageReqVo reqVo) {
        PageResult<MdmCustomerUserPageRespVo> result = this.mdmConsumerUserService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmConsumerEditReqVo reqVo) {
        this.mdmConsumerUserService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u8be6\u60c5\uff08\u6d88\u8d39\u7528\u6237\uff09", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="userName", value="\u7528\u6237\u767b\u5f55\u540d", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmDictMethod
    public Result<MdmConsumerRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="userName", required=false) String userName) {
        return Result.ok((Object)this.mdmConsumerUserService.query(id, userName));
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmConsumerEditReqVo reqVo) {
        this.mdmConsumerUserService.update(reqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.mdmConsumerUserService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        this.mdmUserService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        this.mdmUserService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7528\u6237\u89e3\u9501", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unlock"})
    public Result unlock(@RequestBody List<String> ids) {
        this.mdmUserService.unlock(ids);
        return Result.ok((String)"\u89e3\u9501\u6210\u529f");
    }

    @ApiOperation(value="\u89e3\u7ed1\u5fae\u4fe1", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unbindWeChat"})
    public Result unbindWeChat(@RequestBody List<String> ids) {
        this.mdmUserService.unbindWeChat(ids);
        return Result.ok((String)"\u89e3\u7ed1\u6210\u529f");
    }

    @ApiOperation(value="\u5f3a\u5236\u6279\u91cf\u4fee\u6539\u5bc6\u7801", httpMethod="POST")
    @PostMapping(value={"/forceChangePassword"})
    public Result forceChangePassword(@RequestBody MdmUserForceChangePasswordReqVo reqVo) {
        this.mdmUserService.forceChangePassword(reqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }
}

