/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.user.model.MdmUserLoginLogEntity;
import com.biz.crm.user.service.MdmUserLoginLogAsyncService;
import com.biz.crm.user.service.MdmUserLoginLogService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.IpUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ApplicationProperties;
import com.biz.crm.utils.CrmIpResourceUtil;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Subdivision;
import java.net.InetAddress;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"MdmUserLoginLogAsyncServiceExpandImpl"})
public class MdmUserLoginLogAsyncServiceImpl
implements MdmUserLoginLogAsyncService {
    private static final Logger log = LoggerFactory.getLogger(MdmUserLoginLogAsyncServiceImpl.class);
    @Lazy
    @Resource
    private MdmUserLoginLogService mdmUserLoginLogService;
    @Resource
    private MdmUserService mdmUserService;
    @Resource
    private ApplicationProperties applicationProperties;

    @Override
    @Async
    public void saveLoginLog(HttpServletRequest request, String userName, String fullName, String fromType, String loginDateTime) {
        if (request == null) {
            return;
        }
        if (StringUtils.isEmpty((String)userName)) {
            return;
        }
        if (StringUtils.isEmpty((String)fullName)) {
            fullName = this.mdmUserService.getFullNameByUserName(userName);
        }
        MdmUserLoginLogEntity logEntity = new MdmUserLoginLogEntity();
        logEntity.setUserName(userName);
        logEntity.setFullName(fullName);
        logEntity.setFromType(fromType);
        logEntity.setLoginDateTime(loginDateTime);
        this.setClient(logEntity, request);
        this.setServer(logEntity, request);
        this.mdmUserService.updateUserLastLoginDateTime(userName, loginDateTime);
        this.mdmUserLoginLogService.save(logEntity);
    }

    private void setClient(MdmUserLoginLogEntity logEntity, HttpServletRequest request) {
        try {
            String clientIp = IpUtil.getIpAddrByRequest((HttpServletRequest)request);
            logEntity.setClientIp(clientIp);
            if (StringUtils.isEmpty((String)clientIp) || clientIp.contains("0:0:0:0:0:0:0:1") || clientIp.contains("127.0.0.1")) {
                return;
            }
            if (!YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValueNoException((String)"IP_RESOURCE"))) {
                return;
            }
            CityResponse cityResponse = CrmIpResourceUtil.getCityResponse(clientIp);
            Continent continent = cityResponse.getContinent();
            logEntity.setClientContinentZh((String)continent.getNames().get("zh-CN"));
            logEntity.setClientContinentEn((String)continent.getNames().get("en"));
            Country country = cityResponse.getCountry();
            logEntity.setClientCountryZh((String)country.getNames().get("zh-CN"));
            logEntity.setClientCountryEn((String)country.getNames().get("en"));
            Subdivision subdivision = cityResponse.getMostSpecificSubdivision();
            logEntity.setClientSubdivisionZh((String)subdivision.getNames().get("zh-CN"));
            logEntity.setClientSubdivisionEn((String)subdivision.getNames().get("en"));
            City city = cityResponse.getCity();
            logEntity.setClientCityZh((String)city.getNames().get("zh-CN"));
            logEntity.setClientCityEn((String)city.getNames().get("en"));
            Location location = cityResponse.getLocation();
            logEntity.setClientLatitude(location.getLatitude() == null ? null : location.getLatitude().toString());
            logEntity.setClientLongitude(location.getLongitude() == null ? null : location.getLongitude().toString());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u767b\u5f55\u5ba2\u6237\u7aef\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void setServer(MdmUserLoginLogEntity logEntity, HttpServletRequest request) {
        try {
            logEntity.setServerPort(this.applicationProperties.getPort());
            String serverName = request.getServerName();
            InetAddress address = InetAddress.getByName(serverName);
            logEntity.setServerIp(address.getHostAddress());
            logEntity.setServerName(address.getHostName());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u767b\u5f55\u670d\u52a1\u5668\u4fe1\u606f\u5931\u8d25");
        }
    }
}

