package com.biz.crm.msg.wework.vo;


import lombok.Data;

import java.io.Serializable;

/**
 *
 * 参数	        是否必须	说明
 * name	        否	    群聊名，最多50个utf8字符，超过将截断
 * owner	    否	    指定群主的id。如果不指定，系统会随机从userlist中选一人作为群主
 * userlist	    是	    群成员id列表。至少2人，至多2000人
 * chatid	    否	    群聊的唯一标志，不能与已有的群重复；字符串类型，最长32个字符。只允许字符0-9及字母a-zA-Z。如果不填，系统会随机生成群id
 *
 *  @author: luoqi
 *  @Date: 2020-10-9 16:35
 *  @version: V1.0
 *  @Description:
 */
@Data
public class AppchatCreateReq implements Serializable {
    private String name;
    private String owner;
    private String[] userlist;
    private String chatid;

}
