package com.biz.crm.msg.wework.vo;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 *
 * 参数	        是否必须	说明
 * chatid	      是	群聊id
 * msgtype	      是	消息类型，此时固定为：text
 * content	      是	消息内容，最长不超过2048个字节
 * safe	          否	表示是否是保密消息，0表示否，1表示是，默认0
 *  @author: luoqi
 *  @Date: 2020-10-9 16:35
 *  @version: V1.0
 *  @Description:
 */
@ApiModel("消息体")
public class AppchatTextSendReq extends AbstractAppchatSendReq implements Serializable {
    @ApiModelProperty("消息文本内容对象")
    private Text text;
    @ApiModelProperty("是否是保密消息，0表示否，1表示是，默认0")
    private Integer safe = 0;

    public AppchatTextSendReq() {
        super(MSGTYPE.text);
    }

    @ApiModel("消息文本内容对象")
    @Data
    public static class Text implements Serializable {
        @ApiModelProperty("消息文本内容")
        private String content;
    }

    public Text getText() {
        return text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public Integer getSafe() {
        return safe;
    }

    public void setSafe(Integer safe) {
        this.safe = safe;
    }
}
