package com.biz.crm.msg.utils;

import lombok.extern.slf4j.Slf4j;
import org.hamcrest.CustomMatcher;


/**
 * 自定义 Hamcrest Matcher
 * 判断企业微信接口响应状态
 *  @author: luoqi
 *  @Date: 2020-10-10 11:22
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
public class CrmWeworkErrcodeHamcrestMatcher extends CustomMatcher {
    private static final Integer ERRCODE = 0;
    public CrmWeworkErrcodeHamcrestMatcher() {
        super("");
    }

    @Override
    public boolean matches(Object o) {
        if(ERRCODE.equals(o)){
            return true;
        }
        log.warn("企业微信API接口错误");
        return false;
    }
}
