package com.biz.crm.msg.wework;

import com.biz.crm.msg.wework.vo.AbstractAppchatSendReq;
import com.biz.crm.msg.wework.vo.AppchatCreateReq;
import com.biz.crm.msg.wework.vo.AppchatUpdateReq;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

import static io.restassured.RestAssured.given;


/**
 * 企业微信群聊api
 *  @author: luoqi
 *  @Date: 2020-10-9 17:08
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
public class WeworkAppchatApi {
    @Autowired
    private WeworkConfigurer weworkConfigurer;
    @Autowired
    private WeworkAccessToken weworkAccessToken;



    /**
     * 创建群聊
     * 企业微信官方接口文档 https://work.weixin.qq.com/api/doc/90000/90135/90245
     *  @author: luoqi
     *  @Date: 2020-10-9 17:09
     *  @version: V1.0
     *  @Description:
     */
    public void appchatCreate(AppchatCreateReq req) {

        given()
                .queryParam("access_token", weworkAccessToken.getAccessToken())
                .contentType(ContentType.JSON)
                .body(req)
                .when()
                .log().all()
                .post(weworkConfigurer.getAppchatCreateUrl())
                .then().log().all()
                .body("errcode", WeworkConstant.MATCHER_ERRCODE).extract().response();
    }


    /**
     * 修改群聊
     * 企业微信官方接口文档 https://work.weixin.qq.com/api/doc/90000/90135/90246
     *  @author: luoqi
     *  @Date: 2020-10-9 18:45
     *  @version: V1.0
     *  @Description:
     */
    public void appchatUpdate(AppchatUpdateReq req) {
        given()
                .queryParam("access_token", weworkAccessToken.getAccessToken())
                .contentType(ContentType.JSON)
                .body(req)
                .when()
                .log().all()
                .post(weworkConfigurer.getAppchatUpdateUrl())
                .then().log().all()
                .body("errcode", WeworkConstant.MATCHER_ERRCODE).extract().response();
    }

    /**
     * 发送群聊消息
     * 企业微信官方接口文档 https://work.weixin.qq.com/api/doc/90000/90135/90248
     *  @author: luoqi
     *  @Date: 2020-10-9 18:45
     *  @version: V1.0
     *  @Description:
     */
    public void appchatSend(AbstractAppchatSendReq req) {
        given()
                .queryParam("access_token", weworkAccessToken.getAccessToken())
                .contentType(ContentType.JSON)
                .body(req)
                .when()
                .log().all()
                .post(weworkConfigurer.getAppchatSendUrl())
                .then().log().all()
                .body("errcode", WeworkConstant.MATCHER_ERRCODE).extract().response();
    }

    /**
     * 获取群聊信息
     * 企业微信官方接口文档 https://work.weixin.qq.com/api/doc/90000/90135/90247
     *  @author: luoqi
     *  @Date: 2020-10-9 18:45
     *  @version: V1.0
     *  @Description:
     */
    public Map<String, Object> appchatGet(String chatid) {
        if(StringUtils.isBlank(chatid)){
            return null;
        }
        Response response = given().param("access_token", weworkAccessToken.getAccessToken())
                .param("chatid", chatid)
                .when().log().all()
                .get(weworkConfigurer.getAppchatGetUrl())
                .then().log().all()
                .body("errcode", WeworkConstant.MATCHER_ERRCODE).extract().response();
        Map<String, Object> jsonInfo = response.path("chat_info");
        if(null == jsonInfo){
            log.warn("获取微信群聊会话失败 >>> chatid = {}", chatid);
            return null;
        }
        return jsonInfo;
    }

}
