package com.biz.crm.msg.wework;

import com.biz.crm.service.RedisService;
import io.restassured.response.Response;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static io.restassured.RestAssured.given;


/**
 * 企业微信AccessToken获取
 *  @author: luoqi
 *  @Date: 2020-10-9 16:22
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
public class WeworkAccessToken {
    @Autowired
    private WeworkConfigurer weworkConfigurer;

    @Autowired
    private RedisService redisService;


    /**
     * AccessToken获取
     *  @author: luoqi
     *  @Date: 2020-10-9 16:21
     *  @version: V1.0
     *  @Description:
     */
    public String getAccessToken(){
        String token = (String) redisService.get(WeworkConstant.ACCESS_TOKEN_AS_WEWORK);
        if(StringUtils.isBlank(token)){
            token = this.loadToken();
        }
        return token;
    }


    /**
     * 访问接口获取token 并缓存到redis
     *  企业微信官方接口文档 https://work.weixin.qq.com/api/doc/90000/90135/91039
     *  @author: luoqi
     *  @Date: 2020-10-9 16:16
     *  @version: V1.0
     *  @Description:
     */
    private String loadToken(){
        Response response = given().param(WeworkConfigurer.CORPID, weworkConfigurer.getCorpid())
                .param(WeworkConfigurer.CORPSECRET, weworkConfigurer.getCorpsecret())
                .when().log().all()
                .get(weworkConfigurer.getTokenUrl())
                .then().log().all()
                .body("errcode", WeworkConstant.MATCHER_ERRCODE).extract().response();
        String token = response.path("access_token");
        if(StringUtils.isNotBlank(token)){
            boolean redisUpdate = redisService.setMinutes(WeworkConstant.ACCESS_TOKEN_AS_WEWORK, token, 115);
            if(!redisUpdate){
                log.warn("缓存企业微信 access_token 失败");
            }
            return token;
        }
        log.warn("获取企业微信 access_token 失败");
        return null;
    }
}
