package com.biz.crm.msg.wework.vo;



import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 *
 * 参数	        是否必须	说明
 * chatid	      是	群聊id
 * msgtype	      是	消息类型
 *  @author: luoqi
 *  @Date: 2020-10-9 16:35
 *  @version: V1.0
 *  @Description:
 */
public abstract class AbstractAppchatSendReq implements Serializable {
    @ApiModelProperty("群聊ID")
    private String chatid;
    private final String msgtype;
    public AbstractAppchatSendReq(MSGTYPE msgtype){
        this.msgtype = msgtype.name();
    }

    public void setChatid(String chatid) {
        this.chatid = chatid;
    }

    public String getChatid() {
        return chatid;
    }

    public String getMsgtype() {
        return msgtype;
    }


    /**
     *  消息类型
     *  官方文档 https://work.weixin.qq.com/api/doc/90000/90135/90248#%E6%96%87%E6%9C%AC%E6%B6%88%E6%81%AF
     *  @author: luoqi
     *  @Date: 2020-10-10 14:54
     *  @version: V1.0
     *  @Description:
     */
    public enum MSGTYPE{
        text, image, voice, video, file, textcard, news, mpnews, markdown
    }
}
