/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.listener;

import com.baomidou.mybatisplus.annotation.TableId;
import com.biz.crm.base.Datasource;
import com.biz.crm.config.ClassUtil;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmColumnVo;
import com.biz.crm.sqlupdate.CrmTable;
import com.biz.crm.sqlupdate.CrmTableVo;
import com.biz.crm.sqlupdate.IndexVo;
import com.biz.crm.sqlupdate.mysql.MysqlUserTablesService;
import com.biz.crm.sqlupdate.oracle.OracleUserTablesService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Index;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Order(value=0)
public class CrmSqlListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(CrmSqlListener.class);
    @Value(value="${spring.jpa.hibernate.ddl-auto:none}")
    private String ddl;
    @Autowired
    private OracleUserTablesService oracleUserTablesService;
    @Autowired
    private MysqlUserTablesService mysqlUserTablesService;
    private static List<Class<?>> classPaths = new ArrayList();

    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        if (!"update".equalsIgnoreCase(this.ddl)) {
            log.info("\u5f53\u524d\u914d\u7f6e\u4e0d\u6267\u884c\u5bf9\u6bd4==>");
            return;
        }
        log.info("\u5f00\u59cb\u6267\u884cCRM\u8868\u5bf9\u6bd4\u76d1\u542c==>");
        log.info("\u5f53\u524dDB\u73af\u5883==>" + Datasource.datasource);
        if (Datasource.oracleFlag.booleanValue()) {
            this.doOracle();
        } else if (Datasource.mysqlFlag.booleanValue()) {
            this.doMysql();
        }
        classPaths = null;
        log.info("\u7ed3\u675f\u6267\u884cCRM\u8868\u5bf9\u6bd4\u76d1\u542c==>");
    }

    private void doMysql() {
        this.getDataClass();
        List<CrmTableVo> crmTableVos = this.getData();
        this.mysqlUserTablesService.updateSql(crmTableVos);
    }

    private void doOracle() {
        this.getDataClass();
        List<CrmTableVo> crmTableVos = this.getData();
        this.oracleUserTablesService.updateSql(crmTableVos);
    }

    private void getDataClass() {
        String[] pageagePath;
        String voPackagePath = "com.biz.crm";
        for (String path : pageagePath = voPackagePath.split(",")) {
            List<Class<?>> currentClasses = ClassUtil.getClasses(path);
            if (CollectionUtils.isEmpty(currentClasses)) continue;
            for (Class<?> c : currentClasses) {
                if (!c.isAnnotationPresent(CrmTable.class)) continue;
                classPaths.add(c);
            }
        }
    }

    private List<CrmTableVo> getData() {
        ArrayList<CrmTableVo> crmTableVos = new ArrayList<CrmTableVo>();
        for (Class<?> item : classPaths) {
            CrmTableVo crmTableVo = new CrmTableVo();
            CrmTable crmTable = item.getAnnotation(CrmTable.class);
            crmTableVo.setName(crmTable.name().toUpperCase());
            crmTableVo.setTableNote(crmTable.tableNote());
            Index[] indexes = crmTable.indexes();
            ArrayList<IndexVo> indexVos = new ArrayList<IndexVo>();
            if (indexes != null) {
                for (Index index : indexes) {
                    IndexVo indexVo = new IndexVo();
                    indexVo.setColumnList(index.columnList());
                    indexVo.setName(index.name().toUpperCase());
                    indexVo.setUnique(index.unique());
                    indexVos.add(indexVo);
                }
                crmTableVo.setIndexVos(indexVos);
            }
            ArrayList<Field> fields = new ArrayList<Field>();
            Class<?> c = item;
            while (c.getSuperclass() != null) {
                fields.addAll(Arrays.asList(c.getDeclaredFields()));
                c = c.getSuperclass();
            }
            List<CrmColumnVo> crmColumnVos = new ArrayList<CrmColumnVo>();
            if (fields != null) {
                for (Field field : fields) {
                    CrmColumn crmColumn = field.getAnnotation(CrmColumn.class);
                    if (crmColumn == null) continue;
                    CrmColumnVo crmColumnVo = new CrmColumnVo();
                    crmColumnVo.setLength(crmColumn.length());
                    crmColumnVo.setMysqlType(crmColumn.mysqlType());
                    crmColumnVo.setName(crmColumn.name().toUpperCase());
                    crmColumnVo.setNullable(crmColumn.nullable());
                    crmColumnVo.setUnique(crmColumn.unique());
                    crmColumnVo.setOracleType(crmColumn.oracleType());
                    crmColumnVo.setNote(crmColumn.note());
                    crmColumnVo.setDefaultValue(crmColumn.defaultValue());
                    crmColumnVo.setOrder(crmColumn.order());
                    crmColumnVos.add(crmColumnVo);
                    if (!field.isAnnotationPresent(TableId.class)) continue;
                    crmTableVo.setKey(crmColumnVo);
                }
                if (crmColumnVos.size() > 0) {
                    crmColumnVos = crmColumnVos.stream().sorted((x1, x2) -> x1.getOrder() - x2.getOrder()).collect(Collectors.toList());
                }
                crmTableVo.setCrmColumnVos(crmColumnVos);
            }
            crmTableVos.add(crmTableVo);
        }
        return crmTableVos;
    }
}

