/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;

public class ClassUtil {
    private static final Logger log = LoggerFactory.getLogger(ClassUtil.class);

    public static List<Class> getAllClassByInterface(Class c) {
        String packageName;
        List<Class<?>> allClass;
        ArrayList returnClassList = null;
        if (c.isInterface() && (allClass = ClassUtil.getClasses(packageName = c.getPackage().getName())) != null) {
            returnClassList = new ArrayList();
            for (Class<?> classes : allClass) {
                if (!c.isAssignableFrom(classes) || c.equals(classes)) continue;
                returnClassList.add(classes);
            }
        }
        return returnClassList;
    }

    public static String[] getPackageAllClassName(String classLocation, String packageName) {
        String[] packagePathSplit = packageName.split("[.]");
        String realClassLocation = classLocation;
        int packageLength = packagePathSplit.length;
        for (int i = 0; i < packageLength; ++i) {
            realClassLocation = realClassLocation + File.separator + packagePathSplit[i];
        }
        File packeageDir = new File(realClassLocation);
        if (packeageDir.isDirectory()) {
            String[] allClassName = packeageDir.list();
            return allClassName;
        }
        return null;
    }

    public static List<Class<?>> getClasses(String packageName) {
        Resource[] resources;
        String packageDirName = packageName.replace('.', '/');
        if (!packageName.endsWith("/")) {
            packageDirName = packageDirName + "/";
        }
        ArrayList list = new ArrayList();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (Resource res : resources = resolver.getResources("classpath*:" + packageDirName + "**/*.class")) {
            String clsName = new SimpleMetadataReaderFactory().getMetadataReader(res).getClassMetadata().getClassName();
            list.add(Class.forName(clsName));
        }
        return list;
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, List<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ClassUtil.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Class.forName(packageName + '.' + className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

