/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sqlupdate.provider;

import com.biz.crm.sqlupdate.CrmColumnVo;
import com.biz.crm.sqlupdate.CrmTableVo;
import com.biz.crm.sqlupdate.IndexVo;
import com.biz.crm.util.StringUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoUpdateOracleSqlProvider {
    private static final Logger log = LoggerFactory.getLogger(DoUpdateOracleSqlProvider.class);

    public String createTable(Map<String, Object> map) {
        CrmTableVo crmTableVo = (CrmTableVo)map.get("crmTableVo");
        log.info("\u65b0\u5efa\u8868==>" + crmTableVo.getName());
        StringBuffer sql = new StringBuffer();
        sql.append(" CREATE TABLE ").append(crmTableVo.getName());
        sql.append(" (");
        boolean flag = false;
        for (CrmColumnVo crmColumn : crmTableVo.getCrmColumnVos()) {
            if (flag) {
                sql.append(" ,");
            } else {
                flag = true;
            }
            sql.append(" ").append(crmColumn.getName()).append(" ");
            if (!crmColumn.getOracleType().equals("VARCHAR2")) {
                sql.append(crmColumn.getOracleType());
            } else {
                sql.append(crmColumn.getOracleType()).append(" (").append(crmColumn.getLength()).append(" )");
            }
            if (StringUtils.isNotEmpty((String)crmColumn.getDefaultValue())) {
                sql.append(" DEFAULT ").append(crmColumn.getDefaultValue()).append(" ");
            }
            if (crmColumn.isNullable()) continue;
            sql.append(" NOT NULL ");
        }
        sql.append(" )");
        return sql.toString();
    }

    public String updateTableNote(Map<String, Object> map) {
        CrmTableVo crmTableVo = (CrmTableVo)map.get("crmTableVo");
        log.info("\u66f4\u65b0\u8868\u6ce8\u91ca==>" + crmTableVo.getName() + ":" + crmTableVo.getTableNote());
        StringBuffer sql = new StringBuffer();
        sql.append("COMMENT ON TABLE ").append(crmTableVo.getName()).append(" IS '").append(crmTableVo.getTableNote()).append("'");
        return sql.toString();
    }

    public String commentTable(Map<String, Object> map) {
        CrmColumnVo crmColumnVo = (CrmColumnVo)map.get("crmColumnVo");
        String tableName = (String)map.get("tableName");
        log.info("\u65b0\u589e\u5217\u6ce8\u91ca==>" + tableName + ":" + crmColumnVo.getName() + ":" + crmColumnVo.getNote());
        StringBuffer sql = new StringBuffer();
        sql.append("COMMENT ON COLUMN ");
        sql.append(tableName);
        sql.append(".").append(crmColumnVo.getName()).append(" is").append(" '").append(crmColumnVo.getNote()).append(" '");
        return sql.toString();
    }

    public String updateIndex(Map<String, Object> map) {
        IndexVo indexVo = (IndexVo)map.get("indexVo");
        CrmTableVo crmTableVo = (CrmTableVo)map.get("crmTableVo");
        log.info("\u6dfb\u52a0\u7d22\u5f15==>" + crmTableVo.getTableNote() + ":" + crmTableVo.getName() + ":" + crmTableVo.getCrmColumnVos());
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE ");
        if (indexVo.isUnique()) {
            sql.append(" UNIQUE ");
        }
        sql.append(" INDEX ");
        sql.append(indexVo.getName());
        sql.append(" on ").append(crmTableVo.getName());
        sql.append(" (");
        sql.append(indexVo.getColumnList());
        sql.append(" ) ");
        return sql.toString();
    }

    public String addCols(Map<String, Object> map) {
        CrmColumnVo crmColumnVo = (CrmColumnVo)map.get("crmColumnVo");
        String tableName = (String)map.get("tableName");
        log.info("\u65b0\u589e\u5217==>" + tableName + ":" + crmColumnVo.getName());
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName).append(" ");
        sql.append(" ADD ( ");
        sql.append(crmColumnVo.getName()).append(" ");
        if (!crmColumnVo.getOracleType().equals("VARCHAR2")) {
            sql.append(crmColumnVo.getOracleType());
        } else {
            sql.append(crmColumnVo.getOracleType()).append(" (").append(crmColumnVo.getLength()).append(" )");
        }
        if (StringUtils.isNotEmpty((String)crmColumnVo.getDefaultValue())) {
            sql.append(" DEFAULT ").append(crmColumnVo.getDefaultValue()).append(" ");
        }
        if (!crmColumnVo.isNullable()) {
            sql.append(" NOT NULL ");
        }
        sql.append(" )");
        return sql.toString();
    }

    public String updatePrimaryKey(Map<String, Object> map) {
        CrmTableVo crmTableVo = (CrmTableVo)map.get("crmTableVo");
        log.info("\u66f4\u65b0\u4e3b\u952e==>" + crmTableVo.getName() + ":" + crmTableVo.getKey().getName());
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ").append(crmTableVo.getName());
        sql.append(" ADD CONSTRAINT ").append(crmTableVo.getName()).append("_PK").append(" PRIMARY KEY");
        sql.append(" ( ");
        sql.append(crmTableVo.getKey().getName());
        sql.append(" )");
        return sql.toString();
    }

    public String getAllTab(Map<String, Object> map) {
        String tableName = (String)map.get("tableName");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT COLUMN_NAME,DATA_TYPE  FROM user_tab_cols WHERE table_name =");
        sql.append(" '");
        sql.append(tableName);
        sql.append("'");
        return sql.toString();
    }

    public String getPrimaryKey(Map<String, Object> map) {
        String tableName = (String)map.get("tableName");
        StringBuffer sql = new StringBuffer();
        sql.append(" select CU.CONSTRAINT_NAME,CU.COLUMN_NAME,CU.TABLE_NAME from user_cons_columns cu, user_constraints au where cu.constraint_name = au.constraint_name and au.constraint_type =  ").append("'P").append("'").append(" and au.table_name ='").append(tableName).append("'");
        return sql.toString();
    }

    public String getAllIndex(Map<String, Object> map) {
        String tableName = (String)map.get("tableName");
        StringBuffer sql = new StringBuffer();
        sql.append("select T.INDEX_NAME,T.TABLE_NAME,T.COLUMN_NAME from user_ind_columns t,user_indexes i where t.index_name = i.index_name and t.table_name = i.table_name and t.table_name = ");
        sql.append("'").append(tableName);
        sql.append("'");
        return sql.toString();
    }

    public String getTableNote(Map<String, Object> map) {
        String tableName = (String)map.get("tableName");
        StringBuffer sql = new StringBuffer();
        sql.append("select TABLE_NAME,COMMENTS from user_tab_comments where TABLE_NAME=");
        sql.append("'");
        sql.append(tableName);
        sql.append("'");
        return sql.toString();
    }

    public String getColumnNote(Map<String, Object> map) {
        String tableName = (String)map.get("tableName");
        StringBuffer sql = new StringBuffer();
        sql.append("select TABLE_NAME,COLUMN_NAME,COMMENTS as note from user_col_comments where TABLE_NAME= ");
        sql.append("'");
        sql.append(tableName);
        sql.append("'");
        return sql.toString();
    }
}

