package com.biz.crm.order.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.service.OrderService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:37
 **/
@Api(value = "管理端-订单", tags = "管理端-订单")
@RestController
@RequestMapping("/m/order")
public class OrdermController {

    @Resource
    private OrderService orderService;

    @CrmLog
    @ApiOperation(value = "算价")
    @PostMapping(value = "cal")
    public Result<OrderVo> cal(@RequestBody OrderVo orderVo) {
        OrderVo reVo =  orderService.cal(orderVo,false);
        return Result.ok(reVo);
    }

    @CrmLog
    @ApiOperation(value = "算价(货补单)")
    @PostMapping(value = "cal/rebate")
    public Result<OrderVo> calForRebate(@RequestBody OrderVo orderVo) {
        OrderVo reVo =  orderService.calForRebate(orderVo);
        return Result.ok(reVo);
    }

    @CrmLog
    @ApiOperation(value = "算价(免费单)")
    @PostMapping(value = "cal/free")
    public Result<OrderVo> calForFree(@RequestBody OrderVo orderVo) {
        OrderVo reVo =  orderService.calForFree(orderVo);
        return Result.ok(reVo);
    }

    @CrmLog
    @ApiOperation(value = "暂存")
    @PostMapping(value = "/temporary/add")
    public Result temporaryAdd(@RequestBody OrderVo orderVo) {
        orderService.temporaryAdd(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "编辑订单")
    @PostMapping(value = "/edit")
    public Result edit(@RequestBody OrderVo orderVo) {
        orderService.edit(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "保存订单")
    @PostMapping(value = "/add")
    public Result add(@RequestBody OrderVo orderVo) {
        orderService.add(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "保存订单(货补单)")
    @PostMapping(value = "/add/rebate")
    public Result addForRebate(@RequestBody OrderVo orderVo) {
        orderService.addForRebate(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "保存订单(免费单)")
    @PostMapping(value = "/add/free")
    public Result addForFree(@RequestBody OrderVo orderVo) {
        orderService.addForFree(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "取消订单（退单）")
    @PostMapping(value = "cancelByIds")
    public Result cancelByIds(@RequestBody ArrayList<String> ids) {
        orderService.cancel(ids);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "根据id查询订单详情")
    @GetMapping(value = "findDetailsById/{id}")
    public Result<OrderVo> findDetailsById(@PathVariable(name = "id") String id) {
        OrderVo result = this.orderService.findDetailsById(id);
        return Result.ok(result);
    }

    @CrmLog
    @ApiOperation(value = "通过条件分页查询")
    @PostMapping(value = "listByConditions")
    public Result listByConditions(@RequestBody OrderVo orderVo) {
        return Result.ok(orderService.listByConditions(orderVo));
    }

    @ApiOperation(value = "根据id查询订单详情(不询价)")
    @GetMapping(value = "findSimpleDetailsById/{id}")
    public Result<OrderVo> findSimpleDetailsById(@PathVariable(name = "id") String id) {
        OrderVo result = this.orderService.findSimpleDetailsById(id);
        return Result.ok(result);
    }

    @ApiOperation(value = "汇总订单")
    @PostMapping(value = "collect")
    public Result<OrderVo> collect(@RequestBody OrderVo orderVo){
        OrderVo result = this.orderService.collect(orderVo);
        return Result.ok(result);
    }
}
