package com.biz.crm.order.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.OrderEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 16:40
 **/
public interface OrderMapper extends BaseMapper<OrderEntity> {

    /**
     * 列表
     * @param page
     * @param orderVo
     * @return
     */
    @SqlPrivilege(custCode = "cus_code",orgCode = "cus_org_code")
    List<OrderVo> pageList(Page<OrderVo> page, @Param("vo") OrderVo orderVo);

    List<OrderVo> list(Page<OrderVo> page, @Param("ew") QueryWrapper<OrderVo> queryWrapper);

    /**
     * 批量修改订单状态
     * @param state
     * @param ids
     */
    void updateStateByIds(@Param("state") String state, @Param("ids") List<String> ids);
}
