package com.biz.crm.order.service;

import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.order.OrderEntity;

import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/28 16:47
 **/
public interface OrderDetailPromotionService {

    /**
     * 批量替换订单促销
     * @param orderEntity
     * @param promotionVos
     */
    void rePlace(OrderEntity orderEntity, List<OrderDetailPromotionVo> promotionVos);

    /**
     * 根据订单编码查询所有促销
     * @param orderCode
     * @return
     */
    List<OrderDetailPromotionVo> findPromotionByOrderCode(String orderCode);

    /**
     * 根据订单删除订单下面的促销
     * @param orderCode
     */
    void delByOrderCode(String orderCode);
}
