package com.biz.crm.order.service;

import com.biz.crm.nebular.order.OrderFileVo;

import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/28 16:48
 **/
public interface OrderFileService {


    /**
     * 替换订单文件
     * @param orderCode
     * @param files
     */
    void replace(String orderCode, List<OrderFileVo> files);

  /**
   * 根据订单编码查询文件列表
   * @param orderCode
   * @return
   */
    List<OrderFileVo> findByOrderCode(String orderCode);

    /**
     * 根据订单号删除行
     * @param orderCode
     */
    void deleteByOrderCode(String orderCode);

    /**
     * 根据订单编码列表删除文件
     * @param orderCodes
     */
    void deleteByOrderCodes(List<String> orderCodes);
}
