package com.biz.crm.order.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.OrderEntity;

import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/28 16:48
 **/
public interface OrderService  extends IService<OrderEntity> {

    /**
     * 订单算价
     * @param orderVo
     * @param orderFalg 是否下订单
     * @return
     */
    OrderVo cal(OrderVo orderVo, boolean orderFalg);


    /**
     * 货补订单算价
     * @param orderVo
     * @return
     */
    OrderVo calForRebate(OrderVo orderVo);

    /**
     * 货补订单算价
     * @param orderVo
     * @return
     */
    OrderVo calForFree(OrderVo orderVo);

    /**
     * 订单暂存
     * @param orderVo
     */
    void temporaryAdd(OrderVo orderVo);

    /**
     * 订单暂存
     * @param orderVo
     */
    void edit(OrderVo orderVo);

    /**
     * 保存订单
     * @param orderVo
     */
    void add(OrderVo orderVo);

    /**
     * 保存订单(货补单)
     * @param orderVo
     */
    void addForRebate(OrderVo orderVo);

    /**
     * 保存订单（免费单）
     * @param orderVo
     */
    void addForFree(OrderVo orderVo);

    /**
     * 删除订单
     */
    void delByOrderCode(String orderCode);

    /**
     * 取消订单
     * @param ids
     */
    void cancel(List<String> ids);

    /**
     * 根据id批量修改订单状态
     * @param ids
     */
    void updateStateByIds(List<String> ids, OrderEunm.STATE state);

    /**
     * 根据订单id查询详情
     * @param id
     * @return
     */
    OrderVo findDetailsById(String id);

    /**
     * 根据条件进行分页查询
     * @param orderVo 查询条件
     * @return 查询结果
     */
    PageResult<OrderVo> listByConditions(OrderVo orderVo);

    /**
     * 批量删除暂存订单
     * @param ids
     */
    void deleteByIds(List<String> ids);


    /**
     * 根据编码查询详情
     * @param orderCode
     * @return
     */
    OrderVo findDetailByCode(String orderCode);

    /**
     * 根据id查询详情（不询价）
     * @param id
     * @return
     */
    OrderVo findSimpleDetailsById(String id);

    /**
     * 汇总订单信息
     * @param orderVo
     * @return
     */
    OrderVo collect(OrderVo orderVo);
}
