package com.biz.crm.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.order.OrderDetailPromotionEntity;
import com.biz.crm.order.OrderEntity;
import com.biz.crm.order.mapper.OrderDetailPromotionMapper;
import com.biz.crm.order.service.OrderDetailPromotionService;
import com.biz.crm.order.utils.OrderDetailPromotionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/28 16:48
 **/
@ConditionalOnMissingBean(name = "orderDetailPromotionServiceExpandImpl")
@Service(value = "orderDetailPromotionService")
public class OrderDetailPromotionServiceImpl <M extends BaseMapper<T>,T>
        extends ServiceImpl<OrderDetailPromotionMapper, OrderDetailPromotionEntity>
        implements OrderDetailPromotionService {

    @Autowired
    private OrderDetailPromotionMapper orderDetailPromotionMapper;

    /**
     * 1、删除
     * 2、转换模型
     * 3、保存
     * @param orderEntity
     * @param promotionVos
     */
    @Override
    public void rePlace(OrderEntity orderEntity, List<OrderDetailPromotionVo> promotionVos) {
        //1
        QueryWrapper<OrderDetailPromotionEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("order_code", orderEntity.getOrderCode());
        orderDetailPromotionMapper.delete(wrapper);

        //2
        List<OrderDetailPromotionEntity> entities = OrderDetailPromotionUtil.packageEntity(orderEntity,promotionVos);
        if(CollectionUtils.isEmpty(entities)){
            return;
        }

        //3
        this.saveBatch(entities);
    }

    /**
     * 1、查询
     * 2、转换并返回
     * @param orderCode
     * @return
     */
    @Override
    public List<OrderDetailPromotionVo> findPromotionByOrderCode(String orderCode) {
        //1
        QueryWrapper<OrderDetailPromotionEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("order_code", orderCode);
        List<OrderDetailPromotionEntity> entities = orderDetailPromotionMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(entities)){
            return new ArrayList<>();
        }

        //2
        return OrderDetailPromotionUtil.packageVo(entities);
    }

    @Override
    public void delByOrderCode(String orderCode) {
        QueryWrapper<OrderDetailPromotionEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("order_code", orderCode);
        orderDetailPromotionMapper.delete(wrapper);
    }
}
