package com.biz.crm.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.order.OrderFileVo;
import com.biz.crm.order.OrderFileEntity;
import com.biz.crm.order.mapper.OrderFileMapper;
import com.biz.crm.order.service.OrderFileService;
import com.biz.crm.order.utils.OrderFileUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/28 16:49
 **/
@ConditionalOnMissingBean(name = "orderFileServiceExpandImpl")
@Service(value = "orderFileService")
public class OrderFileServiceImpl <M extends BaseMapper<T>,T>
        extends ServiceImpl<OrderFileMapper, OrderFileEntity>
        implements OrderFileService {

    @Resource
    private OrderFileMapper orderFileMapper;

    /**
     * 1、删除原附件
     * 2、组装并保存新附件
     * @param orderCode
     * @param files
     */
    @Transactional
    @Override
    public void replace(String orderCode, List<OrderFileVo> files) {
        //1
        QueryWrapper<OrderFileEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("order_code", orderCode);
        orderFileMapper.delete(wrapper);

        //2
        List<OrderFileEntity> entities = OrderFileUtil.packageEntity(orderCode,files);
        this.saveBatch(entities);
    }

    /**
     * 根据订单编码查询文件列表
     * @param orderCode
     * @return
     */
    @Override
    public List<OrderFileVo> findByOrderCode(String orderCode) {
        if(StringUtils.isEmpty(orderCode)) {
            return Lists.newArrayList();
        }
        List<OrderFileEntity> entities = this.orderFileMapper.selectList(Wrappers.<OrderFileEntity>query().eq("order_code", orderCode));
        if(CollectionUtil.listEmpty(entities)) {
            return Lists.newArrayList();
        }
        return CrmBeanUtil.copyList(entities, OrderFileVo.class);
    }

    @Override
    @Transactional
    public void deleteByOrderCode(String orderCode) {
        QueryWrapper<OrderFileEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("order_code", orderCode);
        orderFileMapper.delete(wrapper);
    }

    /**
     * 根据订单编码列表删除文件
     * @param orderCodes
     */
    @Override
    @Transactional
    public void deleteByOrderCodes(List<String> orderCodes) {
        ValidateUtils.notEmpty(orderCodes, "批量删除订单文件时，订单编码列表不能为空");
        QueryWrapper<OrderFileEntity> wrapper = new QueryWrapper<>();
        wrapper.in("order_code", orderCodes);
        orderFileMapper.delete(wrapper);
    }
}
