package com.biz.crm.order.tools.handler;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.dms.minbuynumofproduct.MinbuynumofproductFeign;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.MinBuyNumOfProductEunm;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.nebular.dms.minbuynumofproduct.FindByCusCodeAndProductCodesToCusReq;
import com.biz.crm.nebular.dms.minbuynumofproduct.MinBuyNumOfProductVo;
import com.biz.crm.nebular.order.CalMinBuyNumDo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.util.Result;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * @Description: 处理订单中商品起订量问题
 * @Author: zhangyuzhu
 * @Date: 2021/3/17 11:35
 **/
@ConditionalOnMissingBean(name = "orderMinBuyNumHandlerExpand")
@Component("orderMinBuyNumHandler")
public class OrderMinBuyNumHandler {

    @Resource
    private MinbuynumofproductFeign minbuynumofproductFeign;

    /**
     * 处理
     * 1、汇总所有商品的数量
     * 2、处理
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @return
     */
    public OrderVo handle(OrderVo orderVo,String cusCode,String orgCode){
        //1
        Map<String,CalMinBuyNumDo> productNumMap = this.extractProductCodes(orderVo);

        //2
        Result<Map<String, MinBuyNumOfProductVo>> result = minbuynumofproductFeign.findByCusCodeAndProductCodesToCus(
                FindByCusCodeAndProductCodesToCusReq.newInstance(
                        cusCode,
                        orgCode,
                        new ArrayList<>(productNumMap.keySet())
                )
        );
        if(!result.isSuccess()){
            throw new BusinessException("订单起订量配置服务正在重启，请联系管理员");
        }
        Map<String, MinBuyNumOfProductVo> minBuyNumOfProductEntityMap = result.getResult();
        orderVo = this.validateMinBuyNum(orderVo,productNumMap,minBuyNumOfProductEntityMap);
        return orderVo;
    }


    /**
     * 验证最小起订量
     * //TODO 单位换算没做
     * @param orderVo
     */
    public OrderVo validateMinBuyNum(OrderVo orderVo, Map<String,CalMinBuyNumDo> productNumMap
            ,Map<String, MinBuyNumOfProductVo> minBuyNumOfProductEntityMap){
        for(Map.Entry<String,CalMinBuyNumDo> entry : productNumMap.entrySet()){
            CalMinBuyNumDo calMinBuyNumDo = entry.getValue();
            MinBuyNumOfProductVo minBuyNumOfProductVo = null;
            Object obj = minBuyNumOfProductEntityMap.get(entry.getKey());
            if(null != obj){
                minBuyNumOfProductVo = JSON.parseObject(JSON.toJSONString(obj),MinBuyNumOfProductVo.class);
            }
            //如果某个产品没有设置起订量,就默认为可以购买任意量,反之验证起订量
            if(null != minBuyNumOfProductVo){

                //计算实际购买量
                Integer buyNum = calMinBuyNumDo.getNum();
                if(MinBuyNumOfProductEunm.verificationModeEunm.NORMALANDGIFT.getCode().equals(minBuyNumOfProductVo.getVerificationMode())){
                    buyNum = buyNum.intValue() + calMinBuyNumDo.getGiftNum().intValue();
                }
                if(new BigDecimal(buyNum).compareTo(minBuyNumOfProductVo.getMinOrderQuantity()) < 0){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
                    StringBuilder stb = new StringBuilder("提示：商品【")
                            .append(calMinBuyNumDo.getProductName())
                            .append("】不满足起订量")
                            .append(",起订量为:")
                            .append(minBuyNumOfProductVo.getMinOrderQuantity())
                            .append(minBuyNumOfProductVo.getUnitName());
                    orderVo.setCalSucessMsg(stb.toString());
                }
            }
        }
        return orderVo;
    }


    /**
     * 提取所有的产品编码以及汇总数量
     * @param orderVo
     * @return
     */
    public Map<String,CalMinBuyNumDo> extractProductCodes(OrderVo orderVo){
        Map<String, CalMinBuyNumDo> reMap = new HashMap<>();
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
//            if(!CollectionUtils.isEmpty(groupItemVo.getBackList())){
//                for(OrderDetailVo item : groupItemVo.getBackList()){
//                    CalMinBuyNumDo calMinBuyNumDo = reMap.get(item.getProductCode());
//                    if(calMinBuyNumDo == null){
//                        reMap.put(item.getProductCode(),CalMinBuyNumDo.newInstance(item.getProductNum().intValue(),0,item.getProductName(),item.getProductCode()));
//                    }else {
//                        calMinBuyNumDo.setNum(calMinBuyNumDo.getNum().intValue() + item.getProductNum().intValue());
//                    }
//                }
//            }
            //TODO 不校验赠品起订量
            if(!CollectionUtils.isEmpty(groupItemVo.getGiftList())){
                for(OrderDetailVo item : groupItemVo.getGiftList()){
                    CalMinBuyNumDo calMinBuyNumDo = reMap.get(item.getProductCode());
                    if(calMinBuyNumDo == null){
                        reMap.put(item.getProductCode(),CalMinBuyNumDo.newInstance(0,item.getProductNum().intValue(),item.getProductName(),item.getProductCode()));
                    }else {
                        calMinBuyNumDo.setGiftNum(calMinBuyNumDo.getGiftNum().intValue() + item.getProductNum().intValue());
                    }
                }
            }
            if(!CollectionUtils.isEmpty(groupItemVo.getNormalList())){
                for(OrderDetailVo item : groupItemVo.getNormalList()){
                    CalMinBuyNumDo calMinBuyNumDo = reMap.get(item.getProductCode());
                    if(calMinBuyNumDo == null){
                        reMap.put(item.getProductCode(),CalMinBuyNumDo.newInstance(item.getProductNum().intValue(),0,item.getProductName(),item.getProductCode()));
                    }else {
                        calMinBuyNumDo.setNum(calMinBuyNumDo.getNum().intValue() + item.getProductNum().intValue());
                    }
                }
            }
        }
        return reMap;
    }
}
