package com.biz.crm.order.tools.handler;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.excutor.CalPromotionExcutor;
import com.biz.crm.order.tools.strategy.calpromotion.impl.BuyAndGiftCalPromotionStrategy;
import com.biz.crm.order.tools.strategy.calpromotion.impl.DiscountCalPromotionStrategy;
import com.biz.crm.order.tools.strategy.calpromotion.impl.FullReductionCalPromotionStrategy;
import com.biz.crm.order.tools.strategy.calpromotion.impl.SpecialOfferCalPromotionStrategy;
import com.biz.crm.order.utils.OrderUtil;
import com.biz.crm.util.DictUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description: 处理订单中促销算价问题
 * @Author: zhangyuzhu
 * @Date: 2021/3/17 11:35
 **/
@ConditionalOnMissingBean(name = "orderPromotionHandlerExpand")
@Component("orderPromotionHandler")
public class OrderPromotionHandler {

    @Resource
    private BuyAndGiftCalPromotionStrategy buyAndGiftCalPromotionStrategy;

    @Resource
    private DiscountCalPromotionStrategy discountCalPromotionStrategy;

    @Resource
    private FullReductionCalPromotionStrategy fullReductionCalPromotionStrategy;

    @Resource
    private SpecialOfferCalPromotionStrategy specialOfferCalPromotionStrategy;

    /**
     * 处理
     * 1、验证促销
     * 2、查询促销计算排序
     * 3、按照排序计算促销
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @return
     */
    public OrderVo handle(OrderVo orderVo,String cusCode,String orgCode, Object... objects){
        //1
        orderVo = validateParam(orderVo);
        if(!OrderUtil.judegeOrder(orderVo)){
            return orderVo;
        }

        //2
        List<DictDataVo> list = DictUtil.list(OrderUtil.CAL_PROMOTION_SORT_CODE);
        if(CollectionUtils.isEmpty(list)){
            throw new BusinessException("促销配置缺失，请联系管理员");
        }
        List<DictDataVo> newList = list.stream().sorted(Comparator.comparing(DictDataVo::getDictSort))
                .collect(Collectors.toList());

        //3
        int calNum = 1;
        for(DictDataVo dictDataVo : newList){
            if(dictDataVo.getDictCode().equals(PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())){
                orderVo = CalPromotionExcutor.cal(buyAndGiftCalPromotionStrategy,orderVo,cusCode,orgCode,calNum,objects);
                if(!OrderUtil.judegeOrder(orderVo)){
                    return orderVo;
                }
                continue;
            }
            if(dictDataVo.getDictCode().equals(PromotionPolicyEunm.PromotionTypeEunm.FULLREDUCTION.getCode())){
                orderVo = CalPromotionExcutor.cal(fullReductionCalPromotionStrategy,orderVo,cusCode,orgCode,calNum,objects);
                if(!OrderUtil.judegeOrder(orderVo)){
                    return orderVo;
                }
                continue;
            }
            if(dictDataVo.getDictCode().equals(PromotionPolicyEunm.PromotionTypeEunm.DISCOUNT.getCode())){
                orderVo = CalPromotionExcutor.cal(discountCalPromotionStrategy,orderVo,cusCode,orgCode,calNum,objects);
                if(!OrderUtil.judegeOrder(orderVo)){
                    return orderVo;
                }
                continue;
            }
            if(dictDataVo.getDictCode().equals(PromotionPolicyEunm.PromotionTypeEunm.SPECIALPRICE.getCode())){
                orderVo = CalPromotionExcutor.cal(specialOfferCalPromotionStrategy,orderVo,cusCode,orgCode,calNum,objects);
                if(!OrderUtil.judegeOrder(orderVo)){
                    return orderVo;
                }
                continue;
            }
            calNum ++;
        }
        return orderVo;
    }

    /**
     * 1、验证每一行的促销类型不能重复
     * 2、验证一个订单中买赠促销不能重复
     * @param orderVo
     */
    public static OrderVo validateParam(OrderVo orderVo){
        Map<String,Object> promotionMap = new HashMap<>();
        for(OrderGroupItemVo group : orderVo.getGroupItemVos()){
            if(CollectionUtils.isEmpty(group.getNormalList())){
                continue;
            }
            if(group.getBuyAndGiveFlag().equals(YesNoEnum.yesNoEnum.YES)){
                if(promotionMap.get(group.getPromotionCode()) != null){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GROUP.getCode());
                    group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("提示：错误订单，买赠促销重复");
                    group.setCalSucessMsg(stb.toString());
                    return orderVo;
                }
            }
            for(OrderDetailVo detail : group.getNormalList()){
                if(CollectionUtils.isEmpty(detail.getPromotionVos())){
                    continue;
                }
                Map<String,Object> map = new HashMap<>();
                for(OrderDetailPromotionVo promotionVo : detail.getPromotionVos()){
                    if(map.get(promotionVo.getPromotionCode()) != null){
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        detail.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb = new StringBuilder("提示：行上促销类型重复");
                        detail.setCalSucessMsg(stb.toString());
                        return orderVo;
                    }
                }
            }
        }
        return orderVo;
    }


}
