package com.biz.crm.order.tools.strategy.calpromotion.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.dms.promotion.PromotionV2Feign;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.strategy.calpromotion.CalPromotionStrategy;
import com.biz.crm.order.utils.OrderUtil;
import com.biz.crm.util.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/5/8 11:20
 **/
@ConditionalOnMissingBean(name = "discountCalPromotionStrategyExpand")
@Component("discountCalPromotionStrategy")
public class DiscountCalPromotionStrategy implements CalPromotionStrategy {

    @Autowired
    private PromotionV2Feign promotionV2Feign;

    /**
     * 1、找出所有的打折促销，并且组装促销参数
     * 2、查询所有的促销
     * 3、挨个计算促销
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @param objects
     * @return
     */
    @Override
    public OrderVo cal(OrderVo orderVo, String cusCode, String orgCode,Integer calNum, Object... objects) {
        //1
        ArrayList<PromotionQueryReq> param = packageParam(orderVo,cusCode,orgCode,objects);
        if(CollectionUtils.isEmpty(param)){
            return orderVo;
        }

        //2
        Result<Map<String, PromotionEditVo>> result = promotionV2Feign.findHitPromotionMapByPromotionCodes(param);
        if(!result.isSuccess()){
            throw new BusinessException("促销服务正在重启，请联系管理员");
        }
        Map<String,PromotionEditVo> promotionMap = result.getResult();

        //3
        return cal(orderVo,promotionMap,calNum);
    }

    /**
     * 计算
     * @param orderVo
     * @param promotionMap
     * @return
     */
    public static OrderVo cal(OrderVo orderVo, Map<String,PromotionEditVo> promotionMap,Integer calNum){
        for(OrderGroupItemVo group : orderVo.getGroupItemVos()){
            calPrice(orderVo,group,promotionMap,calNum);
            if(!OrderUtil.judegeOrder(orderVo)){
                return orderVo;
            }
        }
        return orderVo;
    }


    /**
     * 计算促销
     * 1、验证促销是否存在
     * 2、验证促销是否是行上可重复
     * 3、验证促销匹配阶梯是否报错
     * 4、设置促销信息
     * 5、计算促销价值
     * @param group
     * @param promotionMap
     */
    public static void calPrice(OrderVo orderVo,OrderGroupItemVo group,Map<String,PromotionEditVo> promotionMap,Integer calNum){
        //1
        BigDecimal promotionAmount = BigDecimal.ZERO;
        for(OrderDetailVo detail : group.getNormalList()){
            if(CollectionUtils.isEmpty(detail.getPromotionVos())){
                continue;
            }
            for(OrderDetailPromotionVo promotion : detail.getPromotionVos()){
                if(!promotion.getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.DISCOUNT.getCode())){
                    continue;
                }
                //1
                PromotionEditVo promotionEditVo = promotionMap.get(promotion.getPromotionCode());
                if(null == promotionEditVo){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.PROMOTION.getCode());
                    zPromotionExsitError(group,promotion.getPromotionCode());
                    return ;
                }

                //2
                if(judegeNum(group,promotionEditVo.getPromotionPolicyCode(),promotionEditVo)){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    return;
                }

                //3
                if(!promotionEditVo.isMatchState()){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.PROMOTION.getCode());
                    zPromotionError(group,promotionEditVo);
                    return;
                }

                //4
                promotion.setPromotionName(promotionEditVo.getPromotionPolicyName());
                promotion.setPromotionType(promotionEditVo.getPromotionType());
                promotion.setPromotionPolicyId(promotionEditVo.getId());
                promotion.setSortNum(calNum);
                StringBuilder promotionMsg = new StringBuilder();
                BigDecimal oldAmount = detail.getAmount();
                detail.setAmount(detail.getAmount()
                        .multiply(promotionEditVo.getCalculateHitResultVo().getValue()).setScale(6,BigDecimal.ROUND_HALF_UP));
                promotionAmount = promotionAmount.add(
                        oldAmount
                                .subtract(detail.getAmount()).setScale(6,BigDecimal.ROUND_HALF_UP)
                );
                promotionMsg.append("原总价【").append(oldAmount).append("】")
                        .append("* 折扣【").append(promotionEditVo.getCalculateHitResultVo().getValue()).append("】四舍五入后 =")
                        .append(detail.getAmount());
                promotion.setPromotionDes(promotionMsg.toString());
                promotion.setPromotionAmount(oldAmount.subtract(detail.getAmount()));
            }
        }

        //5
        if(group.getPromotionAmount() == null){
            group.setPromotionAmount(BigDecimal.ZERO);
        }
        group.setPromotionAmount(group.getPromotionAmount().add(promotionAmount));
    }

    /**
     * 将块中对应的促销设置为错误
     * @param group
     * @param promotionEditVo
     */
    public static void zPromotionError(OrderGroupItemVo group, PromotionEditVo promotionEditVo){
        if(CollectionUtils.isEmpty(group.getNormalList())){
            return;
        }
        for(OrderDetailVo detail : group.getNormalList()){
            if(CollectionUtils.isEmpty(detail.getPromotionVos())){
                continue;
            }
            for(OrderDetailPromotionVo promotionVo : detail.getPromotionVos()){
                if(promotionEditVo.getPromotionPolicyCode().equals(promotionVo.getPromotionCode())){
                    promotionVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("提示：促销【")
                            .append(group.getPromotionName())
                            .append("】 ")
                            .append(promotionEditVo.getMatchMsg());
                    promotionVo.setCalSucessMsg(stb.toString());
                }
            }
        }

    }

    /**
     * 将块中对应的促销设置为错误
     * @param group
     * @param promotionCode
     */
    public static void zPromotionExsitError(OrderGroupItemVo group, String promotionCode){
        if(CollectionUtils.isEmpty(group.getNormalList())){
            return;
        }
        for(OrderDetailVo detail : group.getNormalList()){
            if(CollectionUtils.isEmpty(detail.getPromotionVos())){
                continue;
            }
            for(OrderDetailPromotionVo promotionVo : detail.getPromotionVos()){
                if(promotionCode.equals(promotionVo.getPromotionCode())){
                    promotionVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("提示：促销【")
                            .append(group.getPromotionName())
                            .append("】不存在或已过期");
                    promotionVo.setCalSucessMsg(stb.toString());
                }
            }
        }

    }

    /**
     * 验证块中促销是否叠加
     * @param group
     * @param promotionCode
     * @return
     */
    public static boolean judegeNum(OrderGroupItemVo group, String promotionCode,PromotionEditVo promotionEditVo){
        if(promotionEditVo.getMultipleable().equals(YesNoEnum.yesNoEnum.YES.getValue())){
            return false;
        }
        if(CollectionUtils.isEmpty(group.getNormalList())){
            return false;
        }
        for(OrderDetailVo detail : group.getNormalList()){
            if(CollectionUtils.isEmpty(detail.getPromotionVos()) || detail.getPromotionVos().size() == 1){
                continue;
            }
            for(OrderDetailPromotionVo promotionVo : detail.getPromotionVos()){
                if(promotionCode.equals(promotionVo.getPromotionCode())){
                    detail.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("提示：促销【")
                            .append(group.getPromotionName())
                            .append("】不能叠加");
                    detail.setCalSucessMsg(stb.toString());
                    return true;
                }
            }
        }
        return false;
    }


    /**
     * 组装查询促销的参数
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @param objects
     */
    public static ArrayList<PromotionQueryReq> packageParam(OrderVo orderVo, String cusCode, String orgCode, Object... objects){
        Map<String,PromotionQueryReq> promotionMap = new HashMap<>();
        for(OrderGroupItemVo group : orderVo.getGroupItemVos()){
            for(OrderDetailVo detail : group.getNormalList()){
                if(CollectionUtils.isEmpty(detail.getPromotionVos())){
                    continue;
                }
                for(OrderDetailPromotionVo promotion : detail.getPromotionVos()){
                    if(!promotion.getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.DISCOUNT.getCode())){
                        continue;
                    }
                    PromotionQueryReq req = promotionMap.get(promotion.getPromotionCode());
                    if(promotion.getCombinationFlag().equals(YesNoEnum.yesNoEnum.YES)
                        && req != null){
                        PromotionSaleProductVo product = new PromotionSaleProductVo();
                        product.setProductCode(detail.getProductCode());
                        product.setBuyCount(detail.getProductNum());
                        product.setBuyAmount(detail.getAmount());
                        product.setPrice(detail.getPrice());
                        req.getSaleProductVos().add(product);
                        continue;
                    }
                    req = new PromotionQueryReq();
                    req.setAccountCode(cusCode);
                    req.setAccountType("customer");
                    List<String> promotionCodes = new ArrayList<>();
                    promotionCodes.add(promotion.getPromotionCode());
                    req.setPromotionCodes(promotionCodes);
                    List<PromotionSaleProductVo> saleProductVos = new ArrayList<>();
                    PromotionSaleProductVo product = new PromotionSaleProductVo();
                    product.setProductCode(detail.getProductCode());
                    product.setBuyCount(detail.getProductNum());
                    product.setBuyAmount(detail.getAmount());
                    product.setPrice(detail.getPrice());
                    saleProductVos.add(product);
                    req.setSaleProductVos(saleProductVos);
                    promotionMap.put(promotion.getPromotionCode(),req);
                }
            }
        }
        return new ArrayList<>(promotionMap.values());
    }
}
