package com.biz.crm.order.tools.strategy.validaterebate.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.dms.orderfeerate.OrderFeeRateFeign;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepProductVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToResVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAmountQueryReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.strategy.validaterebate.ValidateRebateFeeStrategy;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: 标准订单验证策略
 * @Author: zhangyuzhu
 * @Date: 2021/3/16 19:20
 **/
@ConditionalOnMissingBean(name = "standerdOrderValidateFeeStategyExpand")
@Component("standerdOrderValidateFeeStategy")
public class StanderdOrderValidateFeeStategy implements ValidateRebateFeeStrategy {

    @Autowired
    private FeePoolFeign feePoolFeign;

    @Resource
    private OrderFeeRateFeign orderFeeRateFeign;

    /**
     * 1、从订单费用使用比例验证
     * 2、从费用余额验证
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @param objects
     * @return
     */
    @Override
    public OrderVo validate(OrderVo orderVo, String cusCode, String orgCode, Object... objects) {
        //1
        BigDecimal normalAndGiftTotalAmount = this.calNormalAndGiftTotalAmount(orderVo);
        orderVo = this.calRep(orderVo,cusCode,orgCode,normalAndGiftTotalAmount);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            return orderVo;
        }

        //2
        FeePoolAmountQueryReqVo feePoolAmountQueryReqVo = this.packageFeeParam(orderVo,cusCode);
        Result<FeePoolAmountQueryRespVo> result =feePoolFeign.queryPoolAmount(feePoolAmountQueryReqVo);
        if(!result.isSuccess()){
            throw new BusinessException("费用服务正在重启，请联系管理员");
        }
        FeePoolAmountQueryRespVo feePoolAmountQueryRespVo = result.getResult();
        orderVo = this.calRapFromFee(orderVo,feePoolAmountQueryRespVo.getPoolUsableAmountMap());
        return orderVo;
    }


    /**
     * 组装费用查询参数
     * @param orderVo
     * @param cusCode
     * @return
     */
    public FeePoolAmountQueryReqVo packageFeeParam(OrderVo orderVo,String cusCode){
        FeePoolAmountQueryReqVo vo = new FeePoolAmountQueryReqVo();
        vo.setCustomerCode(cusCode);
        List<String> poolCodeList = new ArrayList<>();
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(groupItemVo.getBackList())){
                for(OrderDetailVo itemVo : groupItemVo.getBackList()){
                    if(itemVo.getAmount().intValue() == 0){
                        continue;
                    }
                    poolCodeList.add(itemVo.getFeeCode());
                }
            }
        }
        vo.setPoolCodeList(poolCodeList);
        return vo;
    }


    /**
     * 从费用池验证费用是否足够
     * 1、统计每个费用用了多少钱
     * 2、循环对比
     * @param orderVo
     * @param poolMap
     * @return
     */
    public OrderVo calRapFromFee(OrderVo orderVo,Map<String, BigDecimal> poolMap){
        Map<String,BigDecimal> totalFeeMap = totalFee(orderVo);
        for(Map.Entry<String,BigDecimal> entry : totalFeeMap.entrySet()){
            String key = entry.getKey();
            String[] keys = key.split(",");
            String feeCode = keys[0];
            String feeName = keys[1];
            BigDecimal useFee = entry.getValue();
            BigDecimal ableFee = poolMap.get(feeCode);
            if(null == ableFee){
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                StringBuilder stb = new StringBuilder("提示：本单费用【")
                        .append(feeName)
                        .append("】对应的费用余额为0,请重新选择");
                orderVo.setCalSucessMsg(stb.toString());
                continue;
            }
            if(useFee.compareTo(ableFee) > 0){
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                StringBuilder stb = new StringBuilder("提示：本单费用费用【")
                        .append(feeName)
                        .append("】使用了【")
                        .append(useFee)
                        .append("】,剩余费用【")
                        .append(ableFee)
                        .append("】元,已经超出！");
                orderVo.setCalSucessMsg(stb.toString());
            }
            //设置费用提示
            setProcess(orderVo,feeCode,feeName,useFee,ableFee);
        }
        return orderVo;
    }

    /**
     * 设置计算过程
     * @param orderVo
     * @param feeCode
     * @param feeName
     * @param useFee
     * @param ableFee
     */
    public static void setProcess(OrderVo orderVo,String feeCode,String feeName,BigDecimal useFee,BigDecimal ableFee){
        StringBuilder des = new StringBuilder("货补费用【")
                .append(feeName)
                .append("】，可使用【")
                .append(ableFee)
                .append("】,已使用")
                .append(useFee);
        for(OrderGroupItemVo group : orderVo.getGroupItemVos()){
            if(CollectionUtils.isEmpty(group.getBackList())){
                continue;
            }
            for(OrderDetailVo detail : group.getBackList()){
                if(!detail.getFeeCode().equals(feeCode)){
                    continue;
                }
                detail.setBackCalDes(new StringBuilder(StringUtils.isEmpty(detail.getBackCalDes())?"":detail.getBackCalDes()).append(";").append(des).toString());
            }
        }
    }

    /**
     * 按照费用统计使用金额
     * 如果使用金额为0则不统计
     * @param orderVo
     * @return
     */
    public static Map<String,BigDecimal> totalFee(OrderVo orderVo){
        Map<String,BigDecimal> reMap = new HashMap<>();
        for(OrderGroupItemVo group : orderVo.getGroupItemVos()){
            if(CollectionUtils.isEmpty(group.getBackList())){
               continue;
            }
            for(OrderDetailVo detail : group.getBackList()){
                if(detail.getAmount().intValue() == 0){
                    continue;
                }
                String key = new StringBuilder(detail.getFeeCode()).append(",").append(detail.getFeeName()).toString();
                if(reMap.get(key) == null){
                    reMap.put(key,detail.getAmount());
                    continue;
                }
                reMap.put(key,reMap.get(key).add(detail.getAmount()));
            }
        }
        return reMap;
    }


    /**
     * 计算货补限定量(多余的提示)
     * @return
     */
    public OrderVo calRep(OrderVo orderVo,String cusCode,String orgCode,BigDecimal normalAndGiftTotalAmount){
        OrderFeeRateCalToRepVo orderFeeRateCalToRepVo = this.packageOrderFeeRepParam( orderVo, cusCode, orgCode, normalAndGiftTotalAmount);
        if(null == orderFeeRateCalToRepVo){
            return orderVo;
        }
        Result<Map<String, OrderFeeRateCalToResVo>> result = orderFeeRateFeign.calToRepForObj(orderFeeRateCalToRepVo);
        if(!result.isSuccess()){
            throw new BusinessException("订单费用配置服务正在重启，请联系管理员");
        }
        Map<String,OrderFeeRateCalToResVo> feeMap = result.getResult();
        Map<String,BigDecimal> useFeeMap = this.totalUseFee(orderVo);
        for(Map.Entry<String,BigDecimal> entry : useFeeMap.entrySet()){
            String key = entry.getKey();
            String[] keys = key.split(",");
            String productCode = keys[0];
            String productName = keys[1];
            OrderFeeRateCalToResVo orderFeeRateCalToResVo = feeMap.get(productCode);
            //设置计算过程
            if(null == orderFeeRateCalToResVo){
                continue;
            }
            setProcess(orderVo,productCode,productName,entry.getValue(),orderFeeRateCalToResVo);
            BigDecimal maxFee = orderFeeRateCalToResVo.getMaxMoney();
            if(maxFee.compareTo(entry.getValue()) < 0){
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
                StringBuilder stb = new StringBuilder("提示：货补商品【")
                        .append(productName)
                        .append("】已超过最大限额【")
                        .append(maxFee)
                        .append("元】,请调整数量或者加大商品购买量！");
                orderVo.setCalSucessMsg(stb.toString());
            }
        }
        return orderVo;
    }

    /**
     * 设置货补商品比例使用限制
     * @param orderVo
     * @param productCode
     * @param orderFeeRateCalToResVo
     */
    public static void setProcess(OrderVo orderVo,String productCode,String productName,BigDecimal money,OrderFeeRateCalToResVo orderFeeRateCalToResVo){
        StringBuilder des = new StringBuilder("本单货补商品【")
                .append(productName)
                .append("】，最大使用额为【")
                .append(orderFeeRateCalToResVo.getMaxMoney())
                .append("】");

        if(null == orderFeeRateCalToResVo){
            des.append(",无比例限制");
        }else {
            des.append(",计算过程:本单非货补商品额度【")
                    .append(orderFeeRateCalToResVo.getCalMoney())
                    .append("】 * 本单限制比例【")
                    .append(orderFeeRateCalToResVo.getRate())
                    .append("%】");
        }
        for(OrderGroupItemVo group : orderVo.getGroupItemVos()){
            if(CollectionUtils.isEmpty(group.getBackList())){
                continue;
            }
            for(OrderDetailVo detail : group.getBackList()){
                if(!detail.getProductCode().equals(productCode)){
                    continue;
                }
                detail.setBackCalDes(des.toString());
            }
        }
    }


    /**
     * 统计货补使用金额
     * @param orderVo
     * @return
     */
    public Map<String,BigDecimal> totalUseFee(OrderVo orderVo){
        Map<String,BigDecimal> useFeeMap = new HashMap<>();
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(CollectionUtils.isEmpty(groupItemVo.getBackList())){
                continue;
            }
            for(OrderDetailVo itemVo : groupItemVo.getBackList()){
                BigDecimal useFee = useFeeMap.get(splicingProductCodeAndName(itemVo.getProductCode(),itemVo.getProductName())) == null
                        ? BigDecimal.ZERO:useFeeMap.get(splicingProductCodeAndName(itemVo.getProductCode(),itemVo.getProductName()));
                useFeeMap.put(splicingProductCodeAndName(itemVo.getProductCode(),itemVo.getProductName()),
                        useFee.add(itemVo.getAmount()));
            }
        }
        return useFeeMap;
    }

    /**
     * 拼接产品编码和名称，中间用英文半角逗号隔开
     * @param productCode
     * @param productName
     * @return
     */
    public static String splicingProductCodeAndName(String productCode,String productName){
        return new StringBuilder(productCode).append(",").append(productName).toString();
    }


    /**
     * 组装费用限制比例查询条件
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @param normalAndGiftTotalAmount
     * @return
     */
    public OrderFeeRateCalToRepVo packageOrderFeeRepParam(OrderVo orderVo,String cusCode,String orgCode,BigDecimal normalAndGiftTotalAmount){
        OrderFeeRateCalToRepVo orderFeeRateCalToRepVo = new OrderFeeRateCalToRepVo();
        orderFeeRateCalToRepVo.setCusCode(cusCode);
        orderFeeRateCalToRepVo.setOrgCode(orgCode);
        orderFeeRateCalToRepVo.setOrderMoney(normalAndGiftTotalAmount);
        List<OrderFeeRateCalToRepProductVo> products = new ArrayList<>();
        orderFeeRateCalToRepVo.setProducts(products);
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(CollectionUtils.isEmpty(groupItemVo.getBackList())){
                continue;
            }
            for(OrderDetailVo itemVo : groupItemVo.getBackList()){
                OrderFeeRateCalToRepProductVo orderFeeRateCalToRepProductVo = new OrderFeeRateCalToRepProductVo();
                orderFeeRateCalToRepProductVo.setProductCode(itemVo.getProductCode());
                orderFeeRateCalToRepProductVo.setProductLevelCode(itemVo.getProductLevelCode());
                products.add(orderFeeRateCalToRepProductVo);
            }
        }
        if(CollectionUtils.isEmpty(products)){
            return null;
        }
        return orderFeeRateCalToRepVo;
    }


    /**
     * 计算订单本品+赠品总金额
     * @param orderVo
     * @return
     */
    public BigDecimal calNormalAndGiftTotalAmount(OrderVo orderVo){
        BigDecimal reNum = BigDecimal.ZERO;
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(groupItemVo.getNormalList())){
                for(OrderDetailVo item : groupItemVo.getNormalList()){
                    reNum = reNum.add(item.getAmount());
                }
            }
            if(!CollectionUtils.isEmpty(groupItemVo.getGiftList())){
                for(OrderDetailVo item : groupItemVo.getGiftList()){
                    reNum = reNum.add(item.getAmount());
                }
            }
        }
        return reNum;
    }
}
