/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.strategy.calorder.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.dms.orderfeerate.OrderFeeRateFeign;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToCashResVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToCashVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAmountQueryReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.strategy.calorder.CalOrderStrategy;
import com.biz.crm.util.Result;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"standerdCalOrderStrategyExpand"})
@Component(value="standerdCalOrderStrategy")
public class StanderdCalOrderStrategy
implements CalOrderStrategy {
    @Autowired
    private FeePoolFeign feePoolFeign;
    @Resource
    private OrderFeeRateFeign orderFeeRateFeign;

    @Override
    public OrderVo cal(OrderVo orderVo, String cusCode, String orgCode, Object ... objects) {
        StringBuilder maxDiscountAmountDes = new StringBuilder();
        FeePoolAmountQueryReqVo feePoolAmountQueryReqVo = this.packageFeeParam(orderVo, cusCode);
        Result result = this.feePoolFeign.queryPoolAmount(feePoolAmountQueryReqVo);
        if (!result.isSuccess()) {
            throw new BusinessException("\u8d39\u7528\u670d\u52a1\u6b63\u5728\u91cd\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        FeePoolAmountQueryRespVo feePoolAmountQueryRespVo = (FeePoolAmountQueryRespVo)result.getResult();
        BigDecimal normalAndGiftTotalAmount = this.calNormalAndGiftTotalAmount(orderVo);
        OrderFeeRateCalToCashResVo orderFeeRateCalToCashResVo = this.calCashFee(cusCode, orgCode, normalAndGiftTotalAmount);
        BigDecimal maxCashFee = BigDecimal.ZERO;
        BigDecimal ablecashFee = feePoolAmountQueryRespVo.getDiscountUsableAmount() == null ? BigDecimal.ZERO : feePoolAmountQueryRespVo.getDiscountUsableAmount();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal promotionAmount = BigDecimal.ZERO;
        BigDecimal giftAmount = BigDecimal.ZERO;
        BigDecimal maxDiscountAmount = BigDecimal.ZERO;
        BigDecimal discountAmount = null == orderVo.getDiscountAmount() ? BigDecimal.ZERO : orderVo.getDiscountAmount();
        BigDecimal repAmount = BigDecimal.ZERO;
        BigDecimal actualAmount = BigDecimal.ZERO;
        for (OrderGroupItemVo orderGroupItemVo : orderVo.getGroupItemVos()) {
            promotionAmount = promotionAmount.add(orderGroupItemVo.getPromotionAmount());
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getBackList())) {
                for (OrderDetailVo item : orderGroupItemVo.getBackList()) {
                    repAmount = repAmount.add(item.getAmount());
                    amount = amount.add(item.getAmount());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getGiftList())) {
                for (OrderDetailVo item : orderGroupItemVo.getGiftList()) {
                    amount = amount.add(item.getAmount());
                    giftAmount = giftAmount.add(item.getAmount());
                }
            }
            if (CollectionUtils.isEmpty((Collection)orderGroupItemVo.getNormalList())) continue;
            for (OrderDetailVo item : orderGroupItemVo.getNormalList()) {
                amount = amount.add(item.getAmount());
            }
        }
        amount = amount.add(promotionAmount).subtract(giftAmount);
        actualAmount = amount.subtract(promotionAmount).subtract(repAmount);
        if (orderFeeRateCalToCashResVo == null) {
            maxDiscountAmountDes.append("\u672c\u5355\u65e0\u8d39\u7528\u6c60\u9650\u5b9a\u6bd4\u4f8b");
            maxCashFee = actualAmount;
        } else {
            maxCashFee = orderFeeRateCalToCashResVo.getMaxMoney();
            maxDiscountAmountDes.append("\u672c\u5355\u6700\u5927\u53ef\u4f7f\u7528\u73b0\u91d1\u8d39\u7528\u4e3a\u3010").append(orderFeeRateCalToCashResVo.getMaxMoney()).append("\u3011,\u8ba1\u7b97\u8fc7\u7a0b\uff1a\u975e\u8d39\u7528\u91d1\u989d\u3010").append(normalAndGiftTotalAmount).append("\u3011 * \u9650\u5b9a\u6bd4\u4f8b\u3010").append(orderFeeRateCalToCashResVo.getRate()).append("\u3011");
        }
        maxDiscountAmountDes.append(";\u5269\u4f59\u73b0\u91d1\u8d39\u7528\u4e3a\u3010").append(ablecashFee).append("\u3011");
        if (ablecashFee.compareTo(maxCashFee) <= 0) {
            maxDiscountAmountDes.append(",\u56e0\u6b64\u672c\u5355\u6700\u5927\u53ef\u4f7f\u7528\u73b0\u91d1\u8d39\u7528\u8c03\u6574\u4e3a:\u3010").append(ablecashFee).append("\u3011");
            maxCashFee = ablecashFee;
        }
        if (maxCashFee.compareTo(actualAmount) >= 0) {
            maxDiscountAmount = actualAmount;
            if (maxDiscountAmount.compareTo(discountAmount) < 0) {
                orderVo = this.handleErr(orderVo, maxDiscountAmount);
            }
        } else {
            maxDiscountAmount = maxCashFee;
            if (maxDiscountAmount.compareTo(discountAmount) < 0) {
                orderVo = this.handleErr(orderVo, maxDiscountAmount);
            }
        }
        actualAmount = actualAmount.subtract(discountAmount);
        orderVo.setAmount(amount.setScale(2, 4));
        orderVo.setPromotionAmount(promotionAmount.setScale(2, 4));
        orderVo.setMaxDiscountAmount(maxDiscountAmount);
        orderVo.setDiscountAmount(discountAmount.setScale(2, 4));
        orderVo.setRepAmount(repAmount.setScale(2, 4));
        orderVo.setActualAmount(actualAmount.setScale(2, 4));
        return orderVo;
    }

    public OrderVo handleErr(OrderVo orderVo, BigDecimal maxDiscountAmount) {
        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
        StringBuilder stb = new StringBuilder("\u63d0\u793a\uff1a\u6298\u6263\u8d39\u7528\u8d85\u989d\uff0c\u6700\u5927\u4f7f\u7528\u989d\u5ea6\u4e3a\u3010").append(maxDiscountAmount).append("\u3011\uff01");
        orderVo.setCalSucessMsg(stb.toString());
        return orderVo;
    }

    public BigDecimal calNormalAndGiftTotalAmount(OrderVo orderVo) {
        BigDecimal reNum = BigDecimal.ZERO;
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (!CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) {
                for (OrderDetailVo item : groupItemVo.getNormalList()) {
                    reNum = reNum.add(item.getAmount());
                }
            }
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getGiftList())) continue;
            for (OrderDetailVo item : groupItemVo.getGiftList()) {
                reNum = reNum.add(item.getAmount());
            }
        }
        return reNum;
    }

    public OrderFeeRateCalToCashResVo calCashFee(String cusCode, String orgCode, BigDecimal normalAndGiftTotalAmount) {
        OrderFeeRateCalToCashVo orderFeeRateCalToCashVo = new OrderFeeRateCalToCashVo();
        orderFeeRateCalToCashVo.setCusCode(cusCode);
        orderFeeRateCalToCashVo.setOrgCode(orgCode);
        orderFeeRateCalToCashVo.setOrderMoney(normalAndGiftTotalAmount);
        Result result = this.orderFeeRateFeign.calToCashForObj(orderFeeRateCalToCashVo);
        if (!result.isSuccess()) {
            throw new BusinessException("\u8ba2\u5355\u8d39\u7528\u914d\u7f6e\u670d\u52a1\u6b63\u5728\u91cd\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        OrderFeeRateCalToCashResVo orderFeeRateCalToCashResVo = (OrderFeeRateCalToCashResVo)result.getResult();
        return orderFeeRateCalToCashResVo;
    }

    public FeePoolAmountQueryReqVo packageFeeParam(OrderVo orderVo, String cusCode) {
        FeePoolAmountQueryReqVo vo = new FeePoolAmountQueryReqVo();
        vo.setCustomerCode(cusCode);
        ArrayList<String> poolCodeList = new ArrayList<String>();
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                poolCodeList.add(itemVo.getFeeCode());
            }
        }
        vo.setPoolCodeList(poolCodeList);
        return vo;
    }
}

