/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.strategy.validaterebate.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.dms.orderfeerate.OrderFeeRateFeign;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepProductVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToResVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAmountQueryReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.strategy.validaterebate.ValidateRebateFeeStrategy;
import com.biz.crm.util.Result;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"standerdOrderValidateFeeStategyExpand"})
@Component(value="standerdOrderValidateFeeStategy")
public class StanderdOrderValidateFeeStategy
implements ValidateRebateFeeStrategy {
    @Autowired
    private FeePoolFeign feePoolFeign;
    @Resource
    private OrderFeeRateFeign orderFeeRateFeign;

    @Override
    public OrderVo validate(OrderVo orderVo, String cusCode, String orgCode, Object ... objects) {
        BigDecimal normalAndGiftTotalAmount = this.calNormalAndGiftTotalAmount(orderVo);
        if ((orderVo = this.calRep(orderVo, cusCode, orgCode, normalAndGiftTotalAmount)).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return orderVo;
        }
        FeePoolAmountQueryReqVo feePoolAmountQueryReqVo = this.packageFeeParam(orderVo, cusCode);
        Result result = this.feePoolFeign.queryPoolAmount(feePoolAmountQueryReqVo);
        if (!result.isSuccess()) {
            throw new BusinessException("\u8d39\u7528\u670d\u52a1\u6b63\u5728\u91cd\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        FeePoolAmountQueryRespVo feePoolAmountQueryRespVo = (FeePoolAmountQueryRespVo)result.getResult();
        orderVo = this.calRapFromFee(orderVo, feePoolAmountQueryRespVo.getPoolUsableAmountMap());
        return orderVo;
    }

    public FeePoolAmountQueryReqVo packageFeeParam(OrderVo orderVo, String cusCode) {
        FeePoolAmountQueryReqVo vo = new FeePoolAmountQueryReqVo();
        vo.setCustomerCode(cusCode);
        ArrayList<String> poolCodeList = new ArrayList<String>();
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                if (itemVo.getAmount().intValue() == 0) continue;
                poolCodeList.add(itemVo.getFeeCode());
            }
        }
        vo.setPoolCodeList(poolCodeList);
        return vo;
    }

    public OrderVo calRapFromFee(OrderVo orderVo, Map<String, BigDecimal> poolMap) {
        Map<String, BigDecimal> totalFeeMap = StanderdOrderValidateFeeStategy.totalFee(orderVo);
        for (Map.Entry<String, BigDecimal> entry : totalFeeMap.entrySet()) {
            StringBuilder stb;
            String key = entry.getKey();
            String[] keys = key.split(",");
            String feeCode = keys[0];
            String feeName = keys[1];
            BigDecimal useFee = entry.getValue();
            BigDecimal ableFee = poolMap.get(feeCode);
            if (null == ableFee) {
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                stb = new StringBuilder("\u63d0\u793a\uff1a\u672c\u5355\u8d39\u7528\u3010").append(feeName).append("\u3011\u5bf9\u5e94\u7684\u8d39\u7528\u4f59\u989d\u4e3a0,\u8bf7\u91cd\u65b0\u9009\u62e9");
                orderVo.setCalSucessMsg(stb.toString());
                continue;
            }
            if (useFee.compareTo(ableFee) > 0) {
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                stb = new StringBuilder("\u63d0\u793a\uff1a\u672c\u5355\u8d39\u7528\u8d39\u7528\u3010").append(feeName).append("\u3011\u4f7f\u7528\u4e86\u3010").append(useFee).append("\u3011,\u5269\u4f59\u8d39\u7528\u3010").append(ableFee).append("\u3011\u5143,\u5df2\u7ecf\u8d85\u51fa\uff01");
                orderVo.setCalSucessMsg(stb.toString());
            }
            StanderdOrderValidateFeeStategy.setProcess(orderVo, feeCode, feeName, useFee, ableFee);
        }
        return orderVo;
    }

    public static void setProcess(OrderVo orderVo, String feeCode, String feeName, BigDecimal useFee, BigDecimal ableFee) {
        StringBuilder des = new StringBuilder("\u8d27\u8865\u8d39\u7528\u3010").append(feeName).append("\u3011\uff0c\u53ef\u4f7f\u7528\u3010").append(ableFee).append("\u3011,\u5df2\u4f7f\u7528").append(useFee);
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)group.getBackList())) continue;
            for (OrderDetailVo detail : group.getBackList()) {
                if (!detail.getFeeCode().equals(feeCode)) continue;
                detail.setBackCalDes(detail.getBackCalDes() + ";" + des);
            }
        }
    }

    public static Map<String, BigDecimal> totalFee(OrderVo orderVo) {
        HashMap<String, BigDecimal> reMap = new HashMap<String, BigDecimal>();
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)group.getBackList())) continue;
            for (OrderDetailVo detail : group.getBackList()) {
                if (detail.getAmount().intValue() == 0) continue;
                String key = detail.getFeeCode() + "," + detail.getFeeName();
                if (reMap.get(key) == null) {
                    reMap.put(key, detail.getAmount());
                    continue;
                }
                reMap.put(key, ((BigDecimal)reMap.get(key)).add(detail.getAmount()));
            }
        }
        return reMap;
    }

    public OrderVo calRep(OrderVo orderVo, String cusCode, String orgCode, BigDecimal normalAndGiftTotalAmount) {
        OrderFeeRateCalToRepVo orderFeeRateCalToRepVo = this.packageOrderFeeRepParam(orderVo, cusCode, orgCode, normalAndGiftTotalAmount);
        if (null == orderFeeRateCalToRepVo) {
            return orderVo;
        }
        Result result = this.orderFeeRateFeign.calToRepForObj(orderFeeRateCalToRepVo);
        if (!result.isSuccess()) {
            throw new BusinessException("\u8ba2\u5355\u8d39\u7528\u914d\u7f6e\u670d\u52a1\u6b63\u5728\u91cd\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Map feeMap = (Map)result.getResult();
        Map<String, BigDecimal> useFeeMap = this.totalUseFee(orderVo);
        for (Map.Entry<String, BigDecimal> entry : useFeeMap.entrySet()) {
            BigDecimal maxFee;
            String key = entry.getKey();
            String[] keys = key.split(",");
            String productCode = keys[0];
            String productName = keys[1];
            OrderFeeRateCalToResVo orderFeeRateCalToResVo = (OrderFeeRateCalToResVo)feeMap.get(productCode);
            StanderdOrderValidateFeeStategy.setProcess(orderVo, productCode, productName, entry.getValue(), orderFeeRateCalToResVo);
            if (null == orderFeeRateCalToResVo || (maxFee = orderFeeRateCalToResVo.getMaxMoney()).compareTo(entry.getValue()) >= 0) continue;
            orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
            orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
            StringBuilder stb = new StringBuilder("\u63d0\u793a\uff1a\u8d27\u8865\u5546\u54c1\u3010").append(productName).append("\u3011\u5df2\u8d85\u8fc7\u6700\u5927\u9650\u989d\u3010").append(maxFee).append("\u5143\u3011,\u8bf7\u8c03\u6574\u6570\u91cf\u6216\u8005\u52a0\u5927\u5546\u54c1\u8d2d\u4e70\u91cf\uff01");
            orderVo.setCalSucessMsg(stb.toString());
        }
        return orderVo;
    }

    public static void setProcess(OrderVo orderVo, String productCode, String productName, BigDecimal money, OrderFeeRateCalToResVo orderFeeRateCalToResVo) {
        StringBuilder des = new StringBuilder("\u672c\u5355\u8d27\u8865\u5546\u54c1\u3010").append(productName).append("\u3011\uff0c\u6700\u5927\u4f7f\u7528\u989d\u4e3a\u3010").append(orderFeeRateCalToResVo.getMaxMoney()).append("\u3011");
        if (null == orderFeeRateCalToResVo) {
            des.append(",\u65e0\u6bd4\u4f8b\u9650\u5236");
        } else {
            des.append(",\u8ba1\u7b97\u8fc7\u7a0b:\u672c\u5355\u975e\u8d27\u8865\u5546\u54c1\u989d\u5ea6\u3010").append(orderFeeRateCalToResVo.getCalMoney()).append("\u3011 * \u672c\u5355\u9650\u5236\u6bd4\u4f8b\u3010").append(orderFeeRateCalToResVo.getRate()).append("%\u3011");
        }
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)group.getBackList())) continue;
            for (OrderDetailVo detail : group.getBackList()) {
                if (!detail.getProductCode().equals(productCode)) continue;
                detail.setBackCalDes(des.toString());
            }
        }
    }

    public Map<String, BigDecimal> totalUseFee(OrderVo orderVo) {
        HashMap<String, BigDecimal> useFeeMap = new HashMap<String, BigDecimal>();
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                BigDecimal useFee = useFeeMap.get(StanderdOrderValidateFeeStategy.splicingProductCodeAndName(itemVo.getProductCode(), itemVo.getProductName())) == null ? BigDecimal.ZERO : (BigDecimal)useFeeMap.get(itemVo.getProductCode());
                useFeeMap.put(StanderdOrderValidateFeeStategy.splicingProductCodeAndName(itemVo.getProductCode(), itemVo.getProductName()), useFee.add(itemVo.getAmount()));
            }
        }
        return useFeeMap;
    }

    public static String splicingProductCodeAndName(String productCode, String productName) {
        return productCode + "," + productName;
    }

    public OrderFeeRateCalToRepVo packageOrderFeeRepParam(OrderVo orderVo, String cusCode, String orgCode, BigDecimal normalAndGiftTotalAmount) {
        OrderFeeRateCalToRepVo orderFeeRateCalToRepVo = new OrderFeeRateCalToRepVo();
        orderFeeRateCalToRepVo.setCusCode(cusCode);
        orderFeeRateCalToRepVo.setOrgCode(orgCode);
        orderFeeRateCalToRepVo.setOrderMoney(normalAndGiftTotalAmount);
        ArrayList<OrderFeeRateCalToRepProductVo> products = new ArrayList<OrderFeeRateCalToRepProductVo>();
        orderFeeRateCalToRepVo.setProducts(products);
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                OrderFeeRateCalToRepProductVo orderFeeRateCalToRepProductVo = new OrderFeeRateCalToRepProductVo();
                orderFeeRateCalToRepProductVo.setProductCode(itemVo.getProductCode());
                orderFeeRateCalToRepProductVo.setProductLevelCode(itemVo.getProductLevelCode());
                products.add(orderFeeRateCalToRepProductVo);
            }
        }
        if (CollectionUtils.isEmpty(products)) {
            return null;
        }
        return orderFeeRateCalToRepVo;
    }

    public BigDecimal calNormalAndGiftTotalAmount(OrderVo orderVo) {
        BigDecimal reNum = BigDecimal.ZERO;
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (!CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) {
                for (OrderDetailVo item : groupItemVo.getNormalList()) {
                    reNum = reNum.add(item.getAmount());
                }
            }
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getGiftList())) continue;
            for (OrderDetailVo item : groupItemVo.getGiftList()) {
                reNum = reNum.add(item.getAmount());
            }
        }
        return reNum;
    }
}

