/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.strategy.calpromotion.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.dms.promotion.PromotionV2Feign;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.strategy.calpromotion.CalPromotionStrategy;
import com.biz.crm.order.utils.OrderUtil;
import com.biz.crm.util.Result;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"buyAndGiftCalPromotionStrategyExpand"})
@Component(value="buyAndGiftCalPromotionStrategy")
public class BuyAndGiftCalPromotionStrategy
implements CalPromotionStrategy {
    @Autowired
    private PromotionV2Feign promotionV2Feign;

    @Override
    public OrderVo cal(OrderVo orderVo, String cusCode, String orgCode, Integer calNum, Object ... objects) {
        BuyAndGiftCalPromotionStrategy.validateParam(orderVo);
        if (!OrderUtil.judegeOrder(orderVo)) {
            return orderVo;
        }
        ArrayList<PromotionQueryReq> param = BuyAndGiftCalPromotionStrategy.packageParam(orderVo, cusCode, orgCode, objects);
        if (CollectionUtils.isEmpty(param)) {
            return orderVo;
        }
        Result result = this.promotionV2Feign.findHitPromotionMapByPromotionCodes(param);
        if (!result.isSuccess()) {
            throw new BusinessException("\u4fc3\u9500\u670d\u52a1\u6b63\u5728\u91cd\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Map promotionMap = (Map)result.getResult();
        return BuyAndGiftCalPromotionStrategy.cal(orderVo, promotionMap, calNum);
    }

    public static OrderVo cal(OrderVo orderVo, Map<String, PromotionEditVo> promotionMap, Integer calNum) {
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            boolean judegeFlag;
            StringBuilder stb;
            if (group.getBuyAndGiveFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) continue;
            PromotionEditVo promotionEditVo = promotionMap.get(group.getPromotionCode());
            if (null == promotionEditVo) {
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.PROMOTION.getCode());
                stb = new StringBuilder("\u63d0\u793a\uff1a\u4fc3\u9500\u3010").append(group.getPromotionName()).append("\u3011\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f");
                BuyAndGiftCalPromotionStrategy.zPromotionError(group, stb.toString(), group.getPromotionCode());
                return orderVo;
            }
            if (promotionEditVo.getMultipleable().equals(YesNoEnum.yesNoEnum.NO.getValue()) && BuyAndGiftCalPromotionStrategy.judegeNum(group, promotionEditVo.getPromotionPolicyCode())) {
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.PROMOTION.getCode());
                stb = new StringBuilder("\u63d0\u793a\uff1a\u4fc3\u9500\u3010").append(group.getPromotionName()).append("\u3011\u4e0d\u80fd\u53e0\u52a0");
                BuyAndGiftCalPromotionStrategy.zPromotionError(group, stb.toString(), group.getPromotionCode());
            }
            if (!promotionEditVo.isMatchState()) {
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.PROMOTION.getCode());
                BuyAndGiftCalPromotionStrategy.zPromotionError(group, promotionEditVo.getMatchMsg(), group.getPromotionCode());
                return orderVo;
            }
            List gifts = (List)promotionEditVo.getProductMap().get("giftProducts");
            if (CollectionUtils.isEmpty((Collection)gifts)) {
                group.setGiftList(new ArrayList());
            }
            if (!(judegeFlag = BuyAndGiftCalPromotionStrategy.validateGiftGoods(gifts, group))) {
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                return orderVo;
            }
            BuyAndGiftCalPromotionStrategy.calPrice(group, promotionEditVo, calNum);
            if (OrderUtil.judegeOrderGroup(group)) continue;
            orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
            orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GROUP.getCode());
            return orderVo;
        }
        return orderVo;
    }

    public static void zPromotionError(OrderGroupItemVo group, String msg, String promotionCode) {
        for (OrderDetailVo detail : group.getNormalList()) {
            if (CollectionUtils.isEmpty((Collection)detail.getPromotionVos())) continue;
            for (OrderDetailPromotionVo promotion : detail.getPromotionVos()) {
                if (!promotion.getPromotionCode().equals(promotionCode)) continue;
                promotion.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                promotion.setCalSucessMsg(msg);
            }
        }
    }

    public static void calPrice(OrderGroupItemVo group, PromotionEditVo promotionEditVo, Integer calNum) {
        BigDecimal promotionAmount = BigDecimal.ZERO;
        BigDecimal promotionNum = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)group.getGiftList())) {
            for (OrderDetailVo gift : group.getGiftList()) {
                promotionAmount = promotionAmount.add(gift.getProductNum().multiply(gift.getPrice()).setScale(6, 4));
                promotionNum = promotionNum.add(gift.getProductNum());
            }
        }
        if (group.getPromotionAmount() == null) {
            group.setPromotionAmount(BigDecimal.ZERO);
        }
        group.setPromotionAmount(group.getPromotionAmount().add(promotionAmount));
        group.setPromotionName(promotionEditVo.getPromotionPolicyName());
        for (OrderDetailVo detail : group.getNormalList()) {
            if (CollectionUtils.isEmpty((Collection)detail.getPromotionVos())) continue;
            for (OrderDetailPromotionVo promotion : detail.getPromotionVos()) {
                if (!promotion.getPromotionCode().equals(promotionEditVo.getPromotionPolicyCode())) continue;
                promotion.setPromotionName(promotionEditVo.getPromotionPolicyName());
                promotion.setPromotionType(promotionEditVo.getPromotionType());
                promotion.setPromotionPolicyId(promotionEditVo.getId());
                promotion.setSortNum(calNum);
                promotion.setPromotionAmount(group.getPromotionAmount());
                promotion.setPromotionDes("\u4e70\u8d60\u6d3b\u52a8\u672c\u54c1\u91d1\u989d\u4e0d\u53d8\uff0c\u8d60\u54c1\u4ef7\u503c\u8be6\u60c5\u8bf7\u770b\u8d60\u54c1\uff01");
            }
        }
        StringBuilder stb = new StringBuilder();
        if (promotionEditVo.getCalculateHitResultVo().getValueType().equals("number")) {
            stb.append("\u8d60\u54c1\u53ef\u9009\u6570\u91cf\u3010").append(promotionEditVo.getCalculateHitResultVo().getValue()).append("\u3011,\u5df2\u9009\u3010").append(promotionNum).append("\u3011,");
            if (promotionEditVo.getCalculateHitResultVo().getValue().compareTo(promotionNum) >= 0) {
                stb.append("\u8fd8\u53ef\u4ee5\u9009\u62e9\u3010").append(promotionEditVo.getCalculateHitResultVo().getValue().subtract(promotionNum)).append("\u3011");
                group.setBuyAndGiveMsg(stb.toString());
            } else {
                stb.append("\u5df2\u8d85\u51fa");
                group.setBuyAndGiveMsg(stb.toString());
                group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                group.setCalSucessMsg(stb.toString());
            }
        } else {
            stb.append("\u8d60\u54c1\u53ef\u9009\u91d1\u989d\u3010").append(promotionEditVo.getCalculateHitResultVo().getValue()).append("\u3011,\u5df2\u9009\u3010").append(promotionAmount).append("\u3011,");
            if (promotionEditVo.getCalculateHitResultVo().getValue().compareTo(promotionAmount) >= 0) {
                stb.append("\u8fd8\u53ef\u4ee5\u9009\u62e9\u3010").append(promotionEditVo.getCalculateHitResultVo().getValue().subtract(promotionAmount)).append("\u3011");
                group.setBuyAndGiveMsg(stb.toString());
            } else {
                stb.append("\u5df2\u8d85\u51fa");
                group.setBuyAndGiveMsg(stb.toString());
                group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                group.setCalSucessMsg(stb.toString());
            }
        }
        group.setBuyAndGiveMsg(stb.toString());
    }

    public static boolean validateGiftGoods(List<PromotionProductVo> promotionGifts, OrderGroupItemVo group) {
        if (CollectionUtils.isEmpty((Collection)group.getGiftList())) {
            return true;
        }
        for (OrderDetailVo detail : group.getGiftList()) {
            if (BuyAndGiftCalPromotionStrategy.exsitProductByCode(detail.getProductCode(), promotionGifts)) continue;
            detail.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
            StringBuilder stb = new StringBuilder("\u63d0\u793a\uff1a\u6ca1\u6709\u8be5\u9879\u8d60\u54c1\u6216\u8d60\u54c1\u5df2\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            detail.setCalSucessMsg(stb.toString());
            return false;
        }
        return true;
    }

    public static boolean exsitProductByCode(String productCode, List<PromotionProductVo> promotionGifts) {
        if (StringUtils.isEmpty((Object)productCode)) {
            return true;
        }
        if (CollectionUtils.isEmpty(promotionGifts)) {
            return false;
        }
        for (PromotionProductVo promotionProductVo : promotionGifts) {
            if (!promotionProductVo.getProductCode().equals(productCode)) continue;
            return true;
        }
        return false;
    }

    public static boolean judegeNum(OrderGroupItemVo group, String promotionCode) {
        if (CollectionUtils.isEmpty((Collection)group.getNormalList())) {
            return false;
        }
        for (OrderDetailVo detail : group.getNormalList()) {
            if (CollectionUtils.isEmpty((Collection)detail.getPromotionVos()) || detail.getPromotionVos().size() == 1) continue;
            for (OrderDetailPromotionVo promotionVo : detail.getPromotionVos()) {
                if (!promotionCode.equals(promotionVo.getPromotionCode())) continue;
                return true;
            }
        }
        return false;
    }

    public static ArrayList<PromotionQueryReq> packageParam(OrderVo orderVo, String cusCode, String orgCode, Object ... objects) {
        ArrayList<PromotionQueryReq> reList = new ArrayList<PromotionQueryReq>();
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            if (group.getBuyAndGiveFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) continue;
            PromotionQueryReq req = new PromotionQueryReq();
            req.setAccountCode(cusCode);
            req.setAccountType("customer");
            ArrayList<PromotionSaleProductVo> saleProductVos = new ArrayList<PromotionSaleProductVo>();
            ArrayList<String> promotionCodes = new ArrayList<String>();
            promotionCodes.add(group.getPromotionCode());
            req.setPromotionCodes(promotionCodes);
            for (OrderDetailVo detail : group.getNormalList()) {
                if (CollectionUtils.isEmpty((Collection)detail.getPromotionVos())) continue;
                for (OrderDetailPromotionVo promotion : detail.getPromotionVos()) {
                    if (!promotion.getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())) continue;
                    PromotionSaleProductVo product = new PromotionSaleProductVo();
                    product.setProductCode(detail.getProductCode());
                    product.setBuyCount(detail.getProductNum());
                    product.setBuyAmount(detail.getAmount());
                    product.setPrice(detail.getPrice());
                    saleProductVos.add(product);
                }
            }
            req.setSaleProductVos(saleProductVos);
            reList.add(req);
        }
        return reList;
    }

    public static OrderVo validateParam(OrderVo orderVo) {
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            StringBuilder stb;
            OrderDetailVo detail2;
            if (group.getBuyAndGiveFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
                for (OrderDetailVo detail2 : group.getNormalList()) {
                    if (CollectionUtils.isEmpty((Collection)detail2.getPromotionVos())) continue;
                    for (OrderDetailPromotionVo promotion : detail2.getPromotionVos()) {
                        if (!promotion.getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())) continue;
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GROUP.getCode());
                        group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb2 = new StringBuilder("\u63d0\u793a\uff1a\u9519\u8bef\u8ba2\u5355\uff0c\u666e\u901a\u5757\u51fa\u73b0\u4e70\u8d60\u4fc3\u9500");
                        group.setCalSucessMsg(stb2.toString());
                        return orderVo;
                    }
                }
                group.setGiftList(new ArrayList());
                continue;
            }
            HashSet<String> promotionCodeSet = new HashSet<String>();
            detail2 = group.getNormalList().iterator();
            while (detail2.hasNext()) {
                OrderDetailVo detail3 = (OrderDetailVo)detail2.next();
                if (CollectionUtils.isEmpty((Collection)detail3.getPromotionVos())) continue;
                for (OrderDetailPromotionVo promotion : detail3.getPromotionVos()) {
                    if (!promotion.getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())) continue;
                    promotionCodeSet.add(promotion.getPromotionCode());
                }
            }
            if (promotionCodeSet.size() == 0) {
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GROUP.getCode());
                group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                stb = new StringBuilder("\u63d0\u793a\uff1a\u9519\u8bef\u8ba2\u5355\uff0c\u4e70\u8d60\u5757\u6ca1\u6709\u4e70\u8d60\u4fc3\u9500\uff01");
                group.setCalSucessMsg(stb.toString());
                return orderVo;
            }
            if (promotionCodeSet.size() > 1) {
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GROUP.getCode());
                group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                stb = new StringBuilder("\u63d0\u793a\uff1a\u9519\u8bef\u8ba2\u5355\uff0c\u4e70\u8d60\u5757\u4fc3\u9500\u591a\u4e2a\u4e70\u8d60\u4fc3\u9500\uff01");
                group.setCalSucessMsg(stb.toString());
                return orderVo;
            }
            if (promotionCodeSet.contains(group.getPromotionCode())) continue;
            orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
            orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GROUP.getCode());
            group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
            stb = new StringBuilder("\u63d0\u793a\uff1a\u9519\u8bef\u8ba2\u5355\uff0c\u4e70\u8d60\u5757\u4fc3\u9500\u8ddf\u4e70\u8d60\u5757\u4e0d\u540c\uff01");
            group.setCalSucessMsg(stb.toString());
            return orderVo;
        }
        return orderVo;
    }
}

